# Encodage : UTF-8
# Nom : Coel v1.0
# Date de création : 2009-07-30 11:41:43
#---------------------------------------------------------------------------------------------------------------------#
# Création des tables
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_collection` (
	`cc_id_collection` INTEGER NOT NULL auto_increment  COMMENT 'Identifiant de la collection.',
	`cc_ce_projet` INTEGER NOT NULL   COMMENT 'Identifiant du projet dans lequel les informations de la collection sont saisies.',
	`cc_ce_mere` INTEGER NOT NULL  default 0 COMMENT 'Identifiant de la collection parente. Si la collection courrante n''a pas de parente laisser la valeur 0 par défaut.',
	`cc_ce_structure` INTEGER NOT NULL  default 0 COMMENT 'Identifiant de la structure habritant physiquement la collection. Si c''est un particulier, laisser la valeur 0 par défaut et utiliser la table liant les collections aux personnes.',
	`cc_guid` VARCHAR(255)    COMMENT 'Identifiant global unique de type LSID ou URI.',
	`cc_truk_identifiant_alternatif` VARCHAR(255)    COMMENT 'Autres identifiants de la structure.',
	`cc_truk_code` VARCHAR(100)    COMMENT 'Code(s) de la collection.',
	`cc_nom` VARCHAR(255)    COMMENT 'Nom de la collection dans la langue d''origine. Afficher vis à vis du public.',
	`cc_truk_nom_alternatif` TEXT    COMMENT 'Nom alternatif de la collection.',
	`cc_description` TEXT    COMMENT 'Description principale de la collection pour un large public.',
	`cc_description_specialiste` TEXT    COMMENT 'Description de la collection pour un public de spécialistes.',
	`cc_historique` TEXT    COMMENT 'Historique de la collection (acquisition, différentes interventions de restauration, de traitement ...).',
	`cc_truk_url` VARCHAR(255)    COMMENT 'URL(s) du site web ou de la page concernant la collection.',
	`cc_truk_url_objet` VARCHAR(255)    COMMENT 'URL(s) indiquant un web service ou une page permettant d''accèder à des informations sur les objets de la collection.',
	`cc_truk_groupement_principe` VARCHAR(255)    COMMENT 'Principal but de groupement de la collection au niveau intélectuel plutôt que physique.',
	`cc_truk_groupement_but` INTEGER    COMMENT 'Principal but de réalisation de la collection.',
	`cc_ce_type` INTEGER    COMMENT 'Type de la collection vis à vis du standard NCD.',
	`cc_ce_type_depot` INTEGER    COMMENT 'Type de dépôt de la collection.',
	`cc_cote` VARCHAR(255)    COMMENT 'Côte de la collection.',
	`cc_dimenssion` VARCHAR(255)    COMMENT 'Dimenssion, taille de la collection sous forme de texte libre.',
	`cc_condition_acces` TEXT    COMMENT 'Condition d''accès à la collection. Peut être définit par défaut par la structure.',
	`cc_condition_usage` TEXT    COMMENT 'Condition d''usages de la collection. Peut être définit par défaut par la structure.',
	`cc_truk_couverture_vernaculaire` VARCHAR(255)    COMMENT 'Nature de la collection sous forme de nom(s) vernaculaire(s).',
	`cc_truk_couverture_taxonomique` VARCHAR(255)    COMMENT 'Nom de famille ou de taxons supérieurs présent dans la collection.',
	`cc_truk_couverture_regne` VARCHAR(255)    COMMENT 'Liste des règnes couverts par la collection.',
	`cc_truk_couverture_temporelle` VARCHAR(255)    COMMENT 'Période de temps couverte par la collection.',
	`cc_truk_couverture_vie` VARCHAR(255)    COMMENT 'Période de temps durant laquelle le matériel biologique était en vie. Inclu les périodes de temps paléontologiques.',
	`cc_truk_conservation_statut` VARCHAR(255)    COMMENT 'Indiquer la date d''une estimation séparée par un dièse du statut estimé utilisant l''échelle de McGinley. Plusieurs estimations seront séparés par un point virgule.',
	`cc_truk_preservation` VARCHAR(255)    COMMENT 'Liste indiquant les procédures ou techniques de conservation utilisées pour les collections non vivantes.',
	`cc_ce_developpement` VARCHAR(255)    COMMENT 'Indique le changement potentiel dans la portée de la collection.',
	`cc_truk_periode_constitution` VARCHAR(255)    COMMENT 'Liste de périodes de temps durant laquelle la collection a été assemblée.',
	`cc_truk_couverture_lieu` VARCHAR(255)    COMMENT 'Liste de lieux (continent, pays, region, département, commune, autres lieux historique ou texte libre) desquels le matériel de la collection est originaire.',
	`cc_truk_coordonnee` VARCHAR(255)    COMMENT 'Liste de coordonnées décimales des lieux d''origine du matériel de la collection.',
	`cc_ce_specimen_type` INTEGER    COMMENT 'Y-a-t''il des échantillons-types?',
	`cc_specimen_type_nbre` INTEGER    COMMENT 'Nombre de spécimen type présent dans la collection.',
	`cc_mark_speciment_type_nbre_precision` BOOL    COMMENT 'Précision sur le nombre de spécimens types indiqué (1 = exact, 0 = approximatif).',
	`cc_ce_specimen_type_classement` INTEGER    COMMENT 'Type de classement des specimens types.',
	`cc_expedition_nom` VARCHAR(255)    COMMENT 'Nom de l''expédition durant laquelle le matériel a été collecté.',
	`cc_truk_digital_medium` VARCHAR(255)    COMMENT 'Pour les collections digitales, listes des types de support d''enregistrement. Ex. : DVD-R.',
	`cc_truk_digital_format` VARCHAR(255)    COMMENT 'Pour les collections digitales, listes des types MIME.',
	`cc_mark_public` BOOL   default 0 COMMENT 'Indique si oui (=1) ou non (=0) les données de cette collection sont publiques.',
	`cc_ce_meta` INTEGER NOT NULL   COMMENT 'Identifiant des métadonnées de cet enregistrement.',
PRIMARY KEY(`cc_id_collection`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Contient les informations sur les collections.\n' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_structure` (
	`cs_id_structure` INTEGER NOT NULL auto_increment  COMMENT 'Identifiant de la structure.',
	`cs_ce_projet` INTEGER NOT NULL   COMMENT 'Identifiant du projet dans lequel les informations de la structure sont saisies.',
	`cs_ce_mere` INTEGER NOT NULL  default 0 COMMENT 'Identifiant de la structure mère.',
	`cs_guid` VARCHAR(255)    COMMENT 'URI (LSID ou URL) de la structure. Dans le format RDF, cela sera utilisé comme URI des données de l''institutions.',
	`cs_truk_identifiant_alternatif` VARCHAR(255)    COMMENT 'Identifiant alternatif. Par exemple, l''acronyme de l''Index Herbariorum ou du MNHN. Séparer les différentes valeurs par un point virgule ";" et le type d''identifiant de sa valeur par un dièze "#". Exemple : IH#MPU;MNHN#163',
	`cs_nom` VARCHAR(255)    COMMENT 'Nom officiel de la structure dans sa langue d''origine.',
	`cs_truk_nom_alternatif` VARCHAR(255)    COMMENT 'Autres noms de la structures. Séparer les différentes valeurs par un point virgule ";".',
	`cs_description` TEXT    COMMENT 'Description de la structure pour le public.',
	`cs_ce_type` INTEGER    COMMENT 'Identifiant du type de la structure vis à vis du standard NCD.',
	`cs_ce_truk_type_prive` VARCHAR(255)    COMMENT 'Type privé de structure.',
	`cs_ce_truk_type_public` VARCHAR(255)    COMMENT 'Type public de structure.',
	`cs_adresse_01` VARCHAR(255)    COMMENT 'Adresse principale.',
	`cs_adresse_02` VARCHAR(255)    COMMENT 'Complément d''adresse.',
	`cs_date_fondation` DATE    COMMENT 'Date de fondation de la structure.',
	`cs_code_postal` VARCHAR(16)    COMMENT 'Code postal.',
	`cs_ville` VARCHAR(255)    COMMENT 'Ville.',
	`cs_region` VARCHAR(255)    COMMENT 'Nom de la région (état, province) où est situé la structure. Utiliser les noms du standard ISO-3166-2.',
	`cs_pays` VARCHAR(255)    COMMENT 'Pays de la structure. Utiliser les codes sur deux lettres si le nom est dans le standard ISO-3166-1 sinon mettre le nom du pays.',
	`cs_latitude` FLOAT    COMMENT 'Latitude du local de la structure.',
	`cs_longitude` FLOAT    COMMENT 'Longitude du local de la structure.',
	`cs_telephone` VARCHAR(50)    COMMENT 'Téléphone principale de la structure.',
	`cs_fax` VARCHAR(50)    COMMENT 'Fax de la structure.',
	`cs_courriel` VARCHAR(255)    COMMENT 'Courriel principal de contact de l''organisation ex : accueil@organisation.org, pas de mail individuel.',
	`cs_truk_url` VARCHAR(255)    COMMENT 'URL(s) du site web principal de la structure, du logo de la structure ou d''une page web particulière.',
	`cs_nbre_personne` INTEGER    COMMENT 'Nombre de personne présentent dans la structure.',
	`cs_condition_acces` TEXT    COMMENT 'Conditions d''accès à la structure.',
	`cs_condition_usage` TEXT    COMMENT 'Conditions d''usage générales des collections de la structure.',
	`cs_mark_public` BOOL   default 0 COMMENT 'Indique si oui (=1) ou non (=0) les données de cette structure sont publiques.',
	`cs_ce_meta` INTEGER NOT NULL   COMMENT 'Identifiant des métadonnées de cet enregistrement.',
PRIMARY KEY(`cs_id_structure`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Contient les informations sur les structures.\n' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_personne` (
	`cp_id_personne` INTEGER NOT NULL auto_increment  COMMENT 'Identifiant d''un contact.',
	`cp_ce_projet` INTEGER NOT NULL   COMMENT 'Identifiant du projet auquel la personne appartient. Exemple : utilisateur appli coel, HUH, IPNI...',
	`cp_fmt_nom_complet` VARCHAR(100)    COMMENT 'Nom complet du contact formaté pour l''affichage (le format peut être différent en fonction du projet).',
	`cp_ce_truk_prefix` VARCHAR(20)    COMMENT 'Préfixe du nom principal. Exemple : Dr., Prof., Mr., Lord, von...',
	`cp_prenom` VARCHAR(100)    COMMENT 'Prénom principal (le plus connu, répandu) de la personne. Un point virgule peut séparer le prénom principal de prénoms secondaires à ne pas afficher dans le nom complet.',
	`cp_nom` VARCHAR(100)    COMMENT 'Indiquer les lieux de récolte (code ISO des pays) séparés par des points virgules. Après chaque code ISO indiqué les années de récolte séparées par des vigules ou des tirets pour les périodes continues). Si le pays de récolte est inconnu utilisé un point d''interogration. Exemple : FR#1905-1908,1910;PS#1912.',
	`cp_ce_truk_suffix` VARCHAR(20)    COMMENT 'Suffixe du nom principal. Exemple : Jr, III.',
	`cp_truk_nom_autre` VARCHAR(255)    COMMENT 'Nom(s) complet alternatif et surnoms. Pour les valeurs, séparez l''identifiant de l''abreviation par un symbole pipe "|". Exemple: HUH#105714|Sharp, Aaron John;APN#9544-1|Sharp, Aaron John (''Jack'')',
	`cp_abreviation` VARCHAR(50)    COMMENT 'Abreviation retenu du nom.',
	`cp_truk_abreviation_autre` VARCHAR(255)    COMMENT 'Autres abréviations du nom.',
	`cp_naissance_date` DATE   default "0000-00-00" COMMENT 'Date de naissance de la personne.',
	`cp_naissance_lieu` VARCHAR(100)    COMMENT 'Lieu de naissance de la personne.',
	`cp_deces_date` DATE    COMMENT 'Date de décés de la personne. Par défaut, si la personne n''est pas décédé le champ reste null. Si la personne est décédée mais que l''on ne connait pas la date mettre : 0000-00-00',
	`cp_deces_lieu` VARCHAR(100)    COMMENT 'Lieu de décés de la personne.',
	`cp_ce_sexe` INTEGER    COMMENT 'Indique si la personne est un homme ou une femme...',
	`cp_description` TEXT    COMMENT 'Informations diverses sur la personne.',
	`cp_biographie` TEXT    COMMENT 'Vie et renommée (locale, régionale, ...) de la personne.',
	`cp_adresse_01` VARCHAR(255)    COMMENT 'Adresse de la personne.',
	`cp_adresse_02` VARCHAR(255)    COMMENT 'Complément d''adresse personnelle.',
	`cp_region` VARCHAR(100)    COMMENT 'Nom de la région (état, province) où vit la personne. Utiliser les noms du standard ISO-3166-2.',
	`cp_bp` VARCHAR(20)    COMMENT 'Boite postale de l''adresse de la personne.',
	`cp_code_postal` VARCHAR(10)    COMMENT 'Code postal (zip) personnel.',
	`cp_ville` VARCHAR(100)    COMMENT 'Nom de la localité (ville) où vit la personne.',
	`cp_pays` VARCHAR(100)    COMMENT 'Nom du pays où vit la personne. Utiliser les noms du standard ISO-3166-1.',
	`cp_truk_telephone` VARCHAR(255)    COMMENT 'Numéro(s) de téléphone, pager... personnels complémentaires.',
	`cp_truk_fax` VARCHAR(255)    COMMENT 'Numéro(s) de fax.',
	`cp_truk_courriel` VARCHAR(255)    COMMENT 'Adresse(s) de courriel personnel. Ajouter les adresses dans leur ordre d''importance.',
	`cp_truk_url` VARCHAR(255)    COMMENT 'URL(s) de site web personnel. Ajouter les adresses dans leur ordre d''importance.',
	`cp_truk_logo` VARCHAR(255)    COMMENT 'URL(s) de logo personnel. Ajouter les adresses dans leur ordre d''importance.',
	`cp_ce_truk_specialite` VARCHAR(255)    COMMENT 'Indiquer séparer par des points virgules ";" les spécialités naturalistes de la personne.',
	`cp_truk_recolte` VARCHAR(255)    COMMENT 'Indiquer les lieux de récolte séparés par des points virgules. Indiquer le référentiel géographique utilisé puis après un # mettre le code ou identitifiant de la zone géographique. Après chaque code ISO un peut signe pipe | peut être suivi des années de récolte séparées par des vigules ou des tirets pour les périodes continues). Si le pays de récolte est inconnu utilisé un point d''interogration. Exemple : ISO-3166-1#FR|1905-1908,1910;ISO-3166-1#PS|1912;ISO-3166-2#FR-34|1917.',
	`cp_ce_truk_role` VARCHAR(255)    COMMENT 'Rôle générale de la personne vis à vis de l''ensemble des projets : superadmin, admin...',
	`cp_mark_licence` BOOL   default 0 COMMENT 'Indique quand la valeur vaut 1 que l''utilisateur a accepté la licence d''utilisation de l''application. ',
	`cp_parametre` TEXT    COMMENT 'Parametres de l''utilisateur vis à vis de l''application.',
	`cp_session_id` VARCHAR(100)    COMMENT 'Identifiant de session de la personne utilisatrice de l''application.',
	`cp_login` VARCHAR(50)    COMMENT 'Login de la personne pour accéder à l''application.',
	`cp_mot_de_passe` VARCHAR(100)    COMMENT 'Mot de passe de la personne pour accéder à l''application. Encodé par SHA1.',
	`cp_ce_annuaire_tela` INTEGER    COMMENT 'Identifiant de la personne dans l''annuaire de Tela Botanica.',
	`cp_mark_public` BOOL   default 0 COMMENT 'Indique si oui (=1) ou non (=0) les données de cette personne sont publiques.',
	`cp_ce_meta` INTEGER NOT NULL   COMMENT 'Identifiant des métadonnées de cet enregistrement.',
PRIMARY KEY(`cp_id_personne`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Contient les informations sur les personnes.\nPar personne nous entendons à la fois les utilisateurs de l''application mais aussi les personnes contacts, les botanistes collecteurs, auteurs...\n' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_structure_a_personne` (
	`csap_id_structure` INTEGER NOT NULL   COMMENT 'Identifiant de la structure.',
	`csap_id_personne` INTEGER NOT NULL   COMMENT 'Identifiant d''une personne.',
	`csap_id_role` INTEGER NOT NULL   COMMENT 'Rôle de la personne vis à vis de la structure.',
	`csap_ce_truk_fonction` VARCHAR(255)    COMMENT 'Intitulé de la fonction de la personne dans son travail.',
	`csap_service` VARCHAR(100)    COMMENT 'Nom du service ou département dans lequel la personne travaille.',
	`csap_ce_truk_statut` VARCHAR(255)    COMMENT 'Statut(s) de la personne : salarié, bénévole...',
	`csap_mark_contact` BOOL   default 0 COMMENT 'Si la personne est un contact la valeur vaut 1 sinon c''est 0.',
	`csap_bota_travail_hebdo_tps` INTEGER    COMMENT 'Date de la dernière modification sur cet enregistrement.',
	`csap_ce_meta` INTEGER NOT NULL   COMMENT 'Identifiant des métadonnées de cet enregistrement.',
PRIMARY KEY(`csap_id_structure`, `csap_id_personne`, `csap_id_role`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Table de liaison permettant d''indiquer la composition de la structure en personnel.\nElle permet d''indiquer pour une personne vis à vis d''une structure :\n - si elle est contact\n - les informations de la personne spécifique à cette structure (ex. : téléphone du travail, fonction, service, statut...).' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_meta_donnee` (
	`cmd_id_donnee` INTEGER NOT NULL auto_increment  COMMENT 'Identifiant de la donnée.',
	`cmd_ce_table` INTEGER NOT NULL   COMMENT 'Identifiant de la table.',
	`cmd_ce_ligne` VARCHAR(64) NOT NULL   COMMENT 'Identifiant de la ligne à laquelle le champ dans la table d''origine appartient. Pour les tables à clé primaire multi colonnes, bien respecter l''ordre des champs de la clé et inscrire chaque valeur de clé séparée par un tiret "-".',
	`cmd_ce_champ` INTEGER NOT NULL   COMMENT 'Identifiant du champ.',
	`cmd_valeur` VARCHAR(255) NOT NULL   COMMENT 'Valeur.',
PRIMARY KEY(`cmd_id_donnee`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Contient les champs supplémentaires (non standard ou de spécialisation) de la base de données.' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_meta_colonne` (
	`cmc_id_champ` INTEGER NOT NULL auto_increment  COMMENT 'Identifiant du nom du champ dans la table.',
	`cmc_ce_projet` INTEGER NOT NULL   COMMENT 'Identifiant du projet.',
	`cmc_ce_liste` INTEGER NOT NULL   COMMENT 'Identifiant de la liste de valeur possédée par cette colonne.',
	`cmc_ce_table` INTEGER NOT NULL   COMMENT 'Identifiant de la table à laquelle ce champ appartient.',
	`cmc_nom` VARCHAR(50)    COMMENT 'Intitulé du champ.',
	`cmc_abreviation` VARCHAR(20)    COMMENT 'Abréviation du champ.',
	`cmc_description` VARCHAR(510)    COMMENT 'Description du champ.',
	`cmc_ce_format_sql` INTEGER    COMMENT 'Identifiant du format SQL utilisé pour ce champ.',
	`cmc_taille` VARCHAR(20)    COMMENT 'Taille du format SQL du champ.',
	`cmc_ce_meta` INTEGER NOT NULL   COMMENT 'Identifiant des métadonnées de cet enregistrement.',
PRIMARY KEY(`cmc_id_champ`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Contient l''ensemble des champs des tables de la base de données.\n' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_meta_liste_valeur` (
	`cmlv_id_valeur` INTEGER NOT NULL auto_increment  COMMENT 'Identifiant d''une valeur de liste. Notez que les listes sont des valeurs de la liste des listes.',
	`cmlv_ce_parent` INTEGER NOT NULL   COMMENT 'Identifiant de la catégorie ou des informations sur la liste. Les listes ont pour parent la valeur 0 qui correspond à la liste des listes.',
	`cmlv_ce_projet` INTEGER NOT NULL   COMMENT 'Identifiant du projet de la valeur.',
	`cmlv_nom` VARCHAR(100)    COMMENT 'Nom de la valeur.',
	`cmlv_abreviation` VARCHAR(50)    COMMENT 'Abréviation, code ou identifiant de la valeur.',
	`cmlv_description` VARCHAR(255)    COMMENT 'Description de cette valeur.',
	`cmlv_ce_meta` INTEGER NOT NULL   COMMENT 'Identifiant des métadonnées de cet enregistrement.',
PRIMARY KEY(`cmlv_id_valeur`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Liste l''ensemble des valeurs des tables de type liste.\nUn champ contient des valeurs dans cette table quand il est de type "LISTE".\n' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_meta_historique_colonne` (
	`cmhc_id_historique_colonne` INTEGER NOT NULL auto_increment  COMMENT 'Identifiant de cet enregistrement historisé.',
	`cmhc_ce_historique_ligne` INTEGER NOT NULL   COMMENT 'Identifiant des métadonnées de cet enregistrement.',
	`cmhc_ce_champ` INTEGER NOT NULL   COMMENT 'Identifiant du champ.',
	`cmhc_valeur` VARCHAR(255) NOT NULL   COMMENT 'Valeur du champ pour cette ligne.',
PRIMARY KEY(`cmhc_id_historique_colonne`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Contient l''historique des valeurs des champs pour les enregistrements des tables de la base de données.\n' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_structure_conservation` (
	`csc_id_structure` INTEGER NOT NULL   COMMENT 'Identifiant de la structure.',
	`csc_mark_formation` BOOL   default 0 COMMENT 'Le personnel s''occupant des collections botaniques a-t-il suivi des formations en conservation ?',
	`csc_formation` VARCHAR(255)    COMMENT 'Les formations en conservation suvi par le personnel.',
	`csc_mark_formation_interet` BOOL    COMMENT 'Le personnel s''occupant des collections botaniques a-t-il suivi des formations en conservation ?',
	`csc_truk_stockage_local` VARCHAR(255)    COMMENT 'Avez-vous des locaux spécifiques de stockage des collections botaniques ?',
	`csc_truk_stockage_meuble` VARCHAR(255)    COMMENT 'Avez-vous des meubles spécifiques au stockage des collections botaniques ? ',
	`csc_truk_stockage_parametre` VARCHAR(255)    COMMENT 'Quels paramètres maîtrisez-vous ?',
	`csc_mark_collection_commune` BOOL NOT NULL  default 0 COMMENT 'Les collections botaniques sont-elles conservées avec d''autres collections dans les mêmes locaux (problème de conservation en commun) ? ',
	`csc_truk_collection_autre` VARCHAR(255)    COMMENT 'Actuellement, vos collections botaniques s''accroissent-elles de nouvelles acquisitions ?',
	`csc_mark_acces_controle` BOOL    COMMENT 'L''accès à vos collections botaniques est-il contrôlé (ex. : manipulation réservée à des personnes compétentes) ?',
	`csc_mark_restauration` BOOL    COMMENT 'Effectuez-vous actuellement des opérations de restauration ou de remise en état de vos collections botaniques ?',
	`csc_truk_restauration_operation` VARCHAR(255)    COMMENT 'Les différentes opérations de restauration actuellement menées.',
	`csc_ce_materiel_conservation` INTEGER    COMMENT 'Utilisez-vous du matériel de conservation ?',
	`csc_truk_materiel_autre` VARCHAR(255)    COMMENT 'Le matériel, dit de "non conservation" utilisé.',
	`csc_mark_traitement` BOOL    COMMENT 'Réalisez-vous actuellement des traitements globaux contre les insectes ?',
	`csc_truk_traitement` VARCHAR(255)    COMMENT 'Traitements globaux contre les insectes.',
	`csc_mark_acquisition_collection` BOOL    COMMENT 'Actuellement, vos collections botaniques s''accroissent-elles de nouvelles acquisitions ?',
	`csc_mark_acquisition_echantillon` BOOL    COMMENT 'Actuellement mettez-vous en herbier de nouveaux échantillons ? ',
	`csc_mark_acquisition_traitement` BOOL    COMMENT 'Si oui, faites-vous un traitement contre les insectes avant l''intégration dans vos collections ?',
	`csc_truk_acquisition_traitement_poison` VARCHAR(255)    COMMENT 'Traitement de type empoisonnement effectué lors des des acquisitions.',
	`csc_truk_acquisition_traitement_insecte` VARCHAR(255)    COMMENT 'Traitement de type désinctisation effectué lors des des acquisitions.',
	`csc_ce_meta` INTEGER    COMMENT 'Identifiant des métadonnées de cet enregistrement.',
PRIMARY KEY(`csc_id_structure`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Toutes les données spécifiques à la conservation au sein d''une structure.' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_structure_valorisation` (
	`csv_id_structure` INTEGER NOT NULL   COMMENT 'Identifiant de la structure.',
	`csv_mark_action` BOOL    COMMENT 'Avez-vous réalisé des actions de valorisation de vos collections botaniques ou avez-vous été sollicités pour la valorisation de ces collections ?',
	`csv_truk_action` VARCHAR(255)    COMMENT 'Les actions de valorisation réalisées.',
	`csv_publication` TEXT    COMMENT 'Quelques titres des ouvrages, articles scientifiques, ... ?',
	`csv_collection_autre` VARCHAR(255)    COMMENT 'L''organisme dispose-t-il d''autres collections (permettant une valorisation pluridisciplinaire) ?',
	`csv_mark_action_future` BOOL    COMMENT 'Envisagez-vous des actions de valorisation dans le cadre de votre politique culturelle ?',
	`csv_action_future` VARCHAR(255)    COMMENT 'Les actions de valorisation futures envisagées.',
	`csv_mark_recherche` BOOL    COMMENT 'Vos collections botaniques sont-elles utilisées pour des recherches scientifiques ?',
	`csv_truk_recherche_provenance` VARCHAR(255)    COMMENT 'Si oui, par des chercheurs (professionnels ou amateurs ) de  quelle provenance ?',
	`csv_truk_recherche_type` VARCHAR(255)    COMMENT 'Et pour quelles types de recherches ? ',
	`csv_mark_acces_ss_motif` BOOL    COMMENT 'Peut-on consulter vos collections botaniques sans motif de recherches scientifiques ?',
	`csv_acces_ss_motif` VARCHAR(255)    COMMENT 'Si oui, quelles démarches doit-on faire pour les consulter ?',
	`csv_mark_visite_avec_motif` BOOL    COMMENT 'Peut-on visiter vos collections botaniques en avec des objectifs de recherches scientifiques ?',
	`csv_visite_avec_motif` VARCHAR(255)    COMMENT 'Si oui, quelles démarches doit-on faire pour les visiter ?',
	`csv_ce_meta` INTEGER    COMMENT 'Identifiant des métadonnées de cet enregistrement.',
PRIMARY KEY(`csv_id_structure`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Toutes les données spécifiques à la valorisation au sein d''une structure.' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_collection_a_personne` (
	`ccap_id_collection` INTEGER NOT NULL   COMMENT 'Identifiant de la collection associée à une personne.',
	`ccap_id_personne` INTEGER NOT NULL   COMMENT 'Identifiant de la personne associée à une collection.',
	`ccap_id_role` VARCHAR(255) NOT NULL   COMMENT 'Rôle(s) de la personne : auteur, collecteur... permet aussi de connaître qui a les droits de modification sur la collection.',
	`ccap_ce_meta` INTEGER NOT NULL   COMMENT 'Identifiant des métadonnées de cet enregistrement.',
PRIMARY KEY(`ccap_id_collection`, `ccap_id_personne`, `ccap_id_role`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Permet de lister les personnes en rapport avec une collection.' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_collection_botanique` (
	`ccb_id_collection` INTEGER NOT NULL auto_increment  COMMENT 'Identifiant de la collection botanique.',
	`ccb_ce_truk_type` VARCHAR(255)    COMMENT 'Type(s) de collection botanique.',
	`ccb_truk_unite_rangement` VARCHAR(510)    COMMENT 'Type(s) unité de rangement de la collection botanique. \
Pour chaque type : indication du nombre d''unité, de la précision du nom (exact, approximatif), des formats.',
	`ccb_ce_unite_rangement_etat` INTEGER    COMMENT 'État de la majorité des unités de rangements (état des rubans, des poignées, des sangles, des cartons...).',
	`ccb_truk_unite_base` VARCHAR(510)    COMMENT 'Type(s) d''unité de base de la collection,  si différent de l''unité de rangement. \\  Ex. : si l''unité de rangement est un carton, l''unité de base peut être  une enveloppe. \\  Pour chaque type : indication du nombre d''unité, de la précision du nom (exact = 1, approximatif = 0), des formats (Lxl cm), du nombre de parts, de la précision sur le nombre de parts  (exact = 1, approximatif = 0), du nombre d''espèces, de la précision sur le nombre d''espèces (exact, approximatif).',
	`ccb_truk_conservation_papier_type` VARCHAR(255)    COMMENT 'Type(s) du papier de conservation.',
	`ccb_truk_conservation_methode` VARCHAR(255)    COMMENT 'Type(s) de méthode de conservation.',
	`ccb_specimen_fixation_pourcent` INTEGER    COMMENT 'Pourcentage de spécimens fixés.',
	`ccb_etiquette_fixation_pourcent` INTEGER    COMMENT 'Pourcentage d''étiquettes fixées.',
	`ccb_truk_specimen_fixation_methode` VARCHAR(255)    COMMENT 'Type(s) de fixation des spécimens.',
	`ccb_truk_etiquette_fixation_support` VARCHAR(255)    COMMENT 'Type(s) de fixation des étiquettes fixées au support.',
	`ccb_truk_etiquette_fixation_specimen` VARCHAR(255)    COMMENT 'Type(s) de fixation des étiquettes fixées au spécimen.',
	`ccb_truk_etiquette_ecriture` VARCHAR(255)    COMMENT 'Type(s) d''écriture sur les étiquettes.',
	`ccb_ce_traitement` INTEGER    COMMENT 'La collection botanique semble-t-elle avoir été empoisonnée ou désinsectisée lors de sa réalisation ?',
	`ccb_truk_traitement_poison` VARCHAR(255)    COMMENT 'Type(s) d''empoisonement de la collection.',
	`ccb_truk_traitement_insecte` VARCHAR(255)    COMMENT 'Type(s) de désinctisation de la collection.',
	`ccb_ce_etat_general` INTEGER    COMMENT 'État général de la collection (grosses attaques d''insectes, pourriture, papier très fragile, etc... de 1 très mauvais à 5 très bon état).',
	`ccb_truk_degradation_specimen` VARCHAR(255)    COMMENT 'Type(s) de causes des dégradations des spécimens notées de 1 très mauvais à 5 très bon état.',
	`ccb_truk_degradation_presentation` VARCHAR(255)    COMMENT 'Type(s) de causes des dégradations de la présentation notées de 1 très mauvais à 5 très bon état.',
	`ccb_ce_determination` INTEGER    COMMENT 'Les échantillons sont-ils déterminables ? (de 1 : quelques fragment de plantes à 5 plantes entières).',
	`ccb_truk_nature` VARCHAR(255)    COMMENT 'Nature de l''herbier.',
	`ccb_specialite` VARCHAR(255)    COMMENT 'Collection botanique spécialisée (ex. herbier de céréales...)',
	`ccb_recolte_date_debut` DATE    COMMENT 'Date extrême de début de récolte.',
	`ccb_ce_recolte_date_debut_type` INTEGER    COMMENT 'Type de date extrême de début de récolte.',
	`ccb_recolte_date_fin` DATE    COMMENT 'Date extrême de fin de récolte.',
	`ccb_ce_recolte_date_fin_type` INTEGER    COMMENT 'Type de date extrême de fin de récolte.',
	`ccb_annotation_classement` TEXT    COMMENT 'Indiquer le type de classement ou des informations concernant un éventuel classement.',
	`ccb_ce_classement_etat` INTEGER    COMMENT 'État du classement (de 1 très mauvais à 5 très bon).',
	`ccb_truk_etiquette_renseignement` VARCHAR(255)    COMMENT 'Pourcentage pour chaque type de renseignements portés sur l''étiquette ou sur la part.',
	`ccb_ce_precision_localite` INTEGER    COMMENT 'Les localités sont elles précises?',
	`ccb_ce_precision_date` INTEGER    COMMENT 'Les dates sont elles précises?',
	`ccb_annotation_diverse` TEXT    COMMENT 'Autres annotations (dons, annotations personnelles, recettes, utilisations médicales...).',
	`ccb_ce_collection_integre` INTEGER    COMMENT 'La collection observée intègre-t-elle des collections botaniques antérieures ?',
	`ccb_ce_collection_integre_info` INTEGER    COMMENT 'Les noms de ces collections sont-ils notés sur les étiquettes de chaque échantillon ?',
	`ccb_ce_inventaire` INTEGER    COMMENT 'Existe-t-il un inventaire de cette collection?',
	`ccb_ce_inventaire_auteur` INTEGER    COMMENT 'L''auteur de la collection a-t-il participé à cet inventaire?',
	`ccb_ce_inventaire_forme` INTEGER    COMMENT 'Forme de l''inventaire (mnauscrit, informatique...).',
	`ccb_inventaire_info` TEXT    COMMENT 'Quelles informations retrouve-t-on?',
	`ccb_ce_truk_inventaire_digital` VARCHAR(255)    COMMENT 'Si inventaire digial, quel logiciel utilisez vous?',
	`ccb_inventaire_digital_pourcent` INTEGER    COMMENT 'Pourcentage de la documentation en base de données.',
	`ccb_ce_inventaire_etat` INTEGER    COMMENT 'L''inventaire est il complet ou partiel?',
	`ccb_inventaire_donnee_type` TEXT    COMMENT 'Quels sont les éléments qui ont déjà été inventoriés (Ex. : familles, localités...) ?',
	`ccb_ce_meta` INTEGER    COMMENT 'Identifiant des métadonnées de cet enregistrement.',
PRIMARY KEY(`ccb_id_collection`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Toutes les informations spécialisées sur une collection de type : botanique' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_publication` (
	`cpu_id_publication` INTEGER NOT NULL auto_increment  COMMENT 'Identifiant de la publication.',
	`cpu_ce_projet` INTEGER NOT NULL   COMMENT 'Identifiant du projet dans lequel les données de cet enregistrement ont été saisies.',
	`cpu_fmt_nom_complet` VARCHAR(255)    COMMENT 'Intitulé de la publication complet : fmt_auteur, date_parution(année). titre. Editeur (nom), collection, fascicule, indication_nvt. pages.',
	`cpu_uri` VARCHAR(255)    COMMENT 'URI de la publication qui peut être un site web...',
	`cpu_fmt_auteur` VARCHAR(255)    COMMENT 'Contient le nom formaté de l''intitulé auteur(s). Si plusieurs personnes sont auteurs, l''intitulé est formaté ici.',
	`cpu_titre` VARCHAR(255)    COMMENT 'Titre de l''article ou de l''ouvrage.',
	`cpu_ce_truk_editeur` VARCHAR(255)    COMMENT 'Identifiant de la structure éditrice de la publication. S''il n''est pas renseignné dans la table Structure, contient AUTRE# suivit du nom complet de la structure éditrice.',
	`cpu_collection` VARCHAR(255)    COMMENT 'Intitulé de la collection, c''est à dire de la revue.',
	`cpu_date_parution` DATE    COMMENT 'Date de parution de la publication.',
	`cpu_indication_nvt` VARCHAR(255)    COMMENT 'Indication du numéro, volume ou tome de la publication. Plutôt utilisé pour les ouvrages et non les articles de revue.',
	`cpu_fascicule` VARCHAR(255)    COMMENT 'Indication du titre du fascicule. Surtout utilisé pour les revues.',
	`cpu_truk_pages` VARCHAR(25)    COMMENT 'Indication du nombre de pages (pour les ouvrages) ou des pages de début et de fin pour un artcile. Dans le cas des ouvrages un nombre doit être présent. Pour les articles deux nombres ou point d''intérogation séparés par un tiret.',
	`cpu_ce_meta` INTEGER NOT NULL   COMMENT 'Identifiant des métadonnées de cet enregistrement.',
PRIMARY KEY(`cpu_id_publication`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Publication de type articles scientifiques, ouvrages ou sites web.\n' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_collection_a_publication` (
	`ccapu_id_collection` INTEGER NOT NULL   COMMENT 'Identifiant de collection.',
	`ccapu_id_publication` INTEGER NOT NULL   COMMENT 'Identifiant de la publication.',
	`ccapu_mark_licence` BOOL    COMMENT 'Booléen indiquant si la publication indiqué correspond aux droits de propriétés intellectuelles de la collection.',
	`ccapu_ce_meta` INTEGER NOT NULL   COMMENT 'Identifiant des métadonnées de cet enregistrement.',
PRIMARY KEY(`ccapu_id_collection`, `ccapu_id_publication`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Permet de lister les publication liées à une collection.' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_publication_a_personne` (
	`cpuap_id_publication` INTEGER NOT NULL   COMMENT 'Identifiant d''une publication.',
	`cpuap_id_personne` INTEGER NOT NULL   COMMENT 'Identifiant d''une personne.',
	`cpuap_id_role` INTEGER NOT NULL   COMMENT 'Rôle de la personne vis à vis de la publication : contributeur, auteur...',
	`cpuap_ce_truk_type` VARCHAR(255)    COMMENT 'Contient le type de référence bibliographique : nécrologie, biographie, publication personnelle...',
	`cpuap_ce_meta` INTEGER NOT NULL   COMMENT 'Identifiant des métadonnées de cet enregistrement.',
PRIMARY KEY(`cpuap_id_publication`, `cpuap_id_personne`, `cpuap_id_role`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Permet de lister les publications d''une personne.' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_collection_a_relation` (
	`ccar_id_collection_01` INTEGER NOT NULL   COMMENT 'Identifiant de la collection n°1.',
	`ccar_id_collection_02` INTEGER NOT NULL   COMMENT 'Identifiant de la collection n°2.',
	`ccar_id_relation` INTEGER NOT NULL   COMMENT 'Indentifiant du type de la relation.',
	`ccar_ce_meta` INTEGER NOT NULL   COMMENT 'Identifiant des métadonnées de cet enregistrement.',
PRIMARY KEY(`ccar_id_collection_01`, `ccar_id_collection_02`, `ccar_id_relation`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Permet de lister les relations entre collection autre que hiérarchique.' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_projet` (
	`cpr_id_projet` INTEGER NOT NULL auto_increment  COMMENT 'Identifiant d''un projet.',
	`cpr_nom` VARCHAR(255) NOT NULL   COMMENT 'Nom du projet.',
	`cpr_abreviation` VARCHAR(40)    COMMENT 'Abréviation du projet.',
	`cpr_resume` VARCHAR(255)    COMMENT 'Résumé du projet.',
	`cpr_description` TEXT    COMMENT 'Description détaillée du projet.',
	`cpr_url` VARCHAR(255)    COMMENT 'URL principal où trouver des compléments d''information sur le projet.',
	`cpr_mot_cles` VARCHAR(255)    COMMENT 'Mots clés correspondant au projet.',
	`cpr_citation` VARCHAR(255)    COMMENT 'Indication sur la fa\195\167on de citer le projet pour réaliser une bibliographie.',
	`cpr_licence` VARCHAR(255)    COMMENT 'Url ou texte présentant la licence des données du projet.',
	`cpr_ce_langue` INTEGER    COMMENT 'Langue principale des données du projet (selon l''ISO-639-1).',
	`cpr_indexation_heure` TIME    COMMENT 'Préférence de l''heure de départ pour les procédures d''indexation externe.',
	`cpr_ce_indexation_duree` INTEGER    COMMENT 'Durée maximum acceptable pour une procédure d''indexation externe.',
	`cpr_ce_indexation_freq` INTEGER    COMMENT 'Fréquence maximum acceptable pour une procédure d''indexation externe.',
	`cpr_mark_public` BOOL   default 0 COMMENT 'Indique si oui (=1) ou non (=0) ce projet est public. Si oui, il peut être publié dans eFlore.',
	`cpr_ce_meta` INTEGER NOT NULL   COMMENT 'Identifiant des métadonnées de cet enregistrement.',
PRIMARY KEY(`cpr_id_projet`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Contient les informations sur un projet de données.\n' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_personne_a_relation` (
	`cpar_id_personne_01` INTEGER NOT NULL   COMMENT 'Identifiant de la personne n°1.',
	`cpar_id_personne_02` INTEGER NOT NULL   COMMENT 'Identifiant de la personne n°2.',
	`cpar_id_projet` INTEGER NOT NULL   COMMENT 'Identifiant du projet dans lequel la relation entre les deux personnes s''établie.',
	`cpar_id_role` INTEGER NOT NULL   COMMENT 'Identifiant du rôle ou de la valeur établie entre les deux personnes.',
	`cpar_ce_meta` INTEGER NOT NULL   COMMENT 'Identifiant des métadonnées de cet enregistrement.',
PRIMARY KEY(`cpar_id_personne_01`, `cpar_id_personne_02`, `cpar_id_projet`, `cpar_id_role`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Relation entre deux personnes vis à vis d''un projet.' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_projet_version` (
	`cprv_id_version` INTEGER NOT NULL auto_increment  COMMENT 'Identifiant d''une version de projet.',
	`cprv_ce_projet` INTEGER NOT NULL   COMMENT 'Identifiant du projet de la version.',
	`cprv_nom` VARCHAR(255)    COMMENT 'Nom éventuel de la version.',
	`cprv_code` VARCHAR(25) NOT NULL   COMMENT 'Numéro ou code de la version.',
	`cprv_date_debut` DATETIME NOT NULL  default "0000-00-00 00:00:00" COMMENT 'Date de début de la version.',
	`cprv_date_fin` DATETIME    COMMENT 'Date de fin de la version.',
	`cprv_ce_meta` INTEGER NOT NULL   COMMENT 'Identifiant des métadonnées de cet enregistrement.',
PRIMARY KEY(`cprv_id_version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Table contenant les informations sur la version d''un projet.\n' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_meta_historique_ligne` (
	`cmhl_id_historique_ligne` INTEGER NOT NULL auto_increment  COMMENT 'Identifiant de l''historique des lignes.',
	`cmhl_ce_table` INTEGER    COMMENT 'Identifiant de la table.',
	`cmhl_cle_ligne` VARCHAR(64) NOT NULL   COMMENT 'Identifiant de la ligne. Pour les tables à clé primaire multi colonnes, bien respecter l''ordre des champs de la clé et inscrire chaque valeur de clé séparée par un tiret "-".',
	`cmhl_enregistrement` TEXT    COMMENT 'Contient les données au format XML pour les enregistrements supprimés uniquement, sinon possède la valeur NULL. Format XML : <xml encoding="UTF-8><ligne><nom_du_champ_01>valeur_du_champ_01</nom_du_champ_01><nom_du_champ_02>valeur_du_champ_02</nom_du_champ_02>...</ligne></xml>.',
	`cmhl_date_modification` DATETIME NOT NULL   COMMENT 'Date de modification de la ligne.',
	`cmhl_notes` VARCHAR(255)    COMMENT 'Notes sur la modification effectuée sur la ligne.',
	`cmhl_ce_modifier_par` INTEGER NOT NULL   COMMENT 'Identifiant de la personne ayant effectué cette modification sur la ligne.',
	`cmhl_ce_etat` INTEGER NOT NULL   COMMENT 'Identifiant de l''état de la ligne.',
	`cmhl_ip` VARCHAR(50) NOT NULL   COMMENT 'Adresse IP (et MAC éventuellement) depuis laquelle la modification a eu lieu.',
	`cmhl_session_id` VARCHAR(40)    COMMENT 'Identifiant de session del ''utilisateur.',
PRIMARY KEY(`cmhl_id_historique_ligne`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Contient les métadonnées sur l''historique des enregistrements des tables de la base de données.\n' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_commentaire` (
	`ccm_id_commentaire` INTEGER NOT NULL auto_increment  COMMENT 'Identifiant d''un commentaire.',
	`ccm_ce_pere` INTEGER NOT NULL  default 0 COMMENT 'Identifiant du commentaire père.',
	`ccm_ce_projet` INTEGER    COMMENT 'Identifiant du projet dans lequel le commentaire est fait.',
	`ccm_titre` VARCHAR(255)    COMMENT 'Titre du commentaire.',
	`ccm_texte` TEXT    COMMENT 'Texte du commentaire.',
	`ccm_ponderation` INTEGER    COMMENT 'Pondération du commentaire (importance). Valeur de 1 à 10.',
	`ccm_ce_meta` INTEGER    COMMENT 'Identifiant des métadonnées de cet enregistrement.',
	`ccm_mark_public` BOOL   default 0 COMMENT 'Indique si oui (=1) ou non (=0) ce commentaire est public .',
PRIMARY KEY(`ccm_id_commentaire`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Contient les commentaires.\n' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_collection_a_commentaire` (
	`ccac_id_collection` INTEGER NOT NULL   COMMENT 'Identifiant de la collection.',
	`ccac_id_commentaire` INTEGER NOT NULL   COMMENT 'Identifiant du commentaire.',
	`ccac_truk_type` VARCHAR(255)    COMMENT 'Liste des types de commentaires séparés par des points virgules.',
	`ccac_ce_meta` INTEGER    COMMENT 'Identifiant des métadonnées de cet enregistrement.',
PRIMARY KEY(`ccac_id_collection`, `ccac_id_commentaire`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Permet de lister les commentaires / notes faits sur une collection.' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
CREATE TABLE IF NOT EXISTS `tb_coel`.`coel_projet_a_structure` (
	`cpras_id_projet` INTEGER NOT NULL   COMMENT '',
	`cpras_id_structure` INTEGER NOT NULL   COMMENT '',
	`cpras_truk_role` VARCHAR(255)    COMMENT '',
	`cpras_ce_meta` INTEGER    COMMENT '',
PRIMARY KEY(`cpras_id_projet`, `cpras_id_structure`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='' AUTO_INCREMENT=1;

#---------------------------------------------------------------------------------------------------------------------#
# Insertion des méta-données
# Ajout du projet de métadonnées
INSERT INTO `tb_coel`.`coel_projet` (`cpr_id_projet` ,`cpr_nom` ,`cpr_abreviation` ,`cpr_resume` ,`cpr_description` ,`cpr_url` ,`cpr_ce_meta`) VALUES 
	('1', 'Métadonnées', 'meta', 'Contient le schéma de la base de données et les listes de valeurs.', 'Ce projet est interne au système. Il permet de créer le schéma de la base de données qui sera stocké dans le module Métadonnées.', NULL , '1');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1', '115', '1', NULL , NOW( ) , 'Ajout du projet des métadonnées', '1', '1', '162.38.234.1');
# Ajout super-administrateur
INSERT INTO `tb_coel`.`coel_personne` (`cp_id_personne` ,`cp_ce_projet` ,`cp_fmt_nom_complet` ,`cp_abreviation` ,`cp_truk_courriel` ,`cp_login` ,`cp_mot_de_passe` ,`cp_ce_meta`) VALUES 
	('1', '1', 'Super Administrateur', 'SA', 'webmestre@tela-botanica.org', 'webmestre', SHA1( '000000' ) , '2');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('2', '113', '1', NULL , NOW( ) , 'Ajout du super administrateur', '1', '1', '162.38.234.1');

# Liste des tables du modèle de la base de données
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('101', '1003', '1', 'coel_collection', 'cc', 'Contient les informations sur les collections.\n', '3');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('3', '112', '101', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('102', '1003', '1', 'coel_collection_a_commentaire', 'ccac', 'Permet de lister les commentaires / notes faits sur une collection.', '4');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('4', '112', '102', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('103', '1003', '1', 'coel_collection_a_personne', 'ccap', 'Permet de lister les personnes en rapport avec une collection.', '5');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('5', '112', '103', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('104', '1003', '1', 'coel_collection_a_publication', 'ccapu', 'Permet de lister les publication liées à une collection.', '6');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('6', '112', '104', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('105', '1003', '1', 'coel_collection_a_relation', 'ccar', 'Permet de lister les relations entre collection autre que hiérarchique.', '7');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('7', '112', '105', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('106', '1003', '1', 'coel_collection_botanique', 'ccb', 'Toutes les informations spécialisées sur une collection de type : botanique', '8');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('8', '112', '106', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('107', '1003', '1', 'coel_commentaire', 'ccm', 'Contient les commentaires.\n', '9');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('9', '112', '107', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('108', '1003', '1', 'coel_meta_colonne', 'cmc', 'Contient l''ensemble des champs des tables de la base de données.\n', '10');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('10', '112', '108', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('109', '1003', '1', 'coel_meta_donnee', 'cmd', 'Contient les champs supplémentaires (non standard ou de spécialisation) de la base de données.', '11');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('11', '112', '109', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('110', '1003', '1', 'coel_meta_historique_colonne', 'cmhc', 'Contient l''historique des valeurs des champs pour les enregistrements des tables de la base de données.\n', '12');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('12', '112', '110', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('111', '1003', '1', 'coel_meta_historique_ligne', 'cmhl', 'Contient les métadonnées sur l''historique des enregistrements des tables de la base de données.\n', '13');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('13', '112', '111', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('112', '1003', '1', 'coel_meta_liste_valeur', 'cmlv', 'Liste l''ensemble des valeurs des tables de type liste.\nUn champ contient des valeurs dans cette table quand il est de type "LISTE".\n', '14');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('14', '112', '112', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('113', '1003', '1', 'coel_personne', 'cp', 'Contient les informations sur les personnes.\nPar personne nous entendons à la fois les utilisateurs de l''application mais aussi les personnes contacts, les botanistes collecteurs, auteurs...\n', '15');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('15', '112', '113', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('114', '1003', '1', 'coel_personne_a_relation', 'cpar', 'Relation entre deux personnes vis à vis d''un projet.', '16');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('16', '112', '114', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('115', '1003', '1', 'coel_projet', 'cpr', 'Contient les informations sur un projet de données.\n', '17');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('17', '112', '115', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('116', '1003', '1', 'coel_projet_a_structure', 'cpras', '', '18');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('18', '112', '116', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('117', '1003', '1', 'coel_projet_version', 'cprv', 'Table contenant les informations sur la version d''un projet.\n', '19');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('19', '112', '117', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('118', '1003', '1', 'coel_publication', 'cpu', 'Publication de type articles scientifiques, ouvrages ou sites web.\n', '20');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('20', '112', '118', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('119', '1003', '1', 'coel_publication_a_personne', 'cpuap', 'Permet de lister les publications d''une personne.', '21');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('21', '112', '119', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('120', '1003', '1', 'coel_structure', 'cs', 'Contient les informations sur les structures.\n', '22');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('22', '112', '120', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('121', '1003', '1', 'coel_structure_a_personne', 'csap', 'Table de liaison permettant d''indiquer la composition de la structure en personnel.\nElle permet d''indiquer pour une personne vis à vis d''une structure :\n - si elle est contact\n - les informations de la personne spécifique à cette structure (ex. : téléphone du travail, fonction, service, statut...).', '23');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('23', '112', '121', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('122', '1003', '1', 'coel_structure_conservation', 'csc', 'Toutes les données spécifiques à la conservation au sein d''une structure.', '24');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('24', '112', '122', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('123', '1003', '1', 'coel_structure_valorisation', 'csv', 'Toutes les données spécifiques à la valorisation au sein d''une structure.', '25');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('25', '112', '123', NULL , NOW( ) , 'Initialisation d''une valeur table pour la liste des tables.', '1', '1', '162.38.234.1');

# Valeurs et listes
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1', '1001', '1', 'Ajouté', 'A', 'NULL', '26');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('26', '112', '1', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «A» pour la liste «00a».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2', '1001', '1', 'Modifié', 'M', 'NULL', '27');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('27', '112', '2', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «M» pour la liste «00a».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3', '1001', '1', 'Supprimé', 'S', 'NULL', '28');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('28', '112', '3', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «S» pour la liste «00a».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('11', '1002', '1', 'TINYINT', '1', 'NULL', '29');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('29', '112', '11', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «1» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('12', '1002', '1', 'SMALLINT', '2', 'NULL', '30');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('30', '112', '12', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «2» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('13', '1002', '1', 'MEDIUMINT', '3', 'NULL', '31');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('31', '112', '13', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «3» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('14', '1002', '1', 'INT', '4', 'NULL', '32');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('32', '112', '14', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «4» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('15', '1002', '1', 'INTEGER', '5', 'NULL', '33');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('33', '112', '15', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «5» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('16', '1002', '1', 'BIGINT', '6', 'NULL', '34');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('34', '112', '16', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «6» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('17', '1002', '1', 'FLOAT', '7', 'NULL', '35');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('35', '112', '17', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «7» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('18', '1002', '1', 'DOUBLE', '8', 'NULL', '36');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('36', '112', '18', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «8» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('19', '1002', '1', 'DOUBLE PRECISION', '9', 'NULL', '37');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('37', '112', '19', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «9» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('20', '1002', '1', 'REAL', '10', 'NULL', '38');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('38', '112', '20', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «10» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('21', '1002', '1', 'DECIMAL', '11', 'NULL', '39');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('39', '112', '21', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «11» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('22', '1002', '1', 'NUMERIC', '12', 'NULL', '40');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('40', '112', '22', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «12» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('23', '1002', '1', 'DATE', '13', 'NULL', '41');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('41', '112', '23', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «13» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('24', '1002', '1', 'DATETIME', '14', 'NULL', '42');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('42', '112', '24', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «14» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('25', '1002', '1', 'TIMESTAMP', '15', 'NULL', '43');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('43', '112', '25', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «15» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('26', '1002', '1', 'TIME', '16', 'NULL', '44');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('44', '112', '26', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «16» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('27', '1002', '1', 'YEAR', '17', 'NULL', '45');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('45', '112', '27', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «17» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('28', '1002', '1', 'CHAR', '18', 'NULL', '46');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('46', '112', '28', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «18» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('29', '1002', '1', 'VARCHAR', '19', 'NULL', '47');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('47', '112', '29', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «19» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('30', '1002', '1', 'BIT', '20', 'NULL', '48');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('48', '112', '30', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «20» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('31', '1002', '1', 'BOOL', '21', 'NULL', '49');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('49', '112', '31', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «21» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('32', '1002', '1', 'TINYBLOB', '22', 'NULL', '50');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('50', '112', '32', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «22» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('33', '1002', '1', 'BLOB', '23', 'NULL', '51');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('51', '112', '33', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «23» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('34', '1002', '1', 'MEDIUMBLOB', '24', 'NULL', '52');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('52', '112', '34', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «24» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('35', '1002', '1', 'LONGBLOB', '25', 'NULL', '53');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('53', '112', '35', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «25» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('36', '1002', '1', 'TINYTEXT', '26', 'NULL', '54');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('54', '112', '36', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «26» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('37', '1002', '1', 'TEXT', '27', 'NULL', '55');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('55', '112', '37', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «27» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('38', '1002', '1', 'MEDIUMTEXT', '28', 'NULL', '56');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('56', '112', '38', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «28» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('39', '1002', '1', 'LONGTEXT', '29', 'NULL', '57');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('57', '112', '39', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «29» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('40', '1002', '1', 'ENUM', '30', 'NULL', '58');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('58', '112', '40', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «30» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('41', '1002', '1', 'SET', '31', 'NULL', '59');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('59', '112', '41', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «31» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('42', '1002', '1', 'GEOMETRY', '32', 'NULL', '60');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('60', '112', '42', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «32» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('43', '1002', '1', 'LINESTRING', '33', 'NULL', '61');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('61', '112', '43', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «33» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('44', '1002', '1', 'POLYGON', '34', 'NULL', '62');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('62', '112', '44', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «34» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('45', '1002', '1', 'MULTIPOINT', '35', 'NULL', '63');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('63', '112', '45', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «35» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('46', '1002', '1', 'MULTILINESTRING', '36', 'NULL', '64');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('64', '112', '46', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «36» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('47', '1002', '1', 'MULTIPOLYGON', '37', 'NULL', '65');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('65', '112', '47', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «37» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('48', '1002', '1', 'GEOMETRYCOLLECTION', '38', 'NULL', '66');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('66', '112', '48', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «38» pour la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1001', '0', '1', 'Liste des états des enregistrements de la base de données', '00a', 'NULL', '67');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('67', '112', '1001', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «00a».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1002', '0', '1', 'Liste des formats de champs SQL de la base de données', '00b', 'NULL', '68');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('68', '112', '1002', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «00b».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1003', '0', '1', 'Liste des tables de la base de données', '00c', 'NULL', '69');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('69', '112', '1003', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «00c».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1004', '0', '1', 'Liste des préfixes de noms de personne', '1', 'NULL', '70');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('70', '112', '1004', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «01».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1005', '0', '1', 'Liste des suffixes de noms de personne', '2', 'NULL', '71');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('71', '112', '1005', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «02».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1006', '0', '1', 'Liste des types de noms complémentaires d''une personne', '3', 'NULL', '72');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('72', '112', '1006', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «03».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1007', '0', '1', 'Liste des types de téléphone', '4', 'NULL', '73');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('73', '112', '1007', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «04».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1008', '0', '1', 'Liste des types de spécialités botaniques', '5', 'NULL', '74');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('74', '112', '1008', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «05».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1009', '0', '1', 'Liste des rôles d''une personne', '6', 'NULL', '75');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('75', '112', '1009', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «06».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1010', '0', '1', 'Liste des relations entre personnes', '7', 'NULL', '76');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('76', '112', '1010', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «07».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1011', '0', '1', 'Liste des relations entre une structure et une personne', '8', 'NULL', '77');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('77', '112', '1011', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «08».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1012', '0', '1', 'Liste des fonctions d''une personne au sein d''une structure', '9', 'NULL', '78');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('78', '112', '1012', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «09».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1013', '0', '1', 'Liste des statuts d''une personne au sein d''une structure', '10', 'NULL', '79');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('79', '112', '1013', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «10».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1014', '0', '1', 'Liste des types de structure dans le standard NCD', '11', 'NULL', '80');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('80', '112', '1014', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1015', '0', '1', 'Liste des types de structure privé', '12', 'NULL', '81');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('81', '112', '1015', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «12».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1016', '0', '1', 'Liste des types de structure publique', '13', 'NULL', '82');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('82', '112', '1016', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «13».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1017', '0', '1', 'Liste des identifiants alternatifs de structures à vocation botanique', '14', 'NULL', '83');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('83', '112', '1017', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «14».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1018', '0', '1', 'Liste des types de local de stockage de collections', '15', 'NULL', '84');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('84', '112', '1018', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «15».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1019', '0', '1', 'Liste des types de mobilier de stockage de collections', '16', 'NULL', '85');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('85', '112', '1019', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «16».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1020', '0', '1', 'Liste des paramètres de contrôle environnemental d''un local', '17', 'NULL', '86');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('86', '112', '1020', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «17».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1021', '0', '1', 'Liste des types de collection non botanique', '18', 'NULL', '87');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('87', '112', '1021', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «18».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1022', '0', '1', 'Liste des types d''opération de restauration pour les collections botaniques', '19', 'NULL', '88');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('88', '112', '1022', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «19».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1023', '0', '1', 'Liste oui/non/en partie', '20', 'NULL', '89');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('89', '112', '1023', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «20».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1024', '0', '1', 'Liste du matériel dit de nom conservation des parts d''herbier', '21', 'NULL', '90');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('90', '112', '1024', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «21».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1025', '0', '1', 'Liste de traitement anti-insecte pour les collections botaniques', '22', 'NULL', '91');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('91', '112', '1025', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «22».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1026', '0', '1', 'Liste des poisons utilisés pour les collections botaniques', '23', 'NULL', '92');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('92', '112', '1026', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «23».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1027', '0', '1', 'Liste des actions de valorisation des collections', '24', 'NULL', '93');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('93', '112', '1027', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «24».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1028', '0', '1', 'Liste des continents habités incluant aussi le pays France', '25', 'NULL', '94');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('94', '112', '1028', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «25».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1029', '0', '1', 'Liste des types de recherche nécessitant la consultation de collection botanique', '26', 'NULL', '95');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('95', '112', '1029', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «26».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1030', '0', '1', 'Liste des relations entre une collection et une personne', '27', 'NULL', '96');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('96', '112', '1030', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «27».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1031', '0', '1', 'Liste des relations entre collections', '28', 'NULL', '97');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('97', '112', '1031', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «28».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1032', '0', '1', 'Liste des types de collection dans le standard NCD', '29', 'NULL', '98');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('98', '112', '1032', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1033', '0', '1', 'Liste des types de dépôt de collection', '30', 'NULL', '99');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('99', '112', '1033', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «30».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1034', '0', '1', 'Liste des principes de groupement d''une collection dans le standard NCD', '31', 'NULL', '100');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('100', '112', '1034', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «31».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1035', '0', '1', 'Liste des buts de réalisation d''une collection dans le standard NCD', '32', 'NULL', '101');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('101', '112', '1035', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «32».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1036', '0', '1', 'Échelle Mc Ginley dans le standard NCD', '33', 'NULL', '102');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('102', '112', '1036', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «33».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1037', '0', '1', 'Liste des règnes du vivant dans le standard NCD', '34', 'NULL', '103');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('103', '112', '1037', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «34».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1038', '0', '1', 'Liste des méthodes de conservation dans le standard NCD', '35', 'NULL', '104');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('104', '112', '1038', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1039', '0', '1', 'Liste des états de croissance d''une collection dans le standard NCD', '36', 'NULL', '105');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('105', '112', '1039', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «36».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1040', '0', '1', 'Liste des siècles pour les collections naturalistes', '37', 'NULL', '106');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('106', '112', '1040', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «37».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1041', '0', '1', 'Liste indéterminé/peut-être/oui/non', '38', 'NULL', '107');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('107', '112', '1041', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «38».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1042', '0', '1', 'Liste des types de classement des spécimens types dans une collection', '39', 'NULL', '108');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('108', '112', '1042', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «39».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1043', '0', '1', 'Liste des natures végétales', '40', 'NULL', '109');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('109', '112', '1043', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «40».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1044', '0', '1', 'Liste des types d''unité de rangement pour les collections botaniques', '41', 'NULL', '110');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('110', '112', '1044', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «41».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1045', '0', '1', 'Liste des états', '42', 'NULL', '111');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('111', '112', '1045', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «42».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1046', '0', '1', 'Liste des types de support pour les spécimens des collections botaniques', '43', 'NULL', '112');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('112', '112', '1046', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «43».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1047', '0', '1', 'Liste des types de papier de support pour les spécimens des collections botaniques', '44', 'NULL', '113');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('113', '112', '1047', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «44».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1048', '0', '1', 'Liste des méthodes de rangement des supports pour les spécimens des collections botaniques', '45', 'NULL', '114');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('114', '112', '1048', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «45».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1049', '0', '1', 'Liste des méthodes de fixation sur le support pour les collections botaniques', '46', 'NULL', '115');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('115', '112', '1049', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «46».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1050', '0', '1', 'Liste des méthodes de fixation des étiquettes sur les spécimens pour les collections botaniques', '47', 'NULL', '116');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('116', '112', '1050', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «47».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1051', '0', '1', 'Liste des types d''écriture d''étiquette', '48', 'NULL', '117');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('117', '112', '1051', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «48».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1052', '0', '1', 'Liste des origines des dégradations des spécimens de collections botaniques', '49', 'NULL', '118');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('118', '112', '1052', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «49».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1053', '0', '1', 'Liste des origines des dégradations des supports de collections botaniques', '50', 'NULL', '119');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('119', '112', '1053', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «50».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1054', '0', '1', 'Liste des niveaux de détermination des spécimens de collections botaniques', '51', 'NULL', '120');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('120', '112', '1054', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «51».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1055', '0', '1', 'Liste des types de date de début', '52', 'NULL', '121');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('121', '112', '1055', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «52».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1056', '0', '1', 'Liste des types de date de fin', '53', 'NULL', '122');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('122', '112', '1056', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «53».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1057', '0', '1', 'Liste des états de classement', '54', 'NULL', '123');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('123', '112', '1057', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «54».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1058', '0', '1', 'Liste des informations présentes sur les étiquettes de collections botaniques', '55', 'NULL', '124');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('124', '112', '1058', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «55».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1059', '0', '1', 'Liste oui/non/en grande partie', '56', 'NULL', '125');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('125', '112', '1059', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «56».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1060', '0', '1', 'Liste indéterminé/parfois/oui/non', '57', 'NULL', '126');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('126', '112', '1060', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «57».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1061', '0', '1', 'Liste des formes d''inventaire', '58', 'NULL', '127');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('127', '112', '1061', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «58».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1062', '0', '1', 'Liste des types de logiciel pour les inventaires informatiques', '59', 'NULL', '128');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('128', '112', '1062', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «59».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1063', '0', '1', 'Liste des états d''inventaire', '60', 'NULL', '129');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('129', '112', '1063', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «60».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1064', '0', '1', 'Liste des relations entre une publication et une personne', '61', 'NULL', '130');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('130', '112', '1064', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «61».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1065', '0', '1', 'Liste des types de publication vis à vis d''une personne', '62', 'NULL', '131');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('131', '112', '1065', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «62».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1066', '0', '1', 'Liste des types d''url', '63', 'NULL', '132');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('132', '112', '1066', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «63».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1067', '0', '1', 'Liste du genre d''une personne', '64', 'NULL', '133');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('133', '112', '1067', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «64».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1068', '0', '1', 'Liste des types de commentaires associés à une collection', '65', 'NULL', '134');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('134', '112', '1068', NULL , '2009-03-19 13:07:46' , 'Initialisation de la liste «65».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1071', '0', '1', 'Liste des langues du standard ISO-639-1', '68', 'NULL', '135');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('135', '112', '1071', NULL , '2009-03-24 18:00:42' , 'Initialisation de la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1072', '0', '1', 'Liste de durées de fonctionnement d''un script en heure ', '69', 'NULL', '136');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('136', '112', '1072', NULL , '2009-04-08 11:59:42' , 'Initialisation de la liste «69».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1073', '0', '1', 'Liste de fréquences de lancement d''un script', '70', 'NULL', '137');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('137', '112', '1073', NULL , '2009-04-08 11:59:42' , 'Initialisation de la liste «70».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1074', '0', '1', 'Liste des pays du standard ISO-3166-1', '71', 'NULL', '138');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('138', '112', '1074', NULL , '2009-04-08 11:59:43' , 'Initialisation de la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1078', '0', '1', 'Liste des noms de zones géographiques administrative de niveau 1 du projet Geonames', '75', 'NULL', '139');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('139', '112', '1078', NULL , '2009-07-29 01:17:00' , 'Initialisation de la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('1079', '0', '1', 'Liste des noms de zones géographiques administrative de niveau 2 du projet Geonames', '76', 'NULL', '140');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('140', '112', '1079', NULL , '2009-07-29 01:15:00' , 'Initialisation de la liste «76».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2001', '1004', '1', 'Mr.', '1', 'NULL', '141');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('141', '112', '2001', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «1» pour la liste «01».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2002', '1004', '1', 'Dr.', '2', 'NULL', '142');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('142', '112', '2002', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «2» pour la liste «01».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2003', '1004', '1', 'Abbé', '3', 'NULL', '143');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('143', '112', '2003', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «3» pour la liste «01».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2004', '1004', '1', 'Colonel', '4', 'NULL', '144');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('144', '112', '2004', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «4» pour la liste «01».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2005', '1004', '1', 'Prof.', '5', 'NULL', '145');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('145', '112', '2005', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «5» pour la liste «01».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2006', '1004', '1', 'von', '6', 'NULL', '146');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('146', '112', '2006', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «6» pour la liste «01».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2007', '1004', '1', 'Lord', '7', 'NULL', '147');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('147', '112', '2007', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «7» pour la liste «01».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2008', '1005', '1', 'Jr', '1', 'NULL', '148');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('148', '112', '2008', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «1» pour la liste «02».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2009', '1005', '1', 'I', '2', 'NULL', '149');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('149', '112', '2009', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «2» pour la liste «02».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2010', '1005', '1', 'II', '3', 'NULL', '150');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('150', '112', '2010', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «3» pour la liste «02».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2011', '1005', '1', 'III', '4', 'NULL', '151');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('151', '112', '2011', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «4» pour la liste «02».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2012', '1006', '1', 'Surnom', 'SNO', 'NULL', '152');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('152', '112', '2012', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «SNO» pour la liste «03».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2013', '1006', '1', 'Nom alternatif', 'ALT', 'NULL', '153');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('153', '112', '2013', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «ALT» pour la liste «03».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2014', '1007', '1', 'Portable', 'GSM', 'NULL', '154');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('154', '112', '2014', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «GSM» pour la liste «04».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2015', '1007', '1', 'Téléphone fixe', 'FIX', 'NULL', '155');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('155', '112', '2015', NULL , '2009-03-19 13:07:46' , 'Initialisation de la valeur «FIX» pour la liste «04».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2016', '1007', '1', 'Pager', 'PAG', 'NULL', '156');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('156', '112', '2016', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «PAG» pour la liste «04».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2017', '1009', '1', 'Super-Administrateur', '1', 'NULL', '157');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('157', '112', '2017', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «06».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2018', '1009', '1', 'Administrateur', '2', 'NULL', '158');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('158', '112', '2018', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «06».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2019', '1009', '1', 'Coordinateur', '3', 'NULL', '159');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('159', '112', '2019', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «06».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2020', '1009', '1', 'Contributeur', '4', 'NULL', '160');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('160', '112', '2020', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «06».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2021', '1009', '1', 'Utilisateur', '5', 'NULL', '161');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('161', '112', '2021', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «06».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2022', '1010', '1', 'Administrateur', '1', 'NULL', '162');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('162', '112', '2022', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «07».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2023', '1010', '1', 'Coordinateur', '2', 'NULL', '163');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('163', '112', '2023', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «07».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2024', '1010', '1', 'Contributeur', '3', 'NULL', '164');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('164', '112', '2024', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «07».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2025', '1010', '1', 'est coordinateur de', '4', 'NULL', '165');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('165', '112', '2025', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «07».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2026', '1011', '1', 'est administrer par', 'EAP', 'Indique quelle personne peut administrer les données dans l''application courante.', '166');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('166', '112', '2026', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «08».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2027', '1011', '1', 'équipe', 'EQU', 'Rôle général d''une personne au sein d''une structure.', '167');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('167', '112', '2027', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «08».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2830', '1011', '1', 'Administrateur système', 'AS', 'Administrateur système (= System Administrator).', '168');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('168', '112', '2830', NULL , '2009-05-07 15:26:00' , 'Initialisation de la valeur «3» pour la liste «08».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2831', '1011', '1', 'Administrateur données', 'AD', 'Administrateur des données (= Data Administrator).', '169');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('169', '112', '2831', NULL , '2009-05-07 15:27:00' , 'Initialisation de la valeur «4» pour la liste «08».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2028', '1012', '1', 'Directeur', '1', 'NULL', '170');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('170', '112', '2028', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «09».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2029', '1012', '1', 'Conservateur', '2', 'NULL', '171');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('171', '112', '2029', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «09».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2030', '1012', '1', 'Technicien', '3', 'NULL', '172');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('172', '112', '2030', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «09».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2031', '1013', '1', 'Salarié', '1', 'NULL', '173');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('173', '112', '2031', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «10».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2032', '1013', '1', 'Bénévole', '2', 'NULL', '174');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('174', '112', '2032', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «10».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2033', '1014', '1', 'Aquarium', '1', 'NULL', '175');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('175', '112', '2033', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2034', '1014', '1', 'Archive', '2', 'NULL', '176');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('176', '112', '2034', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2035', '1014', '1', 'Jardin botanique', '3', 'NULL', '177');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('177', '112', '2035', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2036', '1014', '1', 'Protection de la nature', '4', 'NULL', '178');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('178', '112', '2036', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2037', '1014', '1', 'Station d''étude', '5', 'NULL', '179');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('179', '112', '2037', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2038', '1014', '1', 'Établissement d''État', '6', 'NULL', '180');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('180', '112', '2038', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «6» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2039', '1014', '1', 'Société d''histoire', '7', 'NULL', '181');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('181', '112', '2039', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «7» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2040', '1014', '1', 'Établissement horticole', '8', 'NULL', '182');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('182', '112', '2040', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «8» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2041', '1014', '1', 'Industrie', '9', 'NULL', '183');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('183', '112', '2041', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «9» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2042', '1014', '1', 'Laboratoire', '10', 'NULL', '184');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('184', '112', '2042', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «10» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2043', '1014', '1', 'Bibliothèque', '11', 'NULL', '185');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('185', '112', '2043', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «11» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2044', '1014', '1', 'Gestion de la nature', '12', 'NULL', '186');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('186', '112', '2044', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «12» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2045', '1014', '1', 'Museum', '13', 'NULL', '187');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('187', '112', '2045', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «13» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2046', '1014', '1', 'Centre d''éducation à la nature', '14', 'NULL', '188');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('188', '112', '2046', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «14» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2047', '1014', '1', 'Établissement scolaire (Lycée)', '15', 'NULL', '189');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('189', '112', '2047', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «15» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2048', '1014', '1', 'Parc', '16', 'NULL', '190');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('190', '112', '2048', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «16» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2049', '1014', '1', 'Dépôt', '17', 'NULL', '191');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('191', '112', '2049', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «17» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2050', '1014', '1', 'Institut de Recherche', '18', 'NULL', '192');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('192', '112', '2050', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «18» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2051', '1014', '1', 'Établissement scolaire (École primaire)', '19', 'NULL', '193');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('193', '112', '2051', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «19» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2052', '1014', '1', 'Centre scientifique', '20', 'NULL', '194');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('194', '112', '2052', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «20» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2053', '1014', '1', 'Société', '21', 'NULL', '195');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('195', '112', '2053', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «21» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2054', '1014', '1', 'Établissement scolaire (Université)', '22', 'NULL', '196');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('196', '112', '2054', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «22» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2055', '1014', '1', 'Zoo', '23', 'NULL', '197');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('197', '112', '2055', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «23» pour la liste «11».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2056', '1015', '1', 'Association', '1', 'NULL', '198');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('198', '112', '2056', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «12».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2057', '1015', '1', 'Laboratoire', '2', 'NULL', '199');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('199', '112', '2057', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «12».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2058', '1015', '1', 'Fondation', '3', 'NULL', '200');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('200', '112', '2058', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «12».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2059', '1015', '1', 'Particulier', '4', 'NULL', '201');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('201', '112', '2059', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «12».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2060', '1016', '1', 'Service municipal', '1', 'NULL', '202');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('202', '112', '2060', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «13».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2061', '1016', '1', 'Conseil général', '2', 'NULL', '203');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('203', '112', '2061', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «13».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2062', '1016', '1', 'National', '3', 'NULL', '204');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('204', '112', '2062', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «13».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2063', '1016', '1', 'Université', '4', 'NULL', '205');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('205', '112', '2063', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «13».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2064', '1016', '1', 'Conseil Régional', '5', 'NULL', '206');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('206', '112', '2064', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «13».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2065', '1017', '1', 'Index Herbarorium', 'IH', 'Base de données mondiale où se trouvent répertoriées des informations sur plus de 3000 herbiers publics dans le monde ainsi que leurs équipes. Chaque herbier enregistré dans cet index est désigné également par un acronyme international. Exemple : Herbier de l''Université de Montpellier II = MPU.
Un herbier peut être enregistré dans cette base si ces collections totalisent plus de 5000 échantillons.
Site internet : http://sweetgum.nybg.org/ih/', '207');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('207', '112', '2065', NULL , '2009-06-03 15:40:00' , 'Initialisation de la valeur «IH» pour la liste «14».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2066', '1017', '1', 'Muséum National d''Histoire Naturelle', 'MNHN', 'Pour toute demande de création d''un acronyme français contacter Marc PIGNAL <pignal@mnhn.fr>, chargé de conservation de l''herbier National de Paris (P).
Les herbiers de moins de 5000 spécimens ne seront recensés qu''au niveau du MNHN. Par la suite, lorsque le chiffre de 5000 est atteint, le MNHN en avisera l''Index Herbariorum et communiquera les données.', '208');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('208', '112', '2066', NULL , '2009-06-03 15:40:00' , 'Initialisation de la valeur «MNHN» pour la liste «14».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2067', '1018', '1', 'Réserves', '1', 'Lieu de stockage des collections d''un musée, d''une bibliothèque, etc. qui sert à conserver les collections, les étudier et les gérer mais non accessible au public.', '209');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('209', '112', '2067', NULL , '2009-06-03 15:13:00' , 'Initialisation de la valeur «1» pour la liste «15».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2068', '1018', '1', 'Bâtiment  (ex. : Herbier)', '2', 'NULL', '210');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('210', '112', '2068', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «15».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2069', '1018', '1', 'Pièce', '3', 'NULL', '211');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('211', '112', '2069', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «15».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2070', '1019', '1', 'Rayonnages mobiles type Compactus', '1', 'Rayonnages sur rails pouvant être déplacés, manuellement ou automatiquement, de façon à utiliser l''espace ordinairement occupé par les allées de desserte entre travées.', '212');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('212', '112', '2070', NULL , '2009-06-02 17:05:00' , 'Initialisation de la valeur «1» pour la liste «16».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2071', '1019', '1', 'Armoires métalliques', '2', 'NULL', '213');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('213', '112', '2071', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «16».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2072', '1019', '1', 'Armoires en bois', '3', 'NULL', '214');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('214', '112', '2072', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «16».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2073', '1019', '1', 'Étagères métalliques', '4', 'NULL', '215');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('215', '112', '2073', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «16».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2074', '1019', '1', 'Étagères en bois', '5', 'NULL', '216');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('216', '112', '2074', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «16».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2075', '1020', '1', 'Température extrêmement élevée', '1', 'NULL', '217');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('217', '112', '2075', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «17».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2076', '1020', '1', 'Hygrométrie', '2', 'NULL', '218');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('218', '112', '2076', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «17».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2077', '1020', '1', 'Lumière', '3', 'NULL', '219');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('219', '112', '2077', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «17».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2078', '1020', '1', 'Température extrêmement basse', '4', 'NULL', '220');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('220', '112', '2078', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «17».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2079', '1021', '1', 'Collection d''entomologie (insectes)', '1', 'NULL', '221');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('221', '112', '2079', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «18».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2080', '1021', '1', 'Animaux naturalisés', '2', 'NULL', '222');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('222', '112', '2080', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «18».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2081', '1021', '1', 'Bibliothèque générale', '3', 'NULL', '223');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('223', '112', '2081', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «18».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2082', '1021', '1', 'Bibliothèque botanique', '4', 'NULL', '224');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('224', '112', '2082', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «18».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2083', '1021', '1', 'Collections d''ethnologie', '5', 'NULL', '225');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('225', '112', '2083', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «18».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2084', '1021', '1', 'Archives papier', '6', 'NULL', '226');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('226', '112', '2084', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «6» pour la liste «18».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2085', '1021', '1', 'Collection de diapos/photos', '7', 'NULL', '227');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('227', '112', '2085', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «7» pour la liste «18».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2086', '1021', '1', 'Minéraux', '8', 'NULL', '228');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('228', '112', '2086', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «8» pour la liste «18».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2087', '1022', '1', 'Remplacement des contenants (cartons, planches, etc)', '1', 'NULL', '229');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('229', '112', '2087', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «19».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2088', '1022', '1', 'Remplacement du papier', '2', 'NULL', '230');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('230', '112', '2088', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «19».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2089', '1022', '1', 'Montage des échantillons', '3', 'NULL', '231');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('231', '112', '2089', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «19».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2090', '1022', '1', 'Montage des étiquettes', '4', 'NULL', '232');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('232', '112', '2090', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «19».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2091', '1022', '1', 'Reclassement', '5', 'NULL', '233');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('233', '112', '2091', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «19».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2092', '1023', '1', 'Non', '1', 'NULL', '234');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('234', '112', '2092', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «20».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2093', '1023', '1', 'Oui', '2', 'NULL', '235');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('235', '112', '2093', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «20».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2094', '1023', '1', 'En partie', '3', 'NULL', '236');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('236', '112', '2094', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «20».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2096', '1024', '1', 'Papier normal', '2', 'NULL', '237');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('237', '112', '2096', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «21».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2097', '1024', '1', 'Papier épais', '3', 'NULL', '238');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('238', '112', '2097', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «21».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2098', '1024', '1', 'Papier cartonné', '4', 'NULL', '239');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('239', '112', '2098', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «21».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2099', '1024', '1', 'Colle forte', '5', 'NULL', '240');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('240', '112', '2099', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «21».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2100', '1024', '1', 'Colle en stick', '6', 'NULL', '241');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('241', '112', '2100', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «6» pour la liste «21».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2101', '1024', '1', 'Colle blanche', '7', 'NULL', '242');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('242', '112', '2101', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «7» pour la liste «21».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2102', '1024', '1', 'Ruban adhésif standard', '8', 'NULL', '243');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('243', '112', '2102', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «8» pour la liste «21».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2103', '1025', '1', 'Fumigations', '1', 'NULL', '244');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('244', '112', '2103', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «22».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2104', '1025', '1', 'Paradichlorobenzène ou anti-mites', '2', 'NULL', '245');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('245', '112', '2104', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «22».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2105', '1025', '1', 'Insecticide en bombe', '3', 'NULL', '246');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('246', '112', '2105', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «22».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2106', '1025', '1', 'Anoxie', '4', 'NULL', '247');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('247', '112', '2106', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «22».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2107', '1025', '1', 'Surgélation', '5', 'NULL', '248');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('248', '112', '2107', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «22».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2108', '1025', '1', 'Congélation', '6', 'NULL', '249');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('249', '112', '2108', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «6» pour la liste «22».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2109', '1025', '1', 'Four micro-ondes', '7', 'NULL', '250');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('250', '112', '2109', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «7» pour la liste «22».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2110', '1026', '1', 'Préparation à base de mercure', '1', 'NULL', '251');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('251', '112', '2110', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «23».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2111', '1026', '1', 'Préparation à base d’arsenic', '2', 'NULL', '252');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('252', '112', '2111', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «23».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2112', '1026', '1', 'Préparation à base de mercure et d’arsenic', '3', 'NULL', '253');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('253', '112', '2112', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «23».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2113', '1027', '1', 'Ouvrages', '1', 'NULL', '254');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('254', '112', '2113', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «24».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2114', '1027', '1', 'Articles de presse ou interviews radio / TV', '2', 'NULL', '255');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('255', '112', '2114', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «24».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2115', '1027', '1', 'Animations', '3', 'NULL', '256');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('256', '112', '2115', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «24».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2116', '1027', '1', 'Articles scientifiques', '4', 'NULL', '257');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('257', '112', '2116', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «24».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2117', '1027', '1', 'Visites de groupes', '5', 'NULL', '258');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('258', '112', '2117', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «24».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2118', '1027', '1', 'Conférences', '6', 'NULL', '259');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('259', '112', '2118', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «6» pour la liste «24».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2119', '1027', '1', 'Expositions', '7', 'NULL', '260');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('260', '112', '2119', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «7» pour la liste «24».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2120', '1028', '1', 'France', '1', 'NULL', '261');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('261', '112', '2120', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «25».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2121', '1028', '1', 'Europe', '2', 'NULL', '262');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('262', '112', '2121', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «25».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2122', '1028', '1', 'Asie', '3', 'NULL', '263');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('263', '112', '2122', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «25».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2123', '1028', '1', 'Amérique', '4', 'NULL', '264');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('264', '112', '2123', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «25».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2124', '1028', '1', 'Afrique', '5', 'NULL', '265');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('265', '112', '2124', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «25».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2125', '1028', '1', 'Océanie', '6', 'NULL', '266');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('266', '112', '2125', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «6» pour la liste «25».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2126', '1029', '1', 'Systématique', '1', 'NULL', '267');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('267', '112', '2126', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «26».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2127', '1029', '1', 'Chorologie', '2', 'NULL', '268');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('268', '112', '2127', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «26».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2128', '1029', '1', 'Biologie moléculaire', '3', 'NULL', '269');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('269', '112', '2128', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «26».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2129', '1029', '1', 'Pharmacie', '4', 'NULL', '270');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('270', '112', '2129', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «26».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2130', '1029', '1', 'Ethnobotanique', '5', 'NULL', '271');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('271', '112', '2130', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «26».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2131', '1029', '1', 'Histoire des sciences', '6', 'NULL', '272');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('272', '112', '2131', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «6» pour la liste «26».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2132', '1029', '1', 'Palynologie', '7', 'NULL', '273');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('273', '112', '2132', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «7» pour la liste «26».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2133', '1029', '1', 'Paléobotanique', '8', 'NULL', '274');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('274', '112', '2133', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «8» pour la liste «26».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2134', '1030', '1', 'Contributeur (celui qui a saisi la fiche le premier)', '1', 'NULL', '275');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('275', '112', '2134', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «27».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2135', '1030', '1', 'Auteur', '2', 'NULL', '276');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('276', '112', '2135', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «27».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2136', '1030', '1', 'Collecteur', '3', 'NULL', '277');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('277', '112', '2136', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «27».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2137', '1030', '1', 'Déterminateur', '4', 'NULL', '278');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('278', '112', '2137', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «27».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2138', '1030', '1', 'Hébergeur (particulier possédant une collection chez lui)', '5', 'NULL', '279');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('279', '112', '2138', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «27».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2139', '1031', '1', 'inclu dans', '1', 'NULL', '280');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('280', '112', '2139', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «28».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2140', '1032', '1', 'Archive', 'archival', 'NULL', '281');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('281', '112', '2140', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «archival» pour la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2141', '1032', '1', 'Art', 'art', 'NULL', '282');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('282', '112', '2141', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «art» pour la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2142', '1032', '1', 'Audio', 'audio', 'NULL', '283');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('283', '112', '2142', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «audio» pour la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2143', '1032', '1', 'Culture de cellules', 'cellcultures', 'NULL', '284');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('284', '112', '2143', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «cellcultures» pour la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2144', '1032', '1', 'Électronique', 'electronic', 'NULL', '285');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('285', '112', '2144', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «electronic» pour la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2145', '1032', '1', 'Facsimilés', 'facsimiles', 'NULL', '286');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('286', '112', '2145', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «facsimiles» pour la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2146', '1032', '1', 'Fossiles', 'fossils', 'NULL', '287');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('287', '112', '2146', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «fossils» pour la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2147', '1032', '1', 'Génétique', 'genetic', 'NULL', '288');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('288', '112', '2147', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «genetic» pour la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2148', '1032', '1', 'Vivante', 'living', 'NULL', '289');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('289', '112', '2148', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «living» pour la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2149', '1032', '1', 'Observations', 'observations', 'NULL', '290');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('290', '112', '2149', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «observations» pour la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2150', '1032', '1', 'Préservée', 'preserved', 'NULL', '291');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('291', '112', '2150', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «preserved» pour la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2151', '1032', '1', 'Produits', 'products', 'NULL', '292');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('292', '112', '2151', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «products» pour la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2152', '1032', '1', 'Spécimens', 'taxonomic', 'NULL', '293');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('293', '112', '2152', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «taxonomic» pour la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2153', '1032', '1', 'Textes (Manuscrits)', 'texts', 'NULL', '294');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('294', '112', '2153', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «texts» pour la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2154', '1032', '1', 'Tissus biologiques', 'tissue', 'NULL', '295');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('295', '112', '2154', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «tissue» pour la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2155', '1032', '1', 'Visuelle', 'visual', 'NULL', '296');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('296', '112', '2155', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «visual» pour la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2156', '1032', '1', 'Géologique', '_geologique_', 'NULL', '297');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('297', '112', '2156', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «_geologique_» pour la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2157', '1032', '1', 'Herbier', '_herbier_', 'NULL', '298');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('298', '112', '2157', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «_herbier_» pour la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2158', '1032', '1', 'Minéralogique', '_mineralogique_', 'NULL', '299');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('299', '112', '2158', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «_mineralogique_» pour la liste «29».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2159', '1033', '1', 'Patrimoine de l''institution', '1', 'NULL', '300');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('300', '112', '2159', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «30».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2160', '1033', '1', 'Dépôt permanent', '2', 'NULL', '301');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('301', '112', '2160', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «30».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2161', '1033', '1', 'Dépôt temporaire', '3', 'NULL', '302');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('302', '112', '2161', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «30».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2162', '1033', '1', 'Dépôt non consultable (privé)', '4', 'NULL', '303');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('303', '112', '2162', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «30».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2163', '1033', '1', 'Prêt', '5', 'NULL', '304');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('304', '112', '2163', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «30».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2164', '1034', '1', 'Culturel', 'cultural', 'NULL', '305');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('305', '112', '2164', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «cultural» pour la liste «31».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2165', '1034', '1', 'Écosystème', 'ecosystems', 'NULL', '306');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('306', '112', '2165', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «ecosystems» pour la liste «31».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2166', '1034', '1', 'Environmental', 'environmental', 'NULL', '307');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('307', '112', '2166', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «environmental» pour la liste «31».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2167', '1034', '1', 'Évènement', 'events', 'NULL', '308');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('308', '112', '2167', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «events» pour la liste «31».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2168', '1034', '1', 'Expédition', 'expeditions', 'NULL', '309');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('309', '112', '2168', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «expeditions» pour la liste «31».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2169', '1034', '1', 'National', 'national', 'NULL', '310');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('310', '112', '2169', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «national» pour la liste «31».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2170', '1034', '1', 'Relation biologique', 'relationships', 'NULL', '311');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('311', '112', '2170', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «relationships» pour la liste «31».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2171', '1034', '1', 'Dépôt', 'repository', 'NULL', '312');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('312', '112', '2171', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «repository» pour la liste «31».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2172', '1034', '1', 'Spatial', 'spatial', 'NULL', '313');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('313', '112', '2172', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «spatial» pour la liste «31».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2173', '1034', '1', 'Stade de développement', 'stage', 'NULL', '314');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('314', '112', '2173', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «stage» pour la liste «31».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2174', '1034', '1', 'Taxonomique', 'taxonomic', 'NULL', '315');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('315', '112', '2174', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «taxonomic» pour la liste «31».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2175', '1034', '1', 'Période', 'temporal', 'NULL', '316');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('316', '112', '2175', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «temporal» pour la liste «31».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2176', '1035', '1', 'Commercial', 'commercial', 'NULL', '317');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('317', '112', '2176', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «commercial» pour la liste «32».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2177', '1035', '1', 'Analyses destructrices', 'destructiveAnalysis', 'NULL', '318');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('318', '112', '2177', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «destructiveAnalysis» pour la liste «32».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2178', '1035', '1', 'Éducation', 'education', 'NULL', '319');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('319', '112', '2178', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «education» pour la liste «32».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2179', '1035', '1', 'Présentation', 'exhibition', 'NULL', '320');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('320', '112', '2179', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «exhibition» pour la liste «32».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2180', '1035', '1', 'Étude', 'monitoring', 'NULL', '321');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('321', '112', '2180', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «monitoring» pour la liste «32».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2181', '1035', '1', 'Ornemental', 'ornamental', 'NULL', '322');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('322', '112', '2181', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «ornamental» pour la liste «32».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2182', '1035', '1', 'personnel', 'personal', 'NULL', '323');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('323', '112', '2182', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «personal» pour la liste «32».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2183', '1035', '1', 'Recherche', 'research', 'NULL', '324');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('324', '112', '2183', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «research» pour la liste «32».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2184', '1035', '1', 'Voucher (à traduire)', 'voucher', 'NULL', '325');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('325', '112', '2184', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «voucher» pour la liste «32».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2185', '1036', '1', 'Mac Ginley 1', 'McGinley1', 'Specimens deteriorating, potentially cullable, or unprepared. Collection unit in need of immediate attention; museum pests, rusting pins, crystallizing slide media, unringed Hoyer''s media, evaporated alcohol, fading labels, broken cover slip or slide, etc. Primary types missed in general collection.', '326');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('326', '112', '2185', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «McGinley1» pour la liste «33».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2186', '1036', '1', 'Mac Ginley 2', 'McGinley2', 'Material properly prepared but not sorted or only rough-sorted; not readily available to specialists.', '327');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('327', '112', '2186', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «McGinley2» pour la liste «33».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2187', '1036', '1', 'Mac Ginley 3', 'McGinley3', 'Specimens sorted to a level necessary to be efficiently accessible to research specialist for study. All specimens in soft-bottom trays, shell vials in jars or slide boxes, with appropriate levels denoting pertinent taxonomic information. Taxonomic category may vary among different taxa.', '328');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('328', '112', '2187', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «McGinley3» pour la liste «33».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2188', '1036', '1', 'Mac Ginley 4', 'McGinley4', 'Valuable material that has been identified to the species level but not yet put away effectively inaccessible.', '329');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('329', '112', '2188', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «McGinley4» pour la liste «33».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2189', '1036', '1', 'Mac Ginley 5', 'McGinley5', 'All specimens identified and integrated. However, this collection unit needs upgrading, e.g., names checked, header labels for unit trays prepared, transfer to soft-bottom trays, etc., box header labels checked against slides. Alcoholic collection with individual exposed vials, jar labels misleading or without detail, overall format heterogenous.', '330');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('330', '112', '2189', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «McGinley5» pour la liste «33».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2190', '1036', '1', 'Mac Ginley 6', 'McGinley6', 'All specimens in soft-bottom unit trays; all unit-tray header labels, drawer or box, and cabinet labels completed; space left for expansion. When a collection reaches Level 6, the name(s) or who did the curation, the date of curation and listing of catalogues or monographs on which the names are based should be entered in the Smithsonian Collection Inventory File computerized files. Vial within jar system established, labels complete and accurately typed, expansion space allocated, and alcohol levels adequate.', '331');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('331', '112', '2190', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «McGinley6» pour la liste «33».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2191', '1036', '1', 'Mac Ginley 7', 'McGinley7', 'Species inventory with header or box label generation completed. Alcoholic collection with taxa listed on jar labels and in database, as in Level 6 plus species-level inventory.', '332');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('332', '112', '2191', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «McGinley7» pour la liste «33».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2192', '1036', '1', 'Mac Ginley 8', 'McGinley8', 'Label data are recorded for systematic, biogeography or natural history studies. The data elements recorded will vary by group, however, a d standard core set includes the following: a) a country/province/place/latitude-longitude; b) date of collection; c) collector(s); d) miscellaneous (for example, elevation, host). Miscellaneous voucher specimens, including types, from various studies are also ranked at this level.', '333');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('333', '112', '2192', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «McGinley8» pour la liste «33».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2193', '1036', '1', 'Mac Ginley 9', 'McGinley9', 'Measurements, graphics, or other pertinent (descriptions) of specimens are captured in a database.', '334');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('334', '112', '2193', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «McGinley9» pour la liste «33».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2194', '1036', '1', 'Mac Ginley 10', 'McGinley10', 'Groups of specimens included in published monographic, synthetic, or revisionary works, including primary type collection if storage is at Level 7 or higher. When groups of specimens serve to voucher published scientific collection-based studies and have undergone conservation and accession requirements of at least Level 7.', '335');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('335', '112', '2194', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «McGinley10» pour la liste «33».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2195', '1037', '1', 'Animal', 'Animalia', 'NULL', '336');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('336', '112', '2195', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «Animalia» pour la liste «34».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2196', '1037', '1', 'Champignon', 'Fungi', 'NULL', '337');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('337', '112', '2196', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «Fungi» pour la liste «34».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2197', '1037', '1', 'Végétal', 'Plantae', 'NULL', '338');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('338', '112', '2197', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «Plantae» pour la liste «34».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2198', '1037', '1', 'Protiste', 'Protista', 'NULL', '339');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('339', '112', '2198', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «Protista» pour la liste «34».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2199', '1037', '1', 'Archéobactérie', 'Archaebacteria', 'NULL', '340');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('340', '112', '2199', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «Archaebacteria» pour la liste «34».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2200', '1037', '1', 'Eubactérie', 'Eubacteria', 'NULL', '341');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('341', '112', '2200', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «Eubacteria» pour la liste «34».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2201', '1038', '1', 'Atmosphère contrôlée', 'controlledAtmosphere', 'NULL', '342');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('342', '112', '2201', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «controlledAtmosphere» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2202', '1038', '1', 'Cryogénisation', 'cryopreserved', 'NULL', '343');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('343', '112', '2202', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «cryopreserved» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2203', '1038', '1', 'Séchée', 'dried', 'NULL', '344');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('344', '112', '2203', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «dried» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2204', '1038', '1', 'Séchée et pressée', 'driedAndPressed', 'NULL', '345');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('345', '112', '2204', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «driedAndPressed» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2205', '1038', '1', 'Enchâssé (Maintenu dans une matrice solide, convenant pour la confection des lames minces)', 'embedded', 'NULL', '346');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('346', '112', '2205', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «embedded» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2206', '1038', '1', 'Préservation dans un liquide', 'fluidPreserved', 'NULL', '347');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('347', '112', '2206', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «fluidPreserved» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2207', '1038', '1', 'Réfrigéré et séché', 'freezeDried', 'NULL', '348');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('348', '112', '2207', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «freezeDried» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2208', '1038', '1', 'Congelé', 'frozen', 'NULL', '349');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('349', '112', '2208', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «frozen» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2209', '1038', '1', 'Glycérine', 'glycerin', 'NULL', '350');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('350', '112', '2209', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «glycerin» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2210', '1038', '1', 'Inapplicable', 'notApplicable', 'NULL', '351');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('351', '112', '2210', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «notApplicable» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2211', '1038', '1', 'Aucun traitement', 'noTreatment', 'NULL', '352');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('352', '112', '2211', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «noTreatment» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2212', '1038', '1', 'Attaché (Épinglé)', 'pinned', 'NULL', '353');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('353', '112', '2212', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «pinned» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2213', '1038', '1', 'Enregistrement analogique', 'recordedAnalog', 'NULL', '354');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('354', '112', '2213', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «recordedAnalog» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2214', '1038', '1', 'Enregistrement numérique', 'recordedDigital', 'NULL', '355');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('355', '112', '2214', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «recordedDigital» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2215', '1038', '1', 'Réfrigéré', 'refrigerated', 'NULL', '356');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('356', '112', '2215', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «refrigerated» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2216', '1038', '1', 'Préparation pour microscope électronique à balayage', 'semstub', 'NULL', '357');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('357', '112', '2216', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «semstub» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2217', '1038', '1', 'Squelette', 'skeletonized', 'NULL', '358');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('358', '112', '2217', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «skeletonized» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2218', '1038', '1', 'Préparation microscopique', 'slideMount', 'NULL', '359');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('359', '112', '2218', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «slideMount» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2219', '1038', '1', 'Stase', 'stasis', 'NULL', '360');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('360', '112', '2219', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «stasis» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2220', '1038', '1', 'surfaceCoating', 'surfaceCoating', 'NULL', '361');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('361', '112', '2220', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «surfaceCoating» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2221', '1038', '1', 'Tanage', 'tanned', 'NULL', '362');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('362', '112', '2221', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «tanned» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2222', '1038', '1', 'Alcool', '_fluidPreservedAlcohol_', 'NULL', '363');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('363', '112', '2222', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «_fluidPreservedAlcohol_» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2223', '1038', '1', 'Formol', '_fluidPreservedFormolin_', 'NULL', '364');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('364', '112', '2223', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «_fluidPreservedFormolin_» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2224', '1038', '1', 'Gomme arabique', '_gumArabic_', 'NULL', '365');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('365', '112', '2224', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «_gumArabic_» pour la liste «35».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2225', '1039', '1', 'Croissance active', 'activegrowth', 'NULL', '366');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('366', '112', '2225', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «activegrowth» pour la liste «36».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2226', '1039', '1', 'Fermée', 'closed', 'NULL', '367');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('367', '112', '2226', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «closed» pour la liste «36».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2227', '1039', '1', 'Consommable', 'consumable', 'NULL', '368');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('368', '112', '2227', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «consumable» pour la liste «36».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2228', '1039', '1', 'Décroissance', 'decreasing', 'NULL', '369');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('369', '112', '2228', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «decreasing» pour la liste «36».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2229', '1039', '1', 'Perdu', 'lost', 'NULL', '370');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('370', '112', '2229', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «lost» pour la liste «36».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2230', '1039', '1', 'Manquante', 'missing', 'NULL', '371');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('371', '112', '2230', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «missing» pour la liste «36».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2231', '1039', '1', 'Croissance passive', 'passivegrowth', 'NULL', '372');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('372', '112', '2231', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «passivegrowth» pour la liste «36».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2232', '1039', '1', 'Statique', 'static', 'NULL', '373');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('373', '112', '2232', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «static» pour la liste «36».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2233', '1040', '1', '16ème siècle', '1', 'NULL', '374');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('374', '112', '2233', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «37».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2234', '1040', '1', '17ème siècle', '2', 'NULL', '375');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('375', '112', '2234', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «37».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2235', '1040', '1', '18ème siècle', '3', 'NULL', '376');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('376', '112', '2235', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «37».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2236', '1040', '1', '19ème siècle', '4', 'NULL', '377');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('377', '112', '2236', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «37».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2237', '1040', '1', '20ème siècle', '5', 'NULL', '378');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('378', '112', '2237', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «37».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2238', '1040', '1', '21ème siècle', '6', 'NULL', '379');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('379', '112', '2238', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «6» pour la liste «37».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2239', '1041', '1', 'Indéterminé (= ne sais pas)', '1', 'NULL', '380');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('380', '112', '2239', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «38».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2240', '1041', '1', 'Peut-être', '2', 'NULL', '381');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('381', '112', '2240', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «38».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2241', '1041', '1', 'Oui', '3', 'NULL', '382');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('382', '112', '2241', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «38».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2242', '1041', '1', 'Nom', '4', 'NULL', '383');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('383', '112', '2242', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «38».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2243', '1042', '1', 'À part', '1', 'NULL', '384');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('384', '112', '2243', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «39».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2244', '1042', '1', 'Inclus', '2', 'NULL', '385');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('385', '112', '2244', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «39».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2245', '1042', '1', 'Partiellement extraits', '3', 'NULL', '386');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('386', '112', '2245', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «39».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2246', '1043', '1', 'Phanérogames', '1', 'NULL', '387');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('387', '112', '2246', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «40».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2247', '1043', '1', 'Gymnosperme (Conifère)', '2', 'NULL', '388');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('388', '112', '2247', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «40».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2248', '1043', '1', 'Angiosperme (plantes à fleur)', '3', 'NULL', '389');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('389', '112', '2248', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «40».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2249', '1043', '1', 'Cryptogames', '4', 'NULL', '390');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('390', '112', '2249', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «40».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2250', '1043', '1', 'Algues (y compris Characées et Diatomées)', '5', 'NULL', '391');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('391', '112', '2250', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «40».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2251', '1043', '1', 'Champignons', '6', 'NULL', '392');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('392', '112', '2251', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «6» pour la liste «40».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2252', '1043', '1', 'Lichens', '7', 'NULL', '393');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('393', '112', '2252', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «7» pour la liste «40».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2253', '1043', '1', 'Bryophytes (Mousses)', '8', 'NULL', '394');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('394', '112', '2253', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «8» pour la liste «40».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2254', '1043', '1', 'Ptéridophytes (Fougères)', '9', 'NULL', '395');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('395', '112', '2254', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «9» pour la liste «40».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2255', '1044', '1', 'Cartons d''herbiers', '1', 'NULL', '396');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('396', '112', '2255', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «41».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2256', '1044', '1', 'Liasses', '2', 'NULL', '397');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('397', '112', '2256', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «41».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2257', '1044', '1', 'Ouvrages reliés (cahiers, livres, ...)', '3', 'NULL', '398');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('398', '112', '2257', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «41».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2258', '1044', '1', 'Classeurs', '4', 'NULL', '399');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('399', '112', '2258', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «41».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2259', '1044', '1', 'Pochettes à élastiques', '5', 'NULL', '400');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('400', '112', '2259', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «41».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2260', '1044', '1', 'Bocaux', '6', 'NULL', '401');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('401', '112', '2260', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «6» pour la liste «41».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2261', '1044', '1', 'Boîtes d''herbier en bois', '7', 'NULL', '402');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('402', '112', '2261', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «7» pour la liste «41».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2262', '1044', '1', 'Piluliers (en bois, plastique, verre, ...)', '8', 'NULL', '403');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('403', '112', '2262', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «8» pour la liste «41».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2263', '1044', '1', 'Boîtes de péparations microscopiques', '9', 'NULL', '404');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('404', '112', '2263', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «9» pour la liste «41».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2264', '1044', '1', 'Boîtes à chaussures', '10', 'NULL', '405');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('405', '112', '2264', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «10» pour la liste «41».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2265', '1045', '1', 'Très mauvais état, à remplacer d''urgence', '1', 'NULL', '406');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('406', '112', '2265', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «42».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2266', '1045', '1', 'Mauvais état, remplacement à faire assez rapidement', '2', 'NULL', '407');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('407', '112', '2266', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «42».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2267', '1045', '1', 'État moyen, remplacement à envisager', '3', 'NULL', '408');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('408', '112', '2267', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «42».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2268', '1045', '1', 'Bon état, peu de restauration à faire', '4', 'NULL', '409');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('409', '112', '2268', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «42».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2269', '1045', '1', 'Très bon état, pas de restauration', '5', 'NULL', '410');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('410', '112', '2269', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «42».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2270', '1046', '1', 'Planches d''herbiers', '1', 'NULL', '411');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('411', '112', '2270', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «43».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2271', '1046', '1', 'Lames de préparations microscopiques', '2', 'NULL', '412');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('412', '112', '2271', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «43».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2272', '1046', '1', 'Boîtes (à allumettes, à savons...)', '3', 'NULL', '413');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('413', '112', '2272', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «43».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2273', '1046', '1', 'Enveloppes', '4', 'NULL', '414');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('414', '112', '2273', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «43».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2274', '1046', '1', 'Plaques de carton', '5', 'NULL', '415');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('415', '112', '2274', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «43».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2275', '1046', '1', 'Pochettes en plastiques pour classeur', '6', 'NULL', '416');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('416', '112', '2275', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «6» pour la liste «43».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2276', '1047', '1', 'Journal', '1', 'NULL', '417');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('417', '112', '2276', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «44».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2277', '1047', '1', 'Papier cartonné', '2', 'NULL', '418');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('418', '112', '2277', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «44».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2278', '1047', '1', 'Papier normal', '3', 'NULL', '419');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('419', '112', '2278', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «44».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2279', '1047', '1', 'Papier épais', '4', 'NULL', '420');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('420', '112', '2279', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «44».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2280', '1047', '1', 'Buvard', '5', 'NULL', '421');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('421', '112', '2280', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «44».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2281', '1047', '1', 'Papier très fin', '6', 'NULL', '422');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('422', '112', '2281', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «6» pour la liste «44».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2282', '1047', '1', 'Cahier', '7', 'NULL', '423');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('423', '112', '2282', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «7» pour la liste «44».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2283', '1048', '1', 'Dans des chemises', '1', 'NULL', '424');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('424', '112', '2283', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «45».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2284', '1048', '1', 'Sur des feuilles', '2', 'NULL', '425');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('425', '112', '2284', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «45».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2285', '1048', '1', 'Sur des feuilles incluses dans des chemises', '3', 'NULL', '426');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('426', '112', '2285', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «45».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2286', '1048', '1', 'Sur des feuilles incluses dans des pochettes plastique', '4', 'NULL', '427');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('427', '112', '2286', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «45».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2287', '1048', '1', 'Dans des sachets cellophane', '5', 'NULL', '428');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('428', '112', '2287', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «45».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2288', '1048', '1', 'Sur des lames de verre', '6', 'NULL', '429');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('429', '112', '2288', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «6» pour la liste «45».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2289', '1049', '1', 'Papier gommé', '1', 'NULL', '430');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('430', '112', '2289', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «46».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2290', '1049', '1', 'Colle', '2', 'NULL', '431');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('431', '112', '2290', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «46».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2291', '1049', '1', 'Cousus au support', '3', 'NULL', '432');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('432', '112', '2291', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «46».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2292', '1049', '1', 'Épinglés au support', '4', 'NULL', '433');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('433', '112', '2292', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «46».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2293', '1049', '1', 'Glissés dans des fentes découpées dans le support', '5', 'NULL', '434');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('434', '112', '2293', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «46».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2294', '1049', '1', 'Plastifiés', '6', 'NULL', '435');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('435', '112', '2294', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «6» pour la liste «46».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2295', '1049', '1', 'Papier adhésif typescotch', '7', 'NULL', '436');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('436', '112', '2295', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «7» pour la liste «46».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2296', '1050', '1', 'Par épingles', '1', 'NULL', '437');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('437', '112', '2296', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «47».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2297', '1050', '1', 'Par un fil', '2', 'NULL', '438');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('438', '112', '2297', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «47».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2298', '1050', '1', 'Spécimens glissés dans des fentes découpées dans l''étiquette', '3', 'NULL', '439');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('439', '112', '2298', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «47».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2299', '1051', '1', 'Manuscrites', '1', 'NULL', '440');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('440', '112', '2299', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «48».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2300', '1051', '1', 'Dactylographiées', '2', 'NULL', '441');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('441', '112', '2300', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «48».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2301', '1051', '1', 'Imprimées', '3', 'NULL', '442');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('442', '112', '2301', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «48».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2302', '1051', '1', 'Ronéotypées', '4', 'NULL', '443');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('443', '112', '2302', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «48».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2303', '1052', '1', 'Humidité / moisissures', '1', 'NULL', '444');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('444', '112', '2303', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «49».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2304', '1052', '1', 'Attaques d''insectes', '2', 'NULL', '445');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('445', '112', '2304', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «49».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2305', '1052', '1', 'Attaques de rongeurs', '3', 'NULL', '446');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('446', '112', '2305', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «49».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2306', '1053', '1', 'Humidité / moisissures', '1', 'NULL', '447');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('447', '112', '2306', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «50».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2307', '1053', '1', 'Attaques d''insectes', '2', 'NULL', '448');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('448', '112', '2307', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «50».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2308', '1053', '1', 'Attaques de rongeurs', '3', 'NULL', '449');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('449', '112', '2308', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «50».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2309', '1053', '1', 'Papiers usagés', '4', 'NULL', '450');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('450', '112', '2309', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «50».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2310', '1053', '1', 'Spécimens et étiquettes mélangés ou détachés', '5', 'NULL', '451');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('451', '112', '2310', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «50».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2311', '1054', '1', 'Uniquement des fragments, aucune détermination sure n''est possible', '1', 'NULL', '452');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('452', '112', '2311', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «51».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2312', '1054', '1', 'Échantillons de plus grandes tailles mais majoritairement sans les  organes nécessaires à la détermi', '2', 'NULL', '453');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('453', '112', '2312', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «51».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2313', '1054', '1', 'Une bonne partie des échantillons peuvent être déterminés', '3', 'NULL', '454');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('454', '112', '2313', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «51».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2314', '1054', '1', 'Ma majorité des échantillons peuvent être déterminés', '4', 'NULL', '455');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('455', '112', '2314', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «51».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2315', '1054', '1', 'Tous les échantillons présentent les caractères nécessaires à la détermination', '5', 'NULL', '456');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('456', '112', '2315', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «51».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2316', '1055', '1', 'Date inconnue', '1', 'NULL', '457');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('457', '112', '2316', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «52».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2317', '1055', '1', 'Date exacte', '2', 'NULL', '458');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('458', '112', '2317', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «52».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2318', '1055', '1', 'Antérieure à', '3', 'NULL', '459');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('459', '112', '2318', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «52».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2319', '1055', '1', 'Postérieure à', '4', 'NULL', '460');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('460', '112', '2319', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «52».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2320', '1055', '1', 'Date estimée', '5', 'NULL', '461');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('461', '112', '2320', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «52».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2321', '1056', '1', 'Date inconnue', '1', 'NULL', '462');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('462', '112', '2321', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «53».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2322', '1056', '1', 'Date exacte', '2', 'NULL', '463');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('463', '112', '2322', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «53».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2323', '1056', '1', 'Antérieure à', '3', 'NULL', '464');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('464', '112', '2323', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «53».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2324', '1056', '1', 'Postérieure à', '4', 'NULL', '465');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('465', '112', '2324', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «53».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2325', '1056', '1', 'Date estimée', '5', 'NULL', '466');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('466', '112', '2325', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «53».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2326', '1056', '1', 'Encore en activité', '6', 'NULL', '467');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('467', '112', '2326', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «6» pour la liste «53».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2327', '1057', '1', 'Contenants et parts sans classement, recherche d''échantillon précis très difficile, classement à met', '1', 'NULL', '468');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('468', '112', '2327', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «54».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2328', '1057', '1', 'Classement existant à l''origine mais mélangé,  rangement à faire assez rapidement', '2', 'NULL', '469');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('469', '112', '2328', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «54».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2329', '1057', '1', 'Classement respecté mais pas dans son intégralité, rangement à envisager', '3', 'NULL', '470');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('470', '112', '2329', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «54».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2330', '1057', '1', 'Peu déclassé, peu de rangement à effectuer', '4', 'NULL', '471');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('471', '112', '2330', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «54».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2331', '1057', '1', 'Entièrement classé', '5', 'NULL', '472');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('472', '112', '2331', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «54».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2332', '1058', '1', 'Nom de l''auteur de la collection botanique ou du titre de la collection', '1', 'NULL', '473');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('473', '112', '2332', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «55».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2333', '1058', '1', 'Nom de famille', '2', 'NULL', '474');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('474', '112', '2333', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «55».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2334', '1058', '1', 'Nom de genre', '3', 'NULL', '475');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('475', '112', '2334', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «55».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2335', '1058', '1', 'Nom de l''espèce', '4', 'NULL', '476');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('476', '112', '2335', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «55».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2336', '1058', '1', 'Nom d''auteur', '5', 'NULL', '477');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('477', '112', '2336', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «5» pour la liste «55».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2337', '1058', '1', 'Localité de récolte', '6', 'NULL', '478');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('478', '112', '2337', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «6» pour la liste «55».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2338', '1058', '1', 'Date de récolte', '7', 'NULL', '479');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('479', '112', '2338', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «7» pour la liste «55».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2339', '1059', '1', 'Oui', '1', 'NULL', '480');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('480', '112', '2339', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «56».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2340', '1059', '1', 'Nom', '2', 'NULL', '481');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('481', '112', '2340', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «56».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2341', '1059', '1', 'En grande partie', '3', 'NULL', '482');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('482', '112', '2341', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «56».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2342', '1060', '1', 'Indéterminé (= ne sais pas)', '1', 'NULL', '483');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('483', '112', '2342', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «57».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2343', '1060', '1', 'Parfois', '2', 'NULL', '484');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('484', '112', '2343', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «57».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2344', '1060', '1', 'Oui', '3', 'NULL', '485');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('485', '112', '2344', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «57».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2345', '1060', '1', 'Nom', '4', 'NULL', '486');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('486', '112', '2345', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «57».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2346', '1061', '1', 'Manuscrite', '1', 'NULL', '487');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('487', '112', '2346', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «58».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2347', '1061', '1', 'Imprimé', '2', 'NULL', '488');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('488', '112', '2347', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «58».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2348', '1061', '1', 'Informatique', '3', 'NULL', '489');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('489', '112', '2348', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «58».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2349', '1062', '1', 'Sonnerat/BryoMyco', '1', 'NULL', '490');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('490', '112', '2349', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «1» pour la liste «59».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2350', '1062', '1', '4D', '2', 'NULL', '491');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('491', '112', '2350', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «2» pour la liste «59».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2351', '1062', '1', 'SNBase', '3', 'NULL', '492');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('492', '112', '2351', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «3» pour la liste «59».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2352', '1062', '1', 'Dbase', '4', 'NULL', '493');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('493', '112', '2352', NULL , '2009-03-19 13:07:47' , 'Initialisation de la valeur «4» pour la liste «59».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2353', '1062', '1', 'Access', '5', 'NULL', '494');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('494', '112', '2353', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «5» pour la liste «59».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2354', '1062', '1', 'File Maker', '6', 'NULL', '495');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('495', '112', '2354', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «6» pour la liste «59».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2355', '1062', '1', 'Excel', '7', 'NULL', '496');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('496', '112', '2355', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «7» pour la liste «59».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2356', '1062', '1', 'Word', '8', 'NULL', '497');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('497', '112', '2356', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «8» pour la liste «59».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2357', '1063', '1', 'Indéterminé (= ne sais pas)', '1', 'NULL', '498');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('498', '112', '2357', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «1» pour la liste «60».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2358', '1063', '1', 'Complet', '2', 'NULL', '499');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('499', '112', '2358', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «2» pour la liste «60».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2359', '1063', '1', 'En cours', '3', 'NULL', '500');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('500', '112', '2359', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «3» pour la liste «60».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2360', '1064', '1', 'Auteur', '1', 'NULL', '501');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('501', '112', '2360', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «1» pour la liste «61».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2361', '1065', '1', 'Nécrologie', '1', 'NULL', '502');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('502', '112', '2361', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «1» pour la liste «62».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2362', '1065', '1', 'Biographie', '2', 'NULL', '503');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('503', '112', '2362', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «2» pour la liste «62».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2363', '1065', '1', 'Publication personnelle', '3', 'NULL', '504');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('504', '112', '2363', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «3» pour la liste «62».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2364', '1066', '1', 'Page Web', 'WEB', 'NULL', '505');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('505', '112', '2364', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «WEB» pour la liste «63».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2365', '1066', '1', 'URL d''un logo', 'LOGO', 'NULL', '506');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('506', '112', '2365', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «LOGO» pour la liste «63».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2834', '1066', '1', 'URL d''une page d''information sur l''objet lié', 'INFO', 'NULL', '507');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('507', '112', '2834', NULL , '2009-05-25 13:03:00' , 'Initialisation de la valeur «INFO» pour la liste «63».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2366', '1067', '1', 'Homme', 'H', 'NULL', '508');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('508', '112', '2366', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «H» pour la liste «64».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2367', '1067', '1', 'Femme', 'F', 'NULL', '509');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('509', '112', '2367', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «F» pour la liste «64».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2368', '1068', '1', 'Géographique', '1', 'NULL', '510');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('510', '112', '2368', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «1» pour la liste «65».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2369', '1068', '1', 'Taxinomique', '2', 'NULL', '511');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('511', '112', '2369', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «2» pour la liste «65».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2370', '1068', '1', 'Historique', '3', 'NULL', '512');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('512', '112', '2370', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «3» pour la liste «65».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2371', '1068', '1', 'Échantillons-types', '4', 'NULL', '513');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('513', '112', '2371', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «4» pour la liste «65».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2372', '1068', '1', 'Collecteurs', '5', 'NULL', '514');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('514', '112', '2372', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «5» pour la liste «65».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2373', '1068', '1', 'Statut', '6', 'NULL', '515');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('515', '112', '2373', NULL , '2009-03-19 13:07:48' , 'Initialisation de la valeur «6» pour la liste «65».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2381', '1071', '1', 'Afar', 'AA', 'NULL', '516');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('516', '112', '2381', NULL , '2009-04-08 12:04:18' , 'Initialisation de la valeur «AA» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2382', '1071', '1', 'Abkhaze', 'AB', 'NULL', '517');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('517', '112', '2382', NULL , '2009-04-08 12:04:19' , 'Initialisation de la valeur «AB» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2383', '1071', '1', 'Avestique', 'AE', 'NULL', '518');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('518', '112', '2383', NULL , '2009-04-08 12:04:20' , 'Initialisation de la valeur «AE» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2384', '1071', '1', 'Afrikaans', 'AF', 'NULL', '519');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('519', '112', '2384', NULL , '2009-04-08 12:04:21' , 'Initialisation de la valeur «AF» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2385', '1071', '1', 'Akan', 'AK', 'NULL', '520');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('520', '112', '2385', NULL , '2009-04-08 12:04:22' , 'Initialisation de la valeur «AK» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2386', '1071', '1', 'Amharique', 'AM', 'NULL', '521');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('521', '112', '2386', NULL , '2009-04-08 12:04:23' , 'Initialisation de la valeur «AM» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2387', '1071', '1', 'Aragonais', 'AN', 'NULL', '522');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('522', '112', '2387', NULL , '2009-04-08 12:04:24' , 'Initialisation de la valeur «AN» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2388', '1071', '1', 'Arabe', 'AR', 'NULL', '523');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('523', '112', '2388', NULL , '2009-04-08 12:04:25' , 'Initialisation de la valeur «AR» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2389', '1071', '1', 'Assamais', 'AS', 'NULL', '524');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('524', '112', '2389', NULL , '2009-04-08 12:04:26' , 'Initialisation de la valeur «AS» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2390', '1071', '1', 'Avar', 'AV', 'NULL', '525');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('525', '112', '2390', NULL , '2009-04-08 12:04:27' , 'Initialisation de la valeur «AV» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2391', '1071', '1', 'Aymara', 'AY', 'NULL', '526');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('526', '112', '2391', NULL , '2009-04-08 12:04:28' , 'Initialisation de la valeur «AY» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2392', '1071', '1', 'Azéri', 'AZ', 'NULL', '527');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('527', '112', '2392', NULL , '2009-04-08 12:04:29' , 'Initialisation de la valeur «AZ» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2393', '1071', '1', 'Bachkir', 'BA', 'NULL', '528');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('528', '112', '2393', NULL , '2009-04-08 12:04:30' , 'Initialisation de la valeur «BA» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2394', '1071', '1', 'Biélorusse', 'BE', 'NULL', '529');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('529', '112', '2394', NULL , '2009-04-08 12:04:31' , 'Initialisation de la valeur «BE» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2395', '1071', '1', 'Bulgare', 'BG', 'NULL', '530');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('530', '112', '2395', NULL , '2009-04-08 12:04:32' , 'Initialisation de la valeur «BG» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2396', '1071', '1', 'Bihari', 'BH', 'NULL', '531');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('531', '112', '2396', NULL , '2009-04-08 12:04:33' , 'Initialisation de la valeur «BH» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2397', '1071', '1', 'Bichelamar', 'BI', 'NULL', '532');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('532', '112', '2397', NULL , '2009-04-08 12:04:34' , 'Initialisation de la valeur «BI» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2398', '1071', '1', 'Bambara', 'BM', 'NULL', '533');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('533', '112', '2398', NULL , '2009-04-08 12:04:35' , 'Initialisation de la valeur «BM» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2399', '1071', '1', 'Bengalî', 'BN', 'NULL', '534');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('534', '112', '2399', NULL , '2009-04-08 12:04:36' , 'Initialisation de la valeur «BN» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2400', '1071', '1', 'Tibétain', 'BO', 'NULL', '535');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('535', '112', '2400', NULL , '2009-04-08 12:04:37' , 'Initialisation de la valeur «BO» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2401', '1071', '1', 'Breton', 'BR', 'NULL', '536');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('536', '112', '2401', NULL , '2009-04-08 12:04:38' , 'Initialisation de la valeur «BR» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2402', '1071', '1', 'Bosnien', 'BS', 'NULL', '537');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('537', '112', '2402', NULL , '2009-04-08 12:04:39' , 'Initialisation de la valeur «BS» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2403', '1071', '1', 'Catalan', 'CA', 'NULL', '538');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('538', '112', '2403', NULL , '2009-04-08 12:04:40' , 'Initialisation de la valeur «CA» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2404', '1071', '1', 'Tchétchène', 'CE', 'NULL', '539');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('539', '112', '2404', NULL , '2009-04-08 12:04:41' , 'Initialisation de la valeur «CE» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2405', '1071', '1', 'Chamorro', 'CH', 'NULL', '540');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('540', '112', '2405', NULL , '2009-04-08 12:04:42' , 'Initialisation de la valeur «CH» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2406', '1071', '1', 'Corse', 'CO', 'NULL', '541');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('541', '112', '2406', NULL , '2009-04-08 12:04:43' , 'Initialisation de la valeur «CO» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2407', '1071', '1', 'Cri', 'CR', 'NULL', '542');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('542', '112', '2407', NULL , '2009-04-08 12:04:44' , 'Initialisation de la valeur «CR» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2408', '1071', '1', 'Tchèque', 'CS', 'NULL', '543');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('543', '112', '2408', NULL , '2009-04-08 12:04:45' , 'Initialisation de la valeur «CS» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2409', '1071', '1', 'Vieux slave', 'CU', 'NULL', '544');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('544', '112', '2409', NULL , '2009-04-08 12:04:46' , 'Initialisation de la valeur «CU» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2410', '1071', '1', 'Tchouvache', 'CV', 'NULL', '545');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('545', '112', '2410', NULL , '2009-04-08 12:04:47' , 'Initialisation de la valeur «CV» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2411', '1071', '1', 'Gallois', 'CY', 'NULL', '546');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('546', '112', '2411', NULL , '2009-04-08 12:04:48' , 'Initialisation de la valeur «CY» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2412', '1071', '1', 'Danois', 'DA', 'NULL', '547');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('547', '112', '2412', NULL , '2009-04-08 12:04:49' , 'Initialisation de la valeur «DA» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2413', '1071', '1', 'Allemand', 'DE', 'NULL', '548');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('548', '112', '2413', NULL , '2009-04-08 12:04:50' , 'Initialisation de la valeur «DE» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2414', '1071', '1', 'Divehi', 'DV', 'NULL', '549');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('549', '112', '2414', NULL , '2009-04-08 12:04:51' , 'Initialisation de la valeur «DV» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2415', '1071', '1', 'Dzongkha', 'DZ', 'NULL', '550');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('550', '112', '2415', NULL , '2009-04-08 12:04:52' , 'Initialisation de la valeur «DZ» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2416', '1071', '1', 'Ewe', 'EE', 'NULL', '551');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('551', '112', '2416', NULL , '2009-04-08 12:04:53' , 'Initialisation de la valeur «EE» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2417', '1071', '1', 'Grec moderne', 'EL', 'NULL', '552');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('552', '112', '2417', NULL , '2009-04-08 12:04:54' , 'Initialisation de la valeur «EL» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2418', '1071', '1', 'Anglais', 'EN', 'NULL', '553');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('553', '112', '2418', NULL , '2009-04-08 12:04:55' , 'Initialisation de la valeur «EN» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2419', '1071', '1', 'Espéranto', 'EO', 'NULL', '554');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('554', '112', '2419', NULL , '2009-04-08 12:04:56' , 'Initialisation de la valeur «EO» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2420', '1071', '1', 'Espagnol', 'ES', 'NULL', '555');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('555', '112', '2420', NULL , '2009-04-08 12:04:57' , 'Initialisation de la valeur «ES» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2421', '1071', '1', 'Estonien', 'ET', 'NULL', '556');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('556', '112', '2421', NULL , '2009-04-08 12:04:58' , 'Initialisation de la valeur «ET» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2422', '1071', '1', 'Basque', 'EU', 'NULL', '557');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('557', '112', '2422', NULL , '2009-04-08 12:04:59' , 'Initialisation de la valeur «EU» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2423', '1071', '1', 'Perse', 'FA', 'NULL', '558');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('558', '112', '2423', NULL , '2009-04-08 12:05:00' , 'Initialisation de la valeur «FA» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2424', '1071', '1', 'Peul', 'FF', 'NULL', '559');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('559', '112', '2424', NULL , '2009-04-08 12:05:01' , 'Initialisation de la valeur «FF» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2425', '1071', '1', 'Finnois', 'FI', 'NULL', '560');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('560', '112', '2425', NULL , '2009-04-08 12:05:02' , 'Initialisation de la valeur «FI» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2426', '1071', '1', 'Fidjien', 'FJ', 'NULL', '561');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('561', '112', '2426', NULL , '2009-04-08 12:05:03' , 'Initialisation de la valeur «FJ» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2427', '1071', '1', 'Féringien', 'FO', 'NULL', '562');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('562', '112', '2427', NULL , '2009-04-08 12:05:04' , 'Initialisation de la valeur «FO» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2428', '1071', '1', 'Français', 'FR', 'NULL', '563');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('563', '112', '2428', NULL , '2009-04-08 12:05:05' , 'Initialisation de la valeur «FR» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2429', '1071', '1', 'Frison', 'FY', 'NULL', '564');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('564', '112', '2429', NULL , '2009-04-08 12:05:06' , 'Initialisation de la valeur «FY» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2430', '1071', '1', 'Irlandais', 'GA', 'NULL', '565');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('565', '112', '2430', NULL , '2009-04-08 12:05:07' , 'Initialisation de la valeur «GA» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2431', '1071', '1', 'Écossais', 'GD', 'NULL', '566');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('566', '112', '2431', NULL , '2009-04-08 12:05:08' , 'Initialisation de la valeur «GD» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2432', '1071', '1', 'Galicien', 'GL', 'NULL', '567');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('567', '112', '2432', NULL , '2009-04-08 12:05:09' , 'Initialisation de la valeur «GL» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2433', '1071', '1', 'Guarani', 'GN', 'NULL', '568');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('568', '112', '2433', NULL , '2009-04-08 12:05:10' , 'Initialisation de la valeur «GN» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2434', '1071', '1', 'Gujarâtî', 'GU', 'NULL', '569');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('569', '112', '2434', NULL , '2009-04-08 12:05:11' , 'Initialisation de la valeur «GU» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2435', '1071', '1', 'Mannois', 'GV', 'NULL', '570');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('570', '112', '2435', NULL , '2009-04-08 12:05:12' , 'Initialisation de la valeur «GV» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2436', '1071', '1', 'Haoussa', 'HA', 'NULL', '571');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('571', '112', '2436', NULL , '2009-04-08 12:05:13' , 'Initialisation de la valeur «HA» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2437', '1071', '1', 'Hébreu', 'HE', 'NULL', '572');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('572', '112', '2437', NULL , '2009-04-08 12:05:14' , 'Initialisation de la valeur «HE» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2438', '1071', '1', 'Hindî', 'HI', 'NULL', '573');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('573', '112', '2438', NULL , '2009-04-08 12:05:15' , 'Initialisation de la valeur «HI» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2439', '1071', '1', 'Hiri motu', 'HO', 'NULL', '574');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('574', '112', '2439', NULL , '2009-04-08 12:05:16' , 'Initialisation de la valeur «HO» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2440', '1071', '1', 'Croate', 'HR', 'NULL', '575');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('575', '112', '2440', NULL , '2009-04-08 12:05:17' , 'Initialisation de la valeur «HR» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2441', '1071', '1', 'Créole haïtien', 'HT', 'NULL', '576');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('576', '112', '2441', NULL , '2009-04-08 12:05:18' , 'Initialisation de la valeur «HT» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2442', '1071', '1', 'Hongrois', 'HU', 'NULL', '577');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('577', '112', '2442', NULL , '2009-04-08 12:05:19' , 'Initialisation de la valeur «HU» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2443', '1071', '1', 'Arménien', 'HY', 'NULL', '578');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('578', '112', '2443', NULL , '2009-04-08 12:05:20' , 'Initialisation de la valeur «HY» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2444', '1071', '1', 'Herero', 'HZ', 'NULL', '579');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('579', '112', '2444', NULL , '2009-04-08 12:05:21' , 'Initialisation de la valeur «HZ» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2445', '1071', '1', 'Interlingua', 'IA', 'NULL', '580');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('580', '112', '2445', NULL , '2009-04-08 12:05:22' , 'Initialisation de la valeur «IA» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2446', '1071', '1', 'Indonésien', 'ID', 'NULL', '581');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('581', '112', '2446', NULL , '2009-04-08 12:05:23' , 'Initialisation de la valeur «ID» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2447', '1071', '1', 'Occidental', 'IE', 'NULL', '582');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('582', '112', '2447', NULL , '2009-04-08 12:05:24' , 'Initialisation de la valeur «IE» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2448', '1071', '1', 'Igbo', 'IG', 'NULL', '583');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('583', '112', '2448', NULL , '2009-04-08 12:05:25' , 'Initialisation de la valeur «IG» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2449', '1071', '1', 'Yi', 'II', 'NULL', '584');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('584', '112', '2449', NULL , '2009-04-08 12:05:26' , 'Initialisation de la valeur «II» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2450', '1071', '1', 'Inupiaq', 'IK', 'NULL', '585');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('585', '112', '2450', NULL , '2009-04-08 12:05:27' , 'Initialisation de la valeur «IK» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2451', '1071', '1', 'Ido', 'IO', 'NULL', '586');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('586', '112', '2451', NULL , '2009-04-08 12:05:28' , 'Initialisation de la valeur «IO» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2452', '1071', '1', 'Islandais', 'IS', 'NULL', '587');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('587', '112', '2452', NULL , '2009-04-08 12:05:29' , 'Initialisation de la valeur «IS» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2453', '1071', '1', 'Italien', 'IT', 'NULL', '588');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('588', '112', '2453', NULL , '2009-04-08 12:05:30' , 'Initialisation de la valeur «IT» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2454', '1071', '1', 'Inuktitut', 'IU', 'NULL', '589');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('589', '112', '2454', NULL , '2009-04-08 12:05:31' , 'Initialisation de la valeur «IU» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2455', '1071', '1', 'Japonais', 'JA', 'NULL', '590');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('590', '112', '2455', NULL , '2009-04-08 12:05:32' , 'Initialisation de la valeur «JA» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2456', '1071', '1', 'Javanais', 'JV', 'NULL', '591');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('591', '112', '2456', NULL , '2009-04-08 12:05:33' , 'Initialisation de la valeur «JV» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2457', '1071', '1', 'Géorgien', 'KA', 'NULL', '592');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('592', '112', '2457', NULL , '2009-04-08 12:05:34' , 'Initialisation de la valeur «KA» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2458', '1071', '1', 'Kikongo', 'KG', 'NULL', '593');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('593', '112', '2458', NULL , '2009-04-08 12:05:35' , 'Initialisation de la valeur «KG» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2459', '1071', '1', 'Kikuyu', 'KI', 'NULL', '594');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('594', '112', '2459', NULL , '2009-04-08 12:05:36' , 'Initialisation de la valeur «KI» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2460', '1071', '1', 'Kuanyama', 'KJ', 'NULL', '595');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('595', '112', '2460', NULL , '2009-04-08 12:05:37' , 'Initialisation de la valeur «KJ» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2461', '1071', '1', 'Kazakh', 'KK', 'NULL', '596');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('596', '112', '2461', NULL , '2009-04-08 12:05:38' , 'Initialisation de la valeur «KK» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2462', '1071', '1', 'Kalaallisut', 'KL', 'NULL', '597');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('597', '112', '2462', NULL , '2009-04-08 12:05:39' , 'Initialisation de la valeur «KL» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2463', '1071', '1', 'Khmer', 'KM', 'NULL', '598');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('598', '112', '2463', NULL , '2009-04-08 12:05:40' , 'Initialisation de la valeur «KM» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2464', '1071', '1', 'Kannara', 'KN', 'NULL', '599');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('599', '112', '2464', NULL , '2009-04-08 12:05:41' , 'Initialisation de la valeur «KN» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2465', '1071', '1', 'Coréen', 'KO', 'NULL', '600');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('600', '112', '2465', NULL , '2009-04-08 12:05:42' , 'Initialisation de la valeur «KO» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2466', '1071', '1', 'Kanouri', 'KR', 'NULL', '601');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('601', '112', '2466', NULL , '2009-04-08 12:05:43' , 'Initialisation de la valeur «KR» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2467', '1071', '1', 'Kashmiri', 'KS', 'NULL', '602');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('602', '112', '2467', NULL , '2009-04-08 12:05:44' , 'Initialisation de la valeur «KS» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2468', '1071', '1', 'Kurde', 'KU', 'NULL', '603');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('603', '112', '2468', NULL , '2009-04-08 12:05:45' , 'Initialisation de la valeur «KU» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2469', '1071', '1', 'Komi', 'KV', 'NULL', '604');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('604', '112', '2469', NULL , '2009-04-08 12:05:46' , 'Initialisation de la valeur «KV» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2470', '1071', '1', 'Cornique', 'KW', 'NULL', '605');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('605', '112', '2470', NULL , '2009-04-08 12:05:47' , 'Initialisation de la valeur «KW» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2471', '1071', '1', 'Kirghiz', 'KY', 'NULL', '606');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('606', '112', '2471', NULL , '2009-04-08 12:05:48' , 'Initialisation de la valeur «KY» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2472', '1071', '1', 'Latin', 'LA', 'NULL', '607');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('607', '112', '2472', NULL , '2009-04-08 12:05:49' , 'Initialisation de la valeur «LA» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2473', '1071', '1', 'Luxembourgeois', 'LB', 'NULL', '608');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('608', '112', '2473', NULL , '2009-04-08 12:05:50' , 'Initialisation de la valeur «LB» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2474', '1071', '1', 'Ganda', 'LG', 'NULL', '609');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('609', '112', '2474', NULL , '2009-04-08 12:05:51' , 'Initialisation de la valeur «LG» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2475', '1071', '1', 'Limbourgeois', 'LI', 'NULL', '610');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('610', '112', '2475', NULL , '2009-04-08 12:05:52' , 'Initialisation de la valeur «LI» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2476', '1071', '1', 'Lingala', 'LN', 'NULL', '611');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('611', '112', '2476', NULL , '2009-04-08 12:05:53' , 'Initialisation de la valeur «LN» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2477', '1071', '1', 'Lao', 'LO', 'NULL', '612');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('612', '112', '2477', NULL , '2009-04-08 12:05:54' , 'Initialisation de la valeur «LO» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2478', '1071', '1', 'Lituanien', 'LT', 'NULL', '613');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('613', '112', '2478', NULL , '2009-04-08 12:05:55' , 'Initialisation de la valeur «LT» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2479', '1071', '1', 'Tchiluba', 'LU', 'NULL', '614');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('614', '112', '2479', NULL , '2009-04-08 12:05:56' , 'Initialisation de la valeur «LU» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2480', '1071', '1', 'Letton', 'LV', 'NULL', '615');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('615', '112', '2480', NULL , '2009-04-08 12:05:57' , 'Initialisation de la valeur «LV» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2481', '1071', '1', 'Malgache', 'MG', 'NULL', '616');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('616', '112', '2481', NULL , '2009-04-08 12:05:58' , 'Initialisation de la valeur «MG» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2482', '1071', '1', 'Marshallais', 'MH', 'NULL', '617');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('617', '112', '2482', NULL , '2009-04-08 12:05:59' , 'Initialisation de la valeur «MH» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2483', '1071', '1', 'Māori de Nouvelle-Zélande', 'MI', 'NULL', '618');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('618', '112', '2483', NULL , '2009-04-08 12:06:00' , 'Initialisation de la valeur «MI» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2484', '1071', '1', 'Macédonien', 'MK', 'NULL', '619');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('619', '112', '2484', NULL , '2009-04-08 12:06:01' , 'Initialisation de la valeur «MK» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2485', '1071', '1', 'Malayalam', 'ML', 'NULL', '620');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('620', '112', '2485', NULL , '2009-04-08 12:06:02' , 'Initialisation de la valeur «ML» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2486', '1071', '1', 'Mongol', 'MN', 'NULL', '621');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('621', '112', '2486', NULL , '2009-04-08 12:06:03' , 'Initialisation de la valeur «MN» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2487', '1071', '1', 'Moldave', 'MO', 'NULL', '622');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('622', '112', '2487', NULL , '2009-04-08 12:06:04' , 'Initialisation de la valeur «MO» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2488', '1071', '1', 'Marâthî', 'MR', 'NULL', '623');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('623', '112', '2488', NULL , '2009-04-08 12:06:05' , 'Initialisation de la valeur «MR» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2489', '1071', '1', 'Malais', 'MS', 'NULL', '624');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('624', '112', '2489', NULL , '2009-04-08 12:06:06' , 'Initialisation de la valeur «MS» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2490', '1071', '1', 'Maltais', 'MT', 'NULL', '625');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('625', '112', '2490', NULL , '2009-04-08 12:06:07' , 'Initialisation de la valeur «MT» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2491', '1071', '1', 'Birman', 'MY', 'NULL', '626');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('626', '112', '2491', NULL , '2009-04-08 12:06:08' , 'Initialisation de la valeur «MY» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2492', '1071', '1', 'Nauruan', 'NA', 'NULL', '627');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('627', '112', '2492', NULL , '2009-04-08 12:06:09' , 'Initialisation de la valeur «NA» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2493', '1071', '1', 'Norvégien Bokmål', 'NB', 'NULL', '628');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('628', '112', '2493', NULL , '2009-04-08 12:06:10' , 'Initialisation de la valeur «NB» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2494', '1071', '1', 'Ndébélé du Nord', 'ND', 'NULL', '629');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('629', '112', '2494', NULL , '2009-04-08 12:06:11' , 'Initialisation de la valeur «ND» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2495', '1071', '1', 'Népalais', 'NE', 'NULL', '630');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('630', '112', '2495', NULL , '2009-04-08 12:06:12' , 'Initialisation de la valeur «NE» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2496', '1071', '1', 'Ndonga', 'NG', 'NULL', '631');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('631', '112', '2496', NULL , '2009-04-08 12:06:13' , 'Initialisation de la valeur «NG» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2497', '1071', '1', 'Néerlandais', 'NL', 'NULL', '632');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('632', '112', '2497', NULL , '2009-04-08 12:06:14' , 'Initialisation de la valeur «NL» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2498', '1071', '1', 'Norvégien Nynorsk', 'NN', 'NULL', '633');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('633', '112', '2498', NULL , '2009-04-08 12:06:15' , 'Initialisation de la valeur «NN» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2499', '1071', '1', 'Norvégien', 'NO', 'NULL', '634');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('634', '112', '2499', NULL , '2009-04-08 12:06:16' , 'Initialisation de la valeur «NO» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2500', '1071', '1', 'Ndébélé du Sud', 'NR', 'NULL', '635');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('635', '112', '2500', NULL , '2009-04-08 12:06:17' , 'Initialisation de la valeur «NR» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2501', '1071', '1', 'Navajo', 'NV', 'NULL', '636');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('636', '112', '2501', NULL , '2009-04-08 12:06:18' , 'Initialisation de la valeur «NV» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2502', '1071', '1', 'Chichewa', 'NY', 'NULL', '637');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('637', '112', '2502', NULL , '2009-04-08 12:06:19' , 'Initialisation de la valeur «NY» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2503', '1071', '1', 'Occitan', 'OC', 'NULL', '638');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('638', '112', '2503', NULL , '2009-04-08 12:06:20' , 'Initialisation de la valeur «OC» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2504', '1071', '1', 'Ojibwé', 'OJ', 'NULL', '639');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('639', '112', '2504', NULL , '2009-04-08 12:06:21' , 'Initialisation de la valeur «OJ» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2505', '1071', '1', 'Oromo', 'OM', 'NULL', '640');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('640', '112', '2505', NULL , '2009-04-08 12:06:22' , 'Initialisation de la valeur «OM» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2506', '1071', '1', 'Oriya', 'OR', 'NULL', '641');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('641', '112', '2506', NULL , '2009-04-08 12:06:23' , 'Initialisation de la valeur «OR» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2507', '1071', '1', 'Ossète', 'OS', 'NULL', '642');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('642', '112', '2507', NULL , '2009-04-08 12:06:24' , 'Initialisation de la valeur «OS» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2508', '1071', '1', 'Panjâbî', 'PA', 'NULL', '643');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('643', '112', '2508', NULL , '2009-04-08 12:06:25' , 'Initialisation de la valeur «PA» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2509', '1071', '1', 'Pâli', 'PI', 'NULL', '644');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('644', '112', '2509', NULL , '2009-04-08 12:06:26' , 'Initialisation de la valeur «PI» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2510', '1071', '1', 'Polonais', 'PL', 'NULL', '645');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('645', '112', '2510', NULL , '2009-04-08 12:06:27' , 'Initialisation de la valeur «PL» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2511', '1071', '1', 'Pachto', 'PS', 'NULL', '646');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('646', '112', '2511', NULL , '2009-04-08 12:06:28' , 'Initialisation de la valeur «PS» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2512', '1071', '1', 'Portugais', 'PT', 'NULL', '647');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('647', '112', '2512', NULL , '2009-04-08 12:06:29' , 'Initialisation de la valeur «PT» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2513', '1071', '1', 'Quechua', 'QU', 'NULL', '648');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('648', '112', '2513', NULL , '2009-04-08 12:06:30' , 'Initialisation de la valeur «QU» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2514', '1071', '1', 'Romanche', 'RM', 'NULL', '649');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('649', '112', '2514', NULL , '2009-04-08 12:06:31' , 'Initialisation de la valeur «RM» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2515', '1071', '1', 'Kirundi', 'RN', 'NULL', '650');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('650', '112', '2515', NULL , '2009-04-08 12:06:32' , 'Initialisation de la valeur «RN» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2516', '1071', '1', 'Roumain', 'RO', 'NULL', '651');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('651', '112', '2516', NULL , '2009-04-08 12:06:33' , 'Initialisation de la valeur «RO» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2517', '1071', '1', 'Russe', 'RU', 'NULL', '652');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('652', '112', '2517', NULL , '2009-04-08 12:06:34' , 'Initialisation de la valeur «RU» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2518', '1071', '1', 'Kinyarwanda', 'RW', 'NULL', '653');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('653', '112', '2518', NULL , '2009-04-08 12:06:35' , 'Initialisation de la valeur «RW» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2519', '1071', '1', 'Sanskrit', 'SA', 'NULL', '654');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('654', '112', '2519', NULL , '2009-04-08 12:06:36' , 'Initialisation de la valeur «SA» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2520', '1071', '1', 'Sarde', 'SC', 'NULL', '655');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('655', '112', '2520', NULL , '2009-04-08 12:06:37' , 'Initialisation de la valeur «SC» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2521', '1071', '1', 'Sindhi', 'SD', 'NULL', '656');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('656', '112', '2521', NULL , '2009-04-08 12:06:38' , 'Initialisation de la valeur «SD» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2522', '1071', '1', 'Same du Nord', 'SE', 'NULL', '657');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('657', '112', '2522', NULL , '2009-04-08 12:06:39' , 'Initialisation de la valeur «SE» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2523', '1071', '1', 'Sango', 'SG', 'NULL', '658');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('658', '112', '2523', NULL , '2009-04-08 12:06:40' , 'Initialisation de la valeur «SG» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2524', '1071', '1', 'Serbo-croate', 'SH', 'NULL', '659');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('659', '112', '2524', NULL , '2009-04-08 12:06:41' , 'Initialisation de la valeur «SH» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2525', '1071', '1', 'Cingalais', 'SI', 'NULL', '660');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('660', '112', '2525', NULL , '2009-04-08 12:06:42' , 'Initialisation de la valeur «SI» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2526', '1071', '1', 'Slovaque', 'SK', 'NULL', '661');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('661', '112', '2526', NULL , '2009-04-08 12:06:43' , 'Initialisation de la valeur «SK» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2527', '1071', '1', 'Slovène', 'SL', 'NULL', '662');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('662', '112', '2527', NULL , '2009-04-08 12:06:44' , 'Initialisation de la valeur «SL» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2528', '1071', '1', 'Samoan', 'SM', 'NULL', '663');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('663', '112', '2528', NULL , '2009-04-08 12:06:45' , 'Initialisation de la valeur «SM» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2529', '1071', '1', 'Shona', 'SN', 'NULL', '664');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('664', '112', '2529', NULL , '2009-04-08 12:06:46' , 'Initialisation de la valeur «SN» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2530', '1071', '1', 'Somali', 'SO', 'NULL', '665');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('665', '112', '2530', NULL , '2009-04-08 12:06:47' , 'Initialisation de la valeur «SO» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2531', '1071', '1', 'Albanais', 'SQ', 'NULL', '666');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('666', '112', '2531', NULL , '2009-04-08 12:06:48' , 'Initialisation de la valeur «SQ» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2532', '1071', '1', 'Serbe', 'SR', 'NULL', '667');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('667', '112', '2532', NULL , '2009-04-08 12:06:49' , 'Initialisation de la valeur «SR» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2533', '1071', '1', 'Siswati', 'SS', 'NULL', '668');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('668', '112', '2533', NULL , '2009-04-08 12:06:50' , 'Initialisation de la valeur «SS» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2534', '1071', '1', 'Sotho du Sud', 'ST', 'NULL', '669');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('669', '112', '2534', NULL , '2009-04-08 12:06:51' , 'Initialisation de la valeur «ST» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2535', '1071', '1', 'Sundanais', 'SU', 'NULL', '670');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('670', '112', '2535', NULL , '2009-04-08 12:06:52' , 'Initialisation de la valeur «SU» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2536', '1071', '1', 'Suédois', 'SV', 'NULL', '671');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('671', '112', '2536', NULL , '2009-04-08 12:06:53' , 'Initialisation de la valeur «SV» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2537', '1071', '1', 'Swahili', 'SW', 'NULL', '672');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('672', '112', '2537', NULL , '2009-04-08 12:06:54' , 'Initialisation de la valeur «SW» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2538', '1071', '1', 'Tamoul', 'TA', 'NULL', '673');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('673', '112', '2538', NULL , '2009-04-08 12:06:55' , 'Initialisation de la valeur «TA» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2539', '1071', '1', 'Télougou', 'TE', 'NULL', '674');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('674', '112', '2539', NULL , '2009-04-08 12:06:56' , 'Initialisation de la valeur «TE» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2540', '1071', '1', 'Tadjik', 'TG', 'NULL', '675');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('675', '112', '2540', NULL , '2009-04-08 12:06:57' , 'Initialisation de la valeur «TG» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2541', '1071', '1', 'Thaï', 'TH', 'NULL', '676');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('676', '112', '2541', NULL , '2009-04-08 12:06:58' , 'Initialisation de la valeur «TH» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2542', '1071', '1', 'Tigrinya', 'TI', 'NULL', '677');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('677', '112', '2542', NULL , '2009-04-08 12:06:59' , 'Initialisation de la valeur «TI» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2543', '1071', '1', 'Turkmène', 'TK', 'NULL', '678');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('678', '112', '2543', NULL , '2009-04-08 12:07:00' , 'Initialisation de la valeur «TK» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2544', '1071', '1', 'Tagalog', 'TL', 'NULL', '679');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('679', '112', '2544', NULL , '2009-04-08 12:07:01' , 'Initialisation de la valeur «TL» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2545', '1071', '1', 'Tswana', 'TN', 'NULL', '680');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('680', '112', '2545', NULL , '2009-04-08 12:07:02' , 'Initialisation de la valeur «TN» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2546', '1071', '1', 'Tongien', 'TO', 'NULL', '681');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('681', '112', '2546', NULL , '2009-04-08 12:07:03' , 'Initialisation de la valeur «TO» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2547', '1071', '1', 'Turc', 'TR', 'NULL', '682');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('682', '112', '2547', NULL , '2009-04-08 12:07:04' , 'Initialisation de la valeur «TR» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2548', '1071', '1', 'Tsonga', 'TS', 'NULL', '683');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('683', '112', '2548', NULL , '2009-04-08 12:07:05' , 'Initialisation de la valeur «TS» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2549', '1071', '1', 'Tatar', 'TT', 'NULL', '684');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('684', '112', '2549', NULL , '2009-04-08 12:07:06' , 'Initialisation de la valeur «TT» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2550', '1071', '1', 'Twi', 'TW', 'NULL', '685');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('685', '112', '2550', NULL , '2009-04-08 12:07:07' , 'Initialisation de la valeur «TW» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2551', '1071', '1', 'Tahitien', 'TY', 'NULL', '686');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('686', '112', '2551', NULL , '2009-04-08 12:07:08' , 'Initialisation de la valeur «TY» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2552', '1071', '1', 'Ouïghour', 'UG', 'NULL', '687');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('687', '112', '2552', NULL , '2009-04-08 12:07:09' , 'Initialisation de la valeur «UG» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2553', '1071', '1', 'Ukrainien', 'UK', 'NULL', '688');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('688', '112', '2553', NULL , '2009-04-08 12:07:10' , 'Initialisation de la valeur «UK» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2554', '1071', '1', 'Ourdou', 'UR', 'NULL', '689');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('689', '112', '2554', NULL , '2009-04-08 12:07:11' , 'Initialisation de la valeur «UR» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2555', '1071', '1', 'Ouzbek', 'UZ', 'NULL', '690');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('690', '112', '2555', NULL , '2009-04-08 12:07:12' , 'Initialisation de la valeur «UZ» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2556', '1071', '1', 'Venda', 'VE', 'NULL', '691');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('691', '112', '2556', NULL , '2009-04-08 12:07:13' , 'Initialisation de la valeur «VE» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2557', '1071', '1', 'Vietnamien', 'VI', 'NULL', '692');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('692', '112', '2557', NULL , '2009-04-08 12:07:14' , 'Initialisation de la valeur «VI» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2558', '1071', '1', 'Volapük', 'VO', 'NULL', '693');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('693', '112', '2558', NULL , '2009-04-08 12:07:15' , 'Initialisation de la valeur «VO» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2559', '1071', '1', 'Wallon', 'WA', 'NULL', '694');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('694', '112', '2559', NULL , '2009-04-08 12:07:16' , 'Initialisation de la valeur «WA» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2560', '1071', '1', 'Wolof', 'WO', 'NULL', '695');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('695', '112', '2560', NULL , '2009-04-08 12:07:17' , 'Initialisation de la valeur «WO» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2561', '1071', '1', 'Xhosa', 'XH', 'NULL', '696');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('696', '112', '2561', NULL , '2009-04-08 12:07:18' , 'Initialisation de la valeur «XH» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2562', '1071', '1', 'Yiddish', 'YI', 'NULL', '697');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('697', '112', '2562', NULL , '2009-04-08 12:07:19' , 'Initialisation de la valeur «YI» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2563', '1071', '1', 'Yoruba', 'YO', 'NULL', '698');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('698', '112', '2563', NULL , '2009-04-08 12:07:20' , 'Initialisation de la valeur «YO» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2564', '1071', '1', 'Zhuang', 'ZA', 'NULL', '699');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('699', '112', '2564', NULL , '2009-04-08 12:07:21' , 'Initialisation de la valeur «ZA» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2565', '1071', '1', 'Chinois', 'ZH', 'NULL', '700');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('700', '112', '2565', NULL , '2009-04-08 12:07:22' , 'Initialisation de la valeur «ZH» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2566', '1071', '1', 'Zoulou', 'ZU', 'NULL', '701');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('701', '112', '2566', NULL , '2009-04-08 12:07:23' , 'Initialisation de la valeur «ZU» pour la liste «68».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2567', '1072', '1', '1 heure', '1h', 'NULL', '702');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('702', '112', '2567', NULL , '2009-04-08 12:07:24' , 'Initialisation de la valeur «1h» pour la liste «69».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2568', '1072', '1', '2 heures', '2h', 'NULL', '703');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('703', '112', '2568', NULL , '2009-04-08 12:07:25' , 'Initialisation de la valeur «2h» pour la liste «69».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2569', '1072', '1', '5 heures', '5h', 'NULL', '704');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('704', '112', '2569', NULL , '2009-04-08 12:07:26' , 'Initialisation de la valeur «5h» pour la liste «69».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2570', '1072', '1', '10 heures', '10h', 'NULL', '705');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('705', '112', '2570', NULL , '2009-04-08 12:07:27' , 'Initialisation de la valeur «10h» pour la liste «69».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2571', '1073', '1', 'Journalier', 'J', 'NULL', '706');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('706', '112', '2571', NULL , '2009-04-08 12:07:28' , 'Initialisation de la valeur «J» pour la liste «70».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2572', '1073', '1', 'Hebdomadaire', 'H', 'NULL', '707');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('707', '112', '2572', NULL , '2009-04-08 12:07:29' , 'Initialisation de la valeur «H» pour la liste «70».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2573', '1073', '1', 'Mensuel', 'M', 'NULL', '708');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('708', '112', '2573', NULL , '2009-04-08 12:07:30' , 'Initialisation de la valeur «M» pour la liste «70».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2574', '1073', '1', 'Bi-mensuel', 'B', 'NULL', '709');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('709', '112', '2574', NULL , '2009-04-08 12:07:31' , 'Initialisation de la valeur «B» pour la liste «70».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2575', '1073', '1', 'Trimestriel', 'T', 'NULL', '710');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('710', '112', '2575', NULL , '2009-04-08 12:07:32' , 'Initialisation de la valeur «T» pour la liste «70».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2576', '1073', '1', 'Semestriel', 'S', 'NULL', '711');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('711', '112', '2576', NULL , '2009-04-08 12:07:33' , 'Initialisation de la valeur «S» pour la liste «70».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2577', '1074', '1', 'Afghanistan', 'AF', 'NULL', '712');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('712', '112', '2577', NULL , '2009-04-08 12:07:34' , 'Initialisation de la valeur «AF» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2578', '1074', '1', 'Afrique du Sud', 'ZA', 'NULL', '713');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('713', '112', '2578', NULL , '2009-04-08 12:07:35' , 'Initialisation de la valeur «ZA» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2579', '1074', '1', 'Åland', 'AX', 'NULL', '714');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('714', '112', '2579', NULL , '2009-04-08 12:07:36' , 'Initialisation de la valeur «AX» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2580', '1074', '1', 'Albanie', 'AL', 'NULL', '715');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('715', '112', '2580', NULL , '2009-04-08 12:07:37' , 'Initialisation de la valeur «AL» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2581', '1074', '1', 'Algérie', 'DZ', 'NULL', '716');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('716', '112', '2581', NULL , '2009-04-08 12:07:38' , 'Initialisation de la valeur «DZ» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2582', '1074', '1', 'Allemagne', 'DE', 'NULL', '717');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('717', '112', '2582', NULL , '2009-04-08 12:07:39' , 'Initialisation de la valeur «DE» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2583', '1074', '1', 'Andorre', 'AD', 'NULL', '718');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('718', '112', '2583', NULL , '2009-04-08 12:07:40' , 'Initialisation de la valeur «AD» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2584', '1074', '1', 'Angola', 'AO', 'NULL', '719');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('719', '112', '2584', NULL , '2009-04-08 12:07:41' , 'Initialisation de la valeur «AO» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2585', '1074', '1', 'Anguilla', 'AI', 'NULL', '720');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('720', '112', '2585', NULL , '2009-04-08 12:07:42' , 'Initialisation de la valeur «AI» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2586', '1074', '1', 'Antarctique', 'AQ', 'NULL', '721');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('721', '112', '2586', NULL , '2009-04-08 12:07:43' , 'Initialisation de la valeur «AQ» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2587', '1074', '1', 'Antigua-et-Barbuda', 'AG', 'NULL', '722');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('722', '112', '2587', NULL , '2009-04-08 12:07:44' , 'Initialisation de la valeur «AG» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2588', '1074', '1', 'Antilles néerlandaises', 'AN', 'NULL', '723');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('723', '112', '2588', NULL , '2009-04-08 12:07:45' , 'Initialisation de la valeur «AN» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2589', '1074', '1', 'Arabie saoudite', 'SA', 'NULL', '724');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('724', '112', '2589', NULL , '2009-04-08 12:07:46' , 'Initialisation de la valeur «SA» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2590', '1074', '1', 'Argentine', 'AR', 'NULL', '725');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('725', '112', '2590', NULL , '2009-04-08 12:07:47' , 'Initialisation de la valeur «AR» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2591', '1074', '1', 'Arménie', 'AM', 'NULL', '726');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('726', '112', '2591', NULL , '2009-04-08 12:07:48' , 'Initialisation de la valeur «AM» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2592', '1074', '1', 'Aruba', 'AW', 'NULL', '727');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('727', '112', '2592', NULL , '2009-04-08 12:07:49' , 'Initialisation de la valeur «AW» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2593', '1074', '1', 'Australie', 'AU', 'NULL', '728');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('728', '112', '2593', NULL , '2009-04-08 12:07:50' , 'Initialisation de la valeur «AU» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2594', '1074', '1', 'Autriche', 'AT', 'NULL', '729');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('729', '112', '2594', NULL , '2009-04-08 12:07:51' , 'Initialisation de la valeur «AT» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2595', '1074', '1', 'Azerbaïdjan', 'AZ', 'NULL', '730');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('730', '112', '2595', NULL , '2009-04-08 12:07:52' , 'Initialisation de la valeur «AZ» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2596', '1074', '1', 'Bahamas', 'BS', 'NULL', '731');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('731', '112', '2596', NULL , '2009-04-08 12:07:53' , 'Initialisation de la valeur «BS» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2597', '1074', '1', 'Bahreïn', 'BH', 'NULL', '732');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('732', '112', '2597', NULL , '2009-04-08 12:07:54' , 'Initialisation de la valeur «BH» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2598', '1074', '1', 'Bangladesh', 'BD', 'NULL', '733');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('733', '112', '2598', NULL , '2009-04-08 12:07:55' , 'Initialisation de la valeur «BD» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2599', '1074', '1', 'Barbade', 'BB', 'NULL', '734');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('734', '112', '2599', NULL , '2009-04-08 12:07:56' , 'Initialisation de la valeur «BB» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2600', '1074', '1', 'Biélorussie', 'BY', 'NULL', '735');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('735', '112', '2600', NULL , '2009-04-08 12:07:57' , 'Initialisation de la valeur «BY» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2601', '1074', '1', 'Belgique', 'BE', 'NULL', '736');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('736', '112', '2601', NULL , '2009-04-08 12:07:58' , 'Initialisation de la valeur «BE» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2602', '1074', '1', 'Belize', 'BZ', 'NULL', '737');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('737', '112', '2602', NULL , '2009-04-08 12:07:59' , 'Initialisation de la valeur «BZ» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2603', '1074', '1', 'Bénin', 'BJ', 'NULL', '738');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('738', '112', '2603', NULL , '2009-04-08 12:08:00' , 'Initialisation de la valeur «BJ» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2604', '1074', '1', 'Bermudes', 'BM', 'Territoire d''outre-mer autonome (Royaume-Uni)', '739');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('739', '112', '2604', NULL , '2009-04-08 12:08:01' , 'Initialisation de la valeur «BM» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2605', '1074', '1', 'Bhoutan', 'BT', 'NULL', '740');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('740', '112', '2605', NULL , '2009-04-08 12:08:02' , 'Initialisation de la valeur «BT» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2606', '1074', '1', 'Bolivie', 'BO', 'NULL', '741');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('741', '112', '2606', NULL , '2009-04-08 12:08:03' , 'Initialisation de la valeur «BO» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2607', '1074', '1', 'Bosnie-Herzégovine', 'BA', 'NULL', '742');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('742', '112', '2607', NULL , '2009-04-08 12:08:04' , 'Initialisation de la valeur «BA» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2608', '1074', '1', 'Botswana', 'BW', 'NULL', '743');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('743', '112', '2608', NULL , '2009-04-08 12:08:05' , 'Initialisation de la valeur «BW» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2609', '1074', '1', 'Île Bouvet', 'BV', 'NULL', '744');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('744', '112', '2609', NULL , '2009-04-08 12:08:06' , 'Initialisation de la valeur «BV» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2610', '1074', '1', 'Brésil', 'BR', 'NULL', '745');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('745', '112', '2610', NULL , '2009-04-08 12:08:07' , 'Initialisation de la valeur «BR» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2611', '1074', '1', 'Brunei', 'BN', 'NULL', '746');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('746', '112', '2611', NULL , '2009-04-08 12:08:08' , 'Initialisation de la valeur «BN» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2612', '1074', '1', 'Bulgarie', 'BG', 'NULL', '747');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('747', '112', '2612', NULL , '2009-04-08 12:08:09' , 'Initialisation de la valeur «BG» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2613', '1074', '1', 'Burkina Faso', 'BF', 'NULL', '748');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('748', '112', '2613', NULL , '2009-04-08 12:08:10' , 'Initialisation de la valeur «BF» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2614', '1074', '1', 'Burundi', 'BI', 'NULL', '749');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('749', '112', '2614', NULL , '2009-04-08 12:08:11' , 'Initialisation de la valeur «BI» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2615', '1074', '1', 'Îles Caïmans', 'KY', 'NULL', '750');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('750', '112', '2615', NULL , '2009-04-08 12:08:12' , 'Initialisation de la valeur «KY» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2616', '1074', '1', 'Cambodge', 'KH', 'NULL', '751');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('751', '112', '2616', NULL , '2009-04-08 12:08:13' , 'Initialisation de la valeur «KH» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2617', '1074', '1', 'Cameroun', 'CM', 'NULL', '752');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('752', '112', '2617', NULL , '2009-04-08 12:08:14' , 'Initialisation de la valeur «CM» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2618', '1074', '1', 'Canada', 'CA', 'NULL', '753');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('753', '112', '2618', NULL , '2009-04-08 12:08:15' , 'Initialisation de la valeur «CA» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2619', '1074', '1', 'Cap-Vert', 'CV', 'NULL', '754');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('754', '112', '2619', NULL , '2009-04-08 12:08:16' , 'Initialisation de la valeur «CV» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2620', '1074', '1', 'République centrafricaine', 'CF', 'NULL', '755');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('755', '112', '2620', NULL , '2009-04-08 12:08:17' , 'Initialisation de la valeur «CF» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2621', '1074', '1', 'Chili', 'CL', 'NULL', '756');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('756', '112', '2621', NULL , '2009-04-08 12:08:18' , 'Initialisation de la valeur «CL» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2622', '1074', '1', 'Chine', 'CN', 'République populaire de Chine', '757');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('757', '112', '2622', NULL , '2009-04-08 12:08:19' , 'Initialisation de la valeur «CN» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2623', '1074', '1', 'Île Christmas', 'CX', 'Australie', '758');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('758', '112', '2623', NULL , '2009-04-08 12:08:20' , 'Initialisation de la valeur «CX» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2624', '1074', '1', 'Chypre', 'CY', 'NULL', '759');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('759', '112', '2624', NULL , '2009-04-08 12:08:21' , 'Initialisation de la valeur «CY» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2625', '1074', '1', 'Îles Cocos', 'CC', 'NULL', '760');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('760', '112', '2625', NULL , '2009-04-08 12:08:22' , 'Initialisation de la valeur «CC» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2626', '1074', '1', 'Colombie', 'CO', 'NULL', '761');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('761', '112', '2626', NULL , '2009-04-08 12:08:23' , 'Initialisation de la valeur «CO» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2627', '1074', '1', 'Comores', 'KM', 'NULL', '762');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('762', '112', '2627', NULL , '2009-04-08 12:08:24' , 'Initialisation de la valeur «KM» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2628', '1074', '1', 'Congo-Brazzaville / (Congo)', 'CG', 'Congo', '763');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('763', '112', '2628', NULL , '2009-04-08 12:08:25' , 'Initialisation de la valeur «CG» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2629', '1074', '1', 'Congo-Kinshasa / (République démocratique du Congo)', 'CD', 'République démocratique du Congo', '764');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('764', '112', '2629', NULL , '2009-04-08 12:08:26' , 'Initialisation de la valeur «CD» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2630', '1074', '1', 'Îles Cook', 'CK', 'NULL', '765');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('765', '112', '2630', NULL , '2009-04-08 12:08:27' , 'Initialisation de la valeur «CK» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2631', '1074', '1', 'Corée du Sud', 'KR', 'NULL', '766');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('766', '112', '2631', NULL , '2009-04-08 12:08:28' , 'Initialisation de la valeur «KR» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2632', '1074', '1', 'Corée du Nord', 'KP', 'NULL', '767');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('767', '112', '2632', NULL , '2009-04-08 12:08:29' , 'Initialisation de la valeur «KP» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2633', '1074', '1', 'Costa Rica', 'CR', 'NULL', '768');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('768', '112', '2633', NULL , '2009-04-08 12:08:30' , 'Initialisation de la valeur «CR» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2634', '1074', '1', 'Côte d''Ivoire', 'CI', 'NULL', '769');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('769', '112', '2634', NULL , '2009-04-08 12:08:31' , 'Initialisation de la valeur «CI» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2635', '1074', '1', 'Croatie', 'HR', 'NULL', '770');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('770', '112', '2635', NULL , '2009-04-08 12:08:32' , 'Initialisation de la valeur «HR» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2636', '1074', '1', 'Cuba', 'CU', 'NULL', '771');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('771', '112', '2636', NULL , '2009-04-08 12:08:33' , 'Initialisation de la valeur «CU» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2637', '1074', '1', 'Danemark', 'DK', 'NULL', '772');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('772', '112', '2637', NULL , '2009-04-08 12:08:34' , 'Initialisation de la valeur «DK» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2638', '1074', '1', 'Djibouti', 'DJ', 'NULL', '773');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('773', '112', '2638', NULL , '2009-04-08 12:08:35' , 'Initialisation de la valeur «DJ» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2639', '1074', '1', 'République dominicaine', 'DO', 'NULL', '774');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('774', '112', '2639', NULL , '2009-04-08 12:08:36' , 'Initialisation de la valeur «DO» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2640', '1074', '1', 'Dominique', 'DM', 'NULL', '775');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('775', '112', '2640', NULL , '2009-04-08 12:08:37' , 'Initialisation de la valeur «DM» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2641', '1074', '1', 'Égypte', 'EG', 'NULL', '776');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('776', '112', '2641', NULL , '2009-04-08 12:08:38' , 'Initialisation de la valeur «EG» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2642', '1074', '1', 'Salvador', 'SV', 'NULL', '777');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('777', '112', '2642', NULL , '2009-04-08 12:08:39' , 'Initialisation de la valeur «SV» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2643', '1074', '1', 'Émirats arabes unis', 'AE', 'NULL', '778');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('778', '112', '2643', NULL , '2009-04-08 12:08:40' , 'Initialisation de la valeur «AE» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2644', '1074', '1', 'Équateur', 'EC', 'NULL', '779');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('779', '112', '2644', NULL , '2009-04-08 12:08:41' , 'Initialisation de la valeur «EC» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2645', '1074', '1', 'Érythrée', 'ER', 'NULL', '780');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('780', '112', '2645', NULL , '2009-04-08 12:08:42' , 'Initialisation de la valeur «ER» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2646', '1074', '1', 'Espagne', 'ES', 'NULL', '781');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('781', '112', '2646', NULL , '2009-04-08 12:08:43' , 'Initialisation de la valeur «ES» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2647', '1074', '1', 'Estonie', 'EE', 'NULL', '782');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('782', '112', '2647', NULL , '2009-04-08 12:08:44' , 'Initialisation de la valeur «EE» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2648', '1074', '1', 'États-Unis', 'US', 'NULL', '783');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('783', '112', '2648', NULL , '2009-04-08 12:08:45' , 'Initialisation de la valeur «US» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2649', '1074', '1', 'Éthiopie', 'ET', 'NULL', '784');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('784', '112', '2649', NULL , '2009-04-08 12:08:46' , 'Initialisation de la valeur «ET» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2650', '1074', '1', 'Îles Malouines', 'FK', 'Territoire autonome (Royaume-Uni)', '785');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('785', '112', '2650', NULL , '2009-04-08 12:08:47' , 'Initialisation de la valeur «FK» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2651', '1074', '1', 'Îles Féroé', 'FO', 'NULL', '786');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('786', '112', '2651', NULL , '2009-04-08 12:08:48' , 'Initialisation de la valeur «FO» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2652', '1074', '1', 'Fidji', 'FJ', 'NULL', '787');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('787', '112', '2652', NULL , '2009-04-08 12:08:49' , 'Initialisation de la valeur «FJ» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2653', '1074', '1', 'Finlande', 'FI', 'NULL', '788');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('788', '112', '2653', NULL , '2009-04-08 12:08:50' , 'Initialisation de la valeur «FI» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2654', '1074', '1', 'France', 'FR', 'NULL', '789');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('789', '112', '2654', NULL , '2009-04-08 12:08:51' , 'Initialisation de la valeur «FR» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2655', '1074', '1', 'Gabon', 'GA', 'NULL', '790');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('790', '112', '2655', NULL , '2009-04-08 12:08:52' , 'Initialisation de la valeur «GA» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2656', '1074', '1', 'Gambie', 'GM', 'NULL', '791');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('791', '112', '2656', NULL , '2009-04-08 12:08:53' , 'Initialisation de la valeur «GM» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2657', '1074', '1', 'Géorgie', 'GE', 'NULL', '792');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('792', '112', '2657', NULL , '2009-04-08 12:08:54' , 'Initialisation de la valeur «GE» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2658', '1074', '1', 'Géorgie du Sud-et-les Îles Sandwich du Sud', 'GS', 'NULL', '793');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('793', '112', '2658', NULL , '2009-04-08 12:08:55' , 'Initialisation de la valeur «GS» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2659', '1074', '1', 'Ghana', 'GH', 'NULL', '794');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('794', '112', '2659', NULL , '2009-04-08 12:08:56' , 'Initialisation de la valeur «GH» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2660', '1074', '1', 'Gibraltar', 'GI', 'NULL', '795');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('795', '112', '2660', NULL , '2009-04-08 12:08:57' , 'Initialisation de la valeur «GI» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2661', '1074', '1', 'Grèce', 'GR', 'NULL', '796');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('796', '112', '2661', NULL , '2009-04-08 12:08:58' , 'Initialisation de la valeur «GR» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2662', '1074', '1', 'Grenade', 'GD', 'NULL', '797');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('797', '112', '2662', NULL , '2009-04-08 12:08:59' , 'Initialisation de la valeur «GD» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2663', '1074', '1', 'Groenland', 'GL', 'NULL', '798');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('798', '112', '2663', NULL , '2009-04-08 12:09:00' , 'Initialisation de la valeur «GL» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2664', '1074', '1', 'Guadeloupe', 'GP', 'NULL', '799');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('799', '112', '2664', NULL , '2009-04-08 12:09:01' , 'Initialisation de la valeur «GP» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2665', '1074', '1', 'Guam', 'GU', 'NULL', '800');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('800', '112', '2665', NULL , '2009-04-08 12:09:02' , 'Initialisation de la valeur «GU» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2666', '1074', '1', 'Guatemala', 'GT', 'NULL', '801');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('801', '112', '2666', NULL , '2009-04-08 12:09:03' , 'Initialisation de la valeur «GT» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2667', '1074', '1', 'Guernesey', 'GG', 'NULL', '802');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('802', '112', '2667', NULL , '2009-04-08 12:09:04' , 'Initialisation de la valeur «GG» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2668', '1074', '1', 'Guinée', 'GN', 'NULL', '803');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('803', '112', '2668', NULL , '2009-04-08 12:09:05' , 'Initialisation de la valeur «GN» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2669', '1074', '1', 'Guinée-Bissau', 'GW', 'NULL', '804');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('804', '112', '2669', NULL , '2009-04-08 12:09:06' , 'Initialisation de la valeur «GW» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2670', '1074', '1', 'Guinée équatoriale', 'GQ', 'NULL', '805');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('805', '112', '2670', NULL , '2009-04-08 12:09:07' , 'Initialisation de la valeur «GQ» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2671', '1074', '1', 'Guyana', 'GY', 'NULL', '806');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('806', '112', '2671', NULL , '2009-04-08 12:09:08' , 'Initialisation de la valeur «GY» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2672', '1074', '1', 'Guyane', 'GF', 'NULL', '807');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('807', '112', '2672', NULL , '2009-04-08 12:09:09' , 'Initialisation de la valeur «GF» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2673', '1074', '1', 'Haïti', 'HT', 'NULL', '808');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('808', '112', '2673', NULL , '2009-04-08 12:09:10' , 'Initialisation de la valeur «HT» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2674', '1074', '1', 'Île Heard et îles McDonald', 'HM', 'Australie (Territoire)', '809');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('809', '112', '2674', NULL , '2009-04-08 12:09:11' , 'Initialisation de la valeur «HM» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2675', '1074', '1', 'Honduras', 'HN', 'NULL', '810');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('810', '112', '2675', NULL , '2009-04-08 12:09:12' , 'Initialisation de la valeur «HN» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2676', '1074', '1', 'Hong Kong', 'HK', 'NULL', '811');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('811', '112', '2676', NULL , '2009-04-08 12:09:13' , 'Initialisation de la valeur «HK» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2677', '1074', '1', 'Hongrie', 'HU', 'NULL', '812');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('812', '112', '2677', NULL , '2009-04-08 12:09:14' , 'Initialisation de la valeur «HU» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2678', '1074', '1', 'Île de Man', 'IM', 'NULL', '813');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('813', '112', '2678', NULL , '2009-04-08 12:09:15' , 'Initialisation de la valeur «IM» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2679', '1074', '1', 'Îles mineures éloignées des États-Unis', 'UM', 'NULL', '814');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('814', '112', '2679', NULL , '2009-04-08 12:09:16' , 'Initialisation de la valeur «UM» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2680', '1074', '1', 'Îles Vierges britanniques', 'VG', 'NULL', '815');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('815', '112', '2680', NULL , '2009-04-08 12:09:17' , 'Initialisation de la valeur «VG» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2681', '1074', '1', 'Îles Vierges américaines', 'VI', 'NULL', '816');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('816', '112', '2681', NULL , '2009-04-08 12:09:18' , 'Initialisation de la valeur «VI» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2682', '1074', '1', 'Inde', 'IN', 'NULL', '817');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('817', '112', '2682', NULL , '2009-04-08 12:09:19' , 'Initialisation de la valeur «IN» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2683', '1074', '1', 'Indonésie', 'ID', 'NULL', '818');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('818', '112', '2683', NULL , '2009-04-08 12:09:20' , 'Initialisation de la valeur «ID» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2684', '1074', '1', 'Iran', 'IR', 'NULL', '819');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('819', '112', '2684', NULL , '2009-04-08 12:09:21' , 'Initialisation de la valeur «IR» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2685', '1074', '1', 'Irak', 'IQ', 'NULL', '820');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('820', '112', '2685', NULL , '2009-04-08 12:09:22' , 'Initialisation de la valeur «IQ» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2686', '1074', '1', 'Irlande', 'IE', 'NULL', '821');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('821', '112', '2686', NULL , '2009-04-08 12:09:23' , 'Initialisation de la valeur «IE» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2687', '1074', '1', 'Islande', 'IS', 'NULL', '822');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('822', '112', '2687', NULL , '2009-04-08 12:09:24' , 'Initialisation de la valeur «IS» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2688', '1074', '1', 'Israël', 'IL', 'NULL', '823');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('823', '112', '2688', NULL , '2009-04-08 12:09:25' , 'Initialisation de la valeur «IL» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2689', '1074', '1', 'Italie', 'IT', 'NULL', '824');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('824', '112', '2689', NULL , '2009-04-08 12:09:26' , 'Initialisation de la valeur «IT» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2690', '1074', '1', 'Jamaïque', 'JM', 'NULL', '825');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('825', '112', '2690', NULL , '2009-04-08 12:09:27' , 'Initialisation de la valeur «JM» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2691', '1074', '1', 'Japon', 'JP', 'NULL', '826');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('826', '112', '2691', NULL , '2009-04-08 12:09:28' , 'Initialisation de la valeur «JP» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2692', '1074', '1', 'Jersey', 'JE', 'NULL', '827');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('827', '112', '2692', NULL , '2009-04-08 12:09:29' , 'Initialisation de la valeur «JE» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2693', '1074', '1', 'Jordanie', 'JO', 'NULL', '828');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('828', '112', '2693', NULL , '2009-04-08 12:09:30' , 'Initialisation de la valeur «JO» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2694', '1074', '1', 'Kazakhstan', 'KZ', 'NULL', '829');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('829', '112', '2694', NULL , '2009-04-08 12:09:31' , 'Initialisation de la valeur «KZ» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2695', '1074', '1', 'Kenya', 'KE', 'NULL', '830');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('830', '112', '2695', NULL , '2009-04-08 12:09:32' , 'Initialisation de la valeur «KE» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2696', '1074', '1', 'Kirghizistan', 'KG', 'NULL', '831');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('831', '112', '2696', NULL , '2009-04-08 12:09:33' , 'Initialisation de la valeur «KG» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2697', '1074', '1', 'Kiribati', 'KI', 'NULL', '832');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('832', '112', '2697', NULL , '2009-04-08 12:09:34' , 'Initialisation de la valeur «KI» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2698', '1074', '1', 'Koweït', 'KW', 'NULL', '833');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('833', '112', '2698', NULL , '2009-04-08 12:09:35' , 'Initialisation de la valeur «KW» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2699', '1074', '1', 'Laos', 'LA', 'NULL', '834');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('834', '112', '2699', NULL , '2009-04-08 12:09:36' , 'Initialisation de la valeur «LA» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2700', '1074', '1', 'Lesotho', 'LS', 'NULL', '835');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('835', '112', '2700', NULL , '2009-04-08 12:09:37' , 'Initialisation de la valeur «LS» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2701', '1074', '1', 'Lettonie', 'LV', 'NULL', '836');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('836', '112', '2701', NULL , '2009-04-08 12:09:38' , 'Initialisation de la valeur «LV» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2702', '1074', '1', 'Liban', 'LB', 'NULL', '837');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('837', '112', '2702', NULL , '2009-04-08 12:09:39' , 'Initialisation de la valeur «LB» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2703', '1074', '1', 'Libéria', 'LR', 'NULL', '838');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('838', '112', '2703', NULL , '2009-04-08 12:09:40' , 'Initialisation de la valeur «LR» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2704', '1074', '1', 'Libye', 'LY', 'NULL', '839');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('839', '112', '2704', NULL , '2009-04-08 12:09:41' , 'Initialisation de la valeur «LY» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2705', '1074', '1', 'Liechtenstein', 'LI', 'NULL', '840');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('840', '112', '2705', NULL , '2009-04-08 12:09:42' , 'Initialisation de la valeur «LI» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2706', '1074', '1', 'Lituanie', 'LT', 'NULL', '841');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('841', '112', '2706', NULL , '2009-04-08 12:09:43' , 'Initialisation de la valeur «LT» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2707', '1074', '1', 'Luxembourg', 'LU', 'NULL', '842');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('842', '112', '2707', NULL , '2009-04-08 12:09:44' , 'Initialisation de la valeur «LU» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2708', '1074', '1', 'Macao', 'MO', 'NULL', '843');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('843', '112', '2708', NULL , '2009-04-08 12:09:45' , 'Initialisation de la valeur «MO» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2709', '1074', '1', 'Macédoine', 'MK', 'NULL', '844');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('844', '112', '2709', NULL , '2009-04-08 12:09:46' , 'Initialisation de la valeur «MK» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2710', '1074', '1', 'Madagascar', 'MG', 'NULL', '845');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('845', '112', '2710', NULL , '2009-04-08 12:09:47' , 'Initialisation de la valeur «MG» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2711', '1074', '1', 'Malaisie', 'MY', 'NULL', '846');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('846', '112', '2711', NULL , '2009-04-08 12:09:48' , 'Initialisation de la valeur «MY» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2712', '1074', '1', 'Malawi', 'MW', 'NULL', '847');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('847', '112', '2712', NULL , '2009-04-08 12:09:49' , 'Initialisation de la valeur «MW» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2713', '1074', '1', 'Maldives', 'MV', 'NULL', '848');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('848', '112', '2713', NULL , '2009-04-08 12:09:50' , 'Initialisation de la valeur «MV» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2714', '1074', '1', 'Mali', 'ML', 'NULL', '849');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('849', '112', '2714', NULL , '2009-04-08 12:09:51' , 'Initialisation de la valeur «ML» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2715', '1074', '1', 'Malte', 'MT', 'NULL', '850');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('850', '112', '2715', NULL , '2009-04-08 12:09:52' , 'Initialisation de la valeur «MT» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2716', '1074', '1', 'Îles Mariannes du Nord', 'MP', 'NULL', '851');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('851', '112', '2716', NULL , '2009-04-08 12:09:53' , 'Initialisation de la valeur «MP» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2717', '1074', '1', 'Maroc', 'MA', 'NULL', '852');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('852', '112', '2717', NULL , '2009-04-08 12:09:54' , 'Initialisation de la valeur «MA» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2718', '1074', '1', 'Îles Marshall', 'MH', 'NULL', '853');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('853', '112', '2718', NULL , '2009-04-08 12:09:55' , 'Initialisation de la valeur «MH» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2719', '1074', '1', 'Martinique', 'MQ', 'NULL', '854');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('854', '112', '2719', NULL , '2009-04-08 12:09:56' , 'Initialisation de la valeur «MQ» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2720', '1074', '1', 'Maurice', 'MU', 'NULL', '855');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('855', '112', '2720', NULL , '2009-04-08 12:09:57' , 'Initialisation de la valeur «MU» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2721', '1074', '1', 'Mauritanie', 'MR', 'NULL', '856');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('856', '112', '2721', NULL , '2009-04-08 12:09:58' , 'Initialisation de la valeur «MR» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2722', '1074', '1', 'Mayotte', 'YT', 'NULL', '857');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('857', '112', '2722', NULL , '2009-04-08 12:09:59' , 'Initialisation de la valeur «YT» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2723', '1074', '1', 'Mexique', 'MX', 'NULL', '858');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('858', '112', '2723', NULL , '2009-04-08 12:10:00' , 'Initialisation de la valeur «MX» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2724', '1074', '1', 'Micronésie', 'FM', 'NULL', '859');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('859', '112', '2724', NULL , '2009-04-08 12:10:01' , 'Initialisation de la valeur «FM» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2725', '1074', '1', 'Moldavie', 'MD', 'NULL', '860');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('860', '112', '2725', NULL , '2009-04-08 12:10:02' , 'Initialisation de la valeur «MD» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2726', '1074', '1', 'Monaco', 'MC', 'NULL', '861');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('861', '112', '2726', NULL , '2009-04-08 12:10:03' , 'Initialisation de la valeur «MC» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2727', '1074', '1', 'Mongolie', 'MN', 'NULL', '862');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('862', '112', '2727', NULL , '2009-04-08 12:10:04' , 'Initialisation de la valeur «MN» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2728', '1074', '1', 'Monténégro', 'ME', 'NULL', '863');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('863', '112', '2728', NULL , '2009-04-08 12:10:05' , 'Initialisation de la valeur «ME» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2729', '1074', '1', 'Montserrat', 'MS', 'NULL', '864');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('864', '112', '2729', NULL , '2009-04-08 12:10:06' , 'Initialisation de la valeur «MS» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2730', '1074', '1', 'Mozambique', 'MZ', 'NULL', '865');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('865', '112', '2730', NULL , '2009-04-08 12:10:07' , 'Initialisation de la valeur «MZ» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2731', '1074', '1', 'Birmanie', 'MM', 'NULL', '866');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('866', '112', '2731', NULL , '2009-04-08 12:10:08' , 'Initialisation de la valeur «MM» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2732', '1074', '1', 'Namibie', 'NA', 'NULL', '867');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('867', '112', '2732', NULL , '2009-04-08 12:10:09' , 'Initialisation de la valeur «NA» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2733', '1074', '1', 'Nauru', 'NR', 'NULL', '868');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('868', '112', '2733', NULL , '2009-04-08 12:10:10' , 'Initialisation de la valeur «NR» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2734', '1074', '1', 'Népal', 'NP', 'NULL', '869');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('869', '112', '2734', NULL , '2009-04-08 12:10:11' , 'Initialisation de la valeur «NP» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2735', '1074', '1', 'Nicaragua', 'NI', 'NULL', '870');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('870', '112', '2735', NULL , '2009-04-08 12:10:12' , 'Initialisation de la valeur «NI» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2736', '1074', '1', 'Niger', 'NE', 'NULL', '871');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('871', '112', '2736', NULL , '2009-04-08 12:10:13' , 'Initialisation de la valeur «NE» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2737', '1074', '1', 'Nigeria', 'NG', 'NULL', '872');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('872', '112', '2737', NULL , '2009-04-08 12:10:14' , 'Initialisation de la valeur «NG» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2738', '1074', '1', 'Niué', 'NU', 'NULL', '873');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('873', '112', '2738', NULL , '2009-04-08 12:10:15' , 'Initialisation de la valeur «NU» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2739', '1074', '1', 'Norfolk', 'NF', 'NULL', '874');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('874', '112', '2739', NULL , '2009-04-08 12:10:16' , 'Initialisation de la valeur «NF» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2740', '1074', '1', 'Norvège', 'NO', 'NULL', '875');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('875', '112', '2740', NULL , '2009-04-08 12:10:17' , 'Initialisation de la valeur «NO» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2741', '1074', '1', 'Nouvelle-Calédonie', 'NC', 'NULL', '876');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('876', '112', '2741', NULL , '2009-04-08 12:10:18' , 'Initialisation de la valeur «NC» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2742', '1074', '1', 'Nouvelle-Zélande', 'NZ', 'NULL', '877');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('877', '112', '2742', NULL , '2009-04-08 12:10:19' , 'Initialisation de la valeur «NZ» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2743', '1074', '1', 'Territoire britannique de l''océan Indien', 'IO', 'NULL', '878');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('878', '112', '2743', NULL , '2009-04-08 12:10:20' , 'Initialisation de la valeur «IO» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2744', '1074', '1', 'Oman', 'OM', 'NULL', '879');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('879', '112', '2744', NULL , '2009-04-08 12:10:21' , 'Initialisation de la valeur «OM» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2745', '1074', '1', 'Ouganda', 'UG', 'NULL', '880');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('880', '112', '2745', NULL , '2009-04-08 12:10:22' , 'Initialisation de la valeur «UG» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2746', '1074', '1', 'Ouzbékistan', 'UZ', 'NULL', '881');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('881', '112', '2746', NULL , '2009-04-08 12:10:23' , 'Initialisation de la valeur «UZ» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2747', '1074', '1', 'Pakistan', 'PK', 'NULL', '882');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('882', '112', '2747', NULL , '2009-04-08 12:10:24' , 'Initialisation de la valeur «PK» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2748', '1074', '1', 'Palaos', 'PW', 'NULL', '883');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('883', '112', '2748', NULL , '2009-04-08 12:10:25' , 'Initialisation de la valeur «PW» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2749', '1074', '1', 'Palestine', 'PS', 'NULL', '884');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('884', '112', '2749', NULL , '2009-04-08 12:10:26' , 'Initialisation de la valeur «PS» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2750', '1074', '1', 'Panamá', 'PA', 'NULL', '885');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('885', '112', '2750', NULL , '2009-04-08 12:10:27' , 'Initialisation de la valeur «PA» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2751', '1074', '1', 'Papouasie-Nouvelle-Guinée', 'PG', 'NULL', '886');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('886', '112', '2751', NULL , '2009-04-08 12:10:28' , 'Initialisation de la valeur «PG» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2752', '1074', '1', 'Paraguay', 'PY', 'NULL', '887');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('887', '112', '2752', NULL , '2009-04-08 12:10:29' , 'Initialisation de la valeur «PY» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2753', '1074', '1', 'Pays-Bas', 'NL', 'NULL', '888');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('888', '112', '2753', NULL , '2009-04-08 12:10:30' , 'Initialisation de la valeur «NL» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2754', '1074', '1', 'Pérou', 'PE', 'NULL', '889');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('889', '112', '2754', NULL , '2009-04-08 12:10:31' , 'Initialisation de la valeur «PE» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2755', '1074', '1', 'Philippines', 'PH', 'NULL', '890');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('890', '112', '2755', NULL , '2009-04-08 12:10:32' , 'Initialisation de la valeur «PH» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2756', '1074', '1', 'Pitcairn', 'PN', 'NULL', '891');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('891', '112', '2756', NULL , '2009-04-08 12:10:33' , 'Initialisation de la valeur «PN» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2757', '1074', '1', 'Pologne', 'PL', 'NULL', '892');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('892', '112', '2757', NULL , '2009-04-08 12:10:34' , 'Initialisation de la valeur «PL» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2758', '1074', '1', 'Polynésie française', 'PF', 'NULL', '893');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('893', '112', '2758', NULL , '2009-04-08 12:10:35' , 'Initialisation de la valeur «PF» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2759', '1074', '1', 'Porto Rico', 'PR', 'NULL', '894');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('894', '112', '2759', NULL , '2009-04-08 12:10:36' , 'Initialisation de la valeur «PR» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2760', '1074', '1', 'Portugal', 'PT', 'NULL', '895');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('895', '112', '2760', NULL , '2009-04-08 12:10:37' , 'Initialisation de la valeur «PT» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2761', '1074', '1', 'Qatar', 'QA', 'NULL', '896');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('896', '112', '2761', NULL , '2009-04-08 12:10:38' , 'Initialisation de la valeur «QA» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2762', '1074', '1', 'La Réunion', 'RE', 'NULL', '897');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('897', '112', '2762', NULL , '2009-04-08 12:10:39' , 'Initialisation de la valeur «RE» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2763', '1074', '1', 'Roumanie', 'RO', 'NULL', '898');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('898', '112', '2763', NULL , '2009-04-08 12:10:40' , 'Initialisation de la valeur «RO» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2764', '1074', '1', 'Royaume-Uni', 'GB', 'NULL', '899');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('899', '112', '2764', NULL , '2009-04-08 12:10:41' , 'Initialisation de la valeur «GB» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2765', '1074', '1', 'Russie', 'RU', 'NULL', '900');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('900', '112', '2765', NULL , '2009-04-08 12:10:42' , 'Initialisation de la valeur «RU» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2766', '1074', '1', 'Rwanda', 'RW', 'NULL', '901');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('901', '112', '2766', NULL , '2009-04-08 12:10:43' , 'Initialisation de la valeur «RW» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2767', '1074', '1', 'Sahara occidental', 'EH', 'NULL', '902');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('902', '112', '2767', NULL , '2009-04-08 12:10:44' , 'Initialisation de la valeur «EH» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2768', '1074', '1', 'Saint-Barthélemy', 'BL', 'NULL', '903');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('903', '112', '2768', NULL , '2009-04-08 12:10:45' , 'Initialisation de la valeur «BL» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2769', '1074', '1', 'Saint-Christophe-et-Niévès', 'KN', 'NULL', '904');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('904', '112', '2769', NULL , '2009-04-08 12:10:46' , 'Initialisation de la valeur «KN» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2770', '1074', '1', 'Saint-Marin', 'SM', 'NULL', '905');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('905', '112', '2770', NULL , '2009-04-08 12:10:47' , 'Initialisation de la valeur «SM» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2771', '1074', '1', 'Saint-Martin', 'MF', 'NULL', '906');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('906', '112', '2771', NULL , '2009-04-08 12:10:48' , 'Initialisation de la valeur «MF» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2772', '1074', '1', 'Saint-Pierre-et-Miquelon', 'PM', 'NULL', '907');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('907', '112', '2772', NULL , '2009-04-08 12:10:49' , 'Initialisation de la valeur «PM» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2773', '1074', '1', 'Vatican / (Saint-Siège)', 'VA', 'NULL', '908');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('908', '112', '2773', NULL , '2009-04-08 12:10:50' , 'Initialisation de la valeur «VA» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2774', '1074', '1', 'Saint-Vincent-et-les Grenadines', 'VC', 'NULL', '909');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('909', '112', '2774', NULL , '2009-04-08 12:10:51' , 'Initialisation de la valeur «VC» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2775', '1074', '1', 'Sainte-Hélène (territoire)', 'SH', 'NULL', '910');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('910', '112', '2775', NULL , '2009-04-08 12:10:52' , 'Initialisation de la valeur «SH» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2776', '1074', '1', 'Sainte-Lucie', 'LC', 'NULL', '911');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('911', '112', '2776', NULL , '2009-04-08 12:10:53' , 'Initialisation de la valeur «LC» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2777', '1074', '1', 'Salomon', 'SB', 'NULL', '912');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('912', '112', '2777', NULL , '2009-04-08 12:10:54' , 'Initialisation de la valeur «SB» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2778', '1074', '1', 'Samoa', 'WS', 'NULL', '913');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('913', '112', '2778', NULL , '2009-04-08 12:10:55' , 'Initialisation de la valeur «WS» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2779', '1074', '1', 'Samoa américaines', 'AS', 'NULL', '914');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('914', '112', '2779', NULL , '2009-04-08 12:10:56' , 'Initialisation de la valeur «AS» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2780', '1074', '1', 'Sao Tomé-et-Principe', 'ST', 'NULL', '915');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('915', '112', '2780', NULL , '2009-04-08 12:10:57' , 'Initialisation de la valeur «ST» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2781', '1074', '1', 'Sénégal', 'SN', 'NULL', '916');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('916', '112', '2781', NULL , '2009-04-08 12:10:58' , 'Initialisation de la valeur «SN» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2782', '1074', '1', 'Serbie', 'RS', 'NULL', '917');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('917', '112', '2782', NULL , '2009-04-08 12:10:59' , 'Initialisation de la valeur «RS» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2783', '1074', '1', 'Seychelles', 'SC', 'NULL', '918');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('918', '112', '2783', NULL , '2009-04-08 12:11:00' , 'Initialisation de la valeur «SC» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2784', '1074', '1', 'Sierra Leone', 'SL', 'NULL', '919');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('919', '112', '2784', NULL , '2009-04-08 12:11:01' , 'Initialisation de la valeur «SL» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2785', '1074', '1', 'Singapour', 'SG', 'NULL', '920');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('920', '112', '2785', NULL , '2009-04-08 12:11:02' , 'Initialisation de la valeur «SG» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2786', '1074', '1', 'Slovaquie', 'SK', 'NULL', '921');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('921', '112', '2786', NULL , '2009-04-08 12:11:03' , 'Initialisation de la valeur «SK» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2787', '1074', '1', 'Slovénie', 'SI', 'NULL', '922');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('922', '112', '2787', NULL , '2009-04-08 12:11:04' , 'Initialisation de la valeur «SI» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2788', '1074', '1', 'Somalie', 'SO', 'NULL', '923');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('923', '112', '2788', NULL , '2009-04-08 12:11:05' , 'Initialisation de la valeur «SO» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2789', '1074', '1', 'Soudan', 'SD', 'NULL', '924');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('924', '112', '2789', NULL , '2009-04-08 12:11:06' , 'Initialisation de la valeur «SD» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2790', '1074', '1', 'Sri Lanka', 'LK', 'NULL', '925');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('925', '112', '2790', NULL , '2009-04-08 12:11:07' , 'Initialisation de la valeur «LK» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2791', '1074', '1', 'Suède', 'SE', 'NULL', '926');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('926', '112', '2791', NULL , '2009-04-08 12:11:08' , 'Initialisation de la valeur «SE» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2792', '1074', '1', 'Suisse', 'CH', 'NULL', '927');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('927', '112', '2792', NULL , '2009-04-08 12:11:09' , 'Initialisation de la valeur «CH» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2793', '1074', '1', 'Suriname', 'SR', 'NULL', '928');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('928', '112', '2793', NULL , '2009-04-08 12:11:10' , 'Initialisation de la valeur «SR» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2794', '1074', '1', 'Svalbard et île Jan Mayen', 'SJ', 'NULL', '929');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('929', '112', '2794', NULL , '2009-04-08 12:11:11' , 'Initialisation de la valeur «SJ» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2795', '1074', '1', 'Swaziland', 'SZ', 'NULL', '930');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('930', '112', '2795', NULL , '2009-04-08 12:11:12' , 'Initialisation de la valeur «SZ» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2796', '1074', '1', 'Syrie', 'SY', 'NULL', '931');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('931', '112', '2796', NULL , '2009-04-08 12:11:13' , 'Initialisation de la valeur «SY» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2797', '1074', '1', 'Tadjikistan', 'TJ', 'NULL', '932');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('932', '112', '2797', NULL , '2009-04-08 12:11:14' , 'Initialisation de la valeur «TJ» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2798', '1074', '1', 'Taïwan / (République de Chine (Taïwan))', 'TW', 'NULL', '933');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('933', '112', '2798', NULL , '2009-04-08 12:11:15' , 'Initialisation de la valeur «TW» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2799', '1074', '1', 'Tanzanie', 'TZ', 'NULL', '934');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('934', '112', '2799', NULL , '2009-04-08 12:11:16' , 'Initialisation de la valeur «TZ» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2800', '1074', '1', 'Tchad', 'TD', 'NULL', '935');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('935', '112', '2800', NULL , '2009-04-08 12:11:17' , 'Initialisation de la valeur «TD» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2801', '1074', '1', 'République tchèque', 'CZ', 'NULL', '936');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('936', '112', '2801', NULL , '2009-04-08 12:11:18' , 'Initialisation de la valeur «CZ» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2802', '1074', '1', 'Terres australes et antarctiques françaises', 'TF', 'NULL', '937');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('937', '112', '2802', NULL , '2009-04-08 12:11:19' , 'Initialisation de la valeur «TF» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2803', '1074', '1', 'Thaïlande', 'TH', 'NULL', '938');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('938', '112', '2803', NULL , '2009-04-08 12:11:20' , 'Initialisation de la valeur «TH» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2804', '1074', '1', 'Timor oriental', 'TL', 'NULL', '939');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('939', '112', '2804', NULL , '2009-04-08 12:11:21' , 'Initialisation de la valeur «TL» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2805', '1074', '1', 'Togo', 'TG', 'NULL', '940');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('940', '112', '2805', NULL , '2009-04-08 12:11:22' , 'Initialisation de la valeur «TG» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2806', '1074', '1', 'Tokelau', 'TK', 'NULL', '941');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('941', '112', '2806', NULL , '2009-04-08 12:11:23' , 'Initialisation de la valeur «TK» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2807', '1074', '1', 'Tonga', 'TO', 'NULL', '942');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('942', '112', '2807', NULL , '2009-04-08 12:11:24' , 'Initialisation de la valeur «TO» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2808', '1074', '1', 'Trinité-et-Tobago', 'TT', 'NULL', '943');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('943', '112', '2808', NULL , '2009-04-08 12:11:25' , 'Initialisation de la valeur «TT» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2809', '1074', '1', 'Tunisie', 'TN', 'NULL', '944');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('944', '112', '2809', NULL , '2009-04-08 12:11:26' , 'Initialisation de la valeur «TN» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2810', '1074', '1', 'Turkménistan', 'TM', 'NULL', '945');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('945', '112', '2810', NULL , '2009-04-08 12:11:27' , 'Initialisation de la valeur «TM» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2811', '1074', '1', 'Îles Turques-et-Caïques', 'TC', 'NULL', '946');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('946', '112', '2811', NULL , '2009-04-08 12:11:28' , 'Initialisation de la valeur «TC» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2812', '1074', '1', 'Turquie', 'TR', 'NULL', '947');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('947', '112', '2812', NULL , '2009-04-08 12:11:29' , 'Initialisation de la valeur «TR» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2813', '1074', '1', 'Tuvalu', 'TV', 'NULL', '948');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('948', '112', '2813', NULL , '2009-04-08 12:11:30' , 'Initialisation de la valeur «TV» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2814', '1074', '1', 'Ukraine', 'UA', 'NULL', '949');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('949', '112', '2814', NULL , '2009-04-08 12:11:31' , 'Initialisation de la valeur «UA» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2815', '1074', '1', 'Uruguay', 'UY', 'NULL', '950');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('950', '112', '2815', NULL , '2009-04-08 12:11:32' , 'Initialisation de la valeur «UY» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2816', '1074', '1', 'Vanuatu', 'VU', 'NULL', '951');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('951', '112', '2816', NULL , '2009-04-08 12:11:33' , 'Initialisation de la valeur «VU» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2817', '1074', '1', 'Venezuela', 'VE', 'NULL', '952');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('952', '112', '2817', NULL , '2009-04-08 12:11:34' , 'Initialisation de la valeur «VE» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2818', '1074', '1', 'Viêt Nam', 'VN', 'NULL', '953');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('953', '112', '2818', NULL , '2009-04-08 12:11:35' , 'Initialisation de la valeur «VN» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2819', '1074', '1', 'Wallis-et-Futuna', 'WF', 'NULL', '954');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('954', '112', '2819', NULL , '2009-04-08 12:11:36' , 'Initialisation de la valeur «WF» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2820', '1074', '1', 'Yémen', 'YE', 'NULL', '955');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('955', '112', '2820', NULL , '2009-04-08 12:11:37' , 'Initialisation de la valeur «YE» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2821', '1074', '1', 'Zambie', 'ZM', 'NULL', '956');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('956', '112', '2821', NULL , '2009-04-08 12:11:38' , 'Initialisation de la valeur «ZM» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2822', '1074', '1', 'Zimbabwe', 'ZW', 'NULL', '957');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('957', '112', '2822', NULL , '2009-04-08 12:11:39' , 'Initialisation de la valeur «ZW» pour la liste «71».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2835', '1078', '1', 'Andorra (general)', 'AD.00', 'NULL', '958');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('958', '112', '2835', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AD.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2836', '1078', '1', 'Andorra', 'AD.01', 'NULL', '959');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('959', '112', '2836', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AD.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2837', '1078', '1', 'Parròquia de Canillo', 'AD.02', 'NULL', '960');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('960', '112', '2837', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AD.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2838', '1078', '1', 'Parròquia d''Encamp', 'AD.03', 'NULL', '961');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('961', '112', '2838', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AD.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2839', '1078', '1', 'Parròquia de la Massana', 'AD.04', 'NULL', '962');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('962', '112', '2839', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AD.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2840', '1078', '1', 'Parròquia d''Ordino', 'AD.05', 'NULL', '963');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('963', '112', '2840', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AD.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2841', '1078', '1', 'Parròquia de Sant Julià de Lòria', 'AD.06', 'NULL', '964');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('964', '112', '2841', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AD.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2842', '1078', '1', 'Parròquia d''Andorra la Vella', 'AD.07', 'NULL', '965');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('965', '112', '2842', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AD.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2843', '1078', '1', 'Parròquia d''Escaldes-Engordany', 'AD.08', 'NULL', '966');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('966', '112', '2843', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AD.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2844', '1078', '1', 'United Arab Emirates (general)', 'AE.00', 'NULL', '967');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('967', '112', '2844', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AE.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2845', '1078', '1', 'Abū Z̧aby', 'AE.01', 'NULL', '968');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('968', '112', '2845', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AE.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2846', '1078', '1', '‘Ajmān', 'AE.02', 'NULL', '969');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('969', '112', '2846', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AE.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2847', '1078', '1', 'Dubayy', 'AE.03', 'NULL', '970');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('970', '112', '2847', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AE.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2848', '1078', '1', 'Al Fujayrah', 'AE.04', 'NULL', '971');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('971', '112', '2848', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AE.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2849', '1078', '1', 'Raʼs al Khaymah', 'AE.05', 'NULL', '972');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('972', '112', '2849', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AE.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2850', '1078', '1', 'Ash Shāriqah', 'AE.06', 'NULL', '973');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('973', '112', '2850', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AE.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2851', '1078', '1', 'Umm al Qaywayn', 'AE.07', 'NULL', '974');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('974', '112', '2851', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AE.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2852', '1078', '1', 'Afghanistan (general)', 'AF.00', 'NULL', '975');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('975', '112', '2852', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2853', '1078', '1', 'Badakhshan', 'AF.01', 'NULL', '976');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('976', '112', '2853', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2854', '1078', '1', 'Badghis Province', 'AF.02', 'NULL', '977');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('977', '112', '2854', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2855', '1078', '1', 'Baghlān', 'AF.03', 'NULL', '978');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('978', '112', '2855', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2856', '1078', '1', 'Bāmīān', 'AF.05', 'NULL', '979');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('979', '112', '2856', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2857', '1078', '1', 'Farah', 'AF.06', 'NULL', '980');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('980', '112', '2857', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2858', '1078', '1', 'Faryab Province', 'AF.07', 'NULL', '981');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('981', '112', '2858', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2859', '1078', '1', 'Ghaznī', 'AF.08', 'NULL', '982');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('982', '112', '2859', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2860', '1078', '1', 'Ghowr', 'AF.09', 'NULL', '983');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('983', '112', '2860', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.09» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2861', '1078', '1', 'Helmand', 'AF.10', 'NULL', '984');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('984', '112', '2861', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.10» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2862', '1078', '1', 'Herat Province', 'AF.11', 'NULL', '985');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('985', '112', '2862', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.11» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2863', '1078', '1', 'Kabul', 'AF.13', 'NULL', '986');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('986', '112', '2863', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.13» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2864', '1078', '1', 'Kāpīsā', 'AF.14', 'NULL', '987');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('987', '112', '2864', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.14» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2865', '1078', '1', 'Konarha', 'AF.15', 'NULL', '988');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('988', '112', '2865', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.15» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2866', '1078', '1', 'Laghman', 'AF.16', 'NULL', '989');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('989', '112', '2866', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.16» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2867', '1078', '1', 'Lowgar', 'AF.17', 'NULL', '990');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('990', '112', '2867', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.17» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2868', '1078', '1', 'Nangarhār', 'AF.18', 'NULL', '991');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('991', '112', '2868', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.18» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2869', '1078', '1', 'Nīmrūz', 'AF.19', 'NULL', '992');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('992', '112', '2869', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.19» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2870', '1078', '1', 'Orūzgān', 'AF.20', 'NULL', '993');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('993', '112', '2870', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.20» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2871', '1078', '1', 'Paktika', 'AF.21', 'NULL', '994');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('994', '112', '2871', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.21» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2872', '1078', '1', 'Parvān', 'AF.22', 'NULL', '995');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('995', '112', '2872', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.22» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2873', '1078', '1', 'Kandahār', 'AF.23', 'NULL', '996');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('996', '112', '2873', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.23» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2874', '1078', '1', 'Kunduz Province', 'AF.24', 'NULL', '997');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('997', '112', '2874', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.24» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2875', '1078', '1', 'Takhār', 'AF.26', 'NULL', '998');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('998', '112', '2875', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.26» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2876', '1078', '1', 'Vardak', 'AF.27', 'NULL', '999');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('999', '112', '2876', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.27» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2877', '1078', '1', 'Zabul Province', 'AF.28', 'NULL', '1000');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1000', '112', '2877', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.28» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2878', '1078', '1', 'Paktīkā', 'AF.29', 'NULL', '1001');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1001', '112', '2878', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.29» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2879', '1078', '1', 'Balkh', 'AF.30', 'NULL', '1002');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1002', '112', '2879', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.30» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2880', '1078', '1', 'Jowzjān', 'AF.31', 'NULL', '1003');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1003', '112', '2880', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.31» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2881', '1078', '1', 'Samangān', 'AF.32', 'NULL', '1004');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1004', '112', '2881', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.32» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2882', '1078', '1', 'Sar-e Pol', 'AF.33', 'NULL', '1005');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1005', '112', '2882', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.33» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2883', '1078', '1', 'Konar', 'AF.34', 'NULL', '1006');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1006', '112', '2883', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.34» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2884', '1078', '1', 'Laghmān', 'AF.35', 'NULL', '1007');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1007', '112', '2884', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.35» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2885', '1078', '1', 'Paktia Province', 'AF.36', 'NULL', '1008');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1008', '112', '2885', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.36» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2886', '1078', '1', 'Khowst', 'AF.37', 'NULL', '1009');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1009', '112', '2886', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.37» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2887', '1078', '1', 'Nūrestān', 'AF.38', 'NULL', '1010');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1010', '112', '2887', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.38» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2888', '1078', '1', 'Orūzgān Province', 'AF.39', 'NULL', '1011');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1011', '112', '2888', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.39» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2889', '1078', '1', 'Parvān', 'AF.40', 'NULL', '1012');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1012', '112', '2889', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.40» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2890', '1078', '1', 'Dāykondī', 'AF.41', 'NULL', '1013');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1013', '112', '2890', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.41» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2891', '1078', '1', 'Panjshīr', 'AF.42', 'NULL', '1014');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1014', '112', '2891', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AF.42» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2892', '1078', '1', 'Antigua and Barbuda (general)', 'AG.00', 'NULL', '1015');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1015', '112', '2892', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AG.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2893', '1078', '1', 'Barbuda', 'AG.01', 'NULL', '1016');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1016', '112', '2893', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AG.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2894', '1078', '1', 'Saint George', 'AG.03', 'NULL', '1017');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1017', '112', '2894', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AG.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2895', '1078', '1', 'Saint John', 'AG.04', 'NULL', '1018');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1018', '112', '2895', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AG.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2896', '1078', '1', 'Saint Mary', 'AG.05', 'NULL', '1019');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1019', '112', '2896', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AG.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2897', '1078', '1', 'Saint Paul', 'AG.06', 'NULL', '1020');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1020', '112', '2897', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AG.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2898', '1078', '1', 'Saint Peter', 'AG.07', 'NULL', '1021');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1021', '112', '2898', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AG.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2899', '1078', '1', 'Saint Philip', 'AG.08', 'NULL', '1022');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1022', '112', '2899', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AG.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2900', '1078', '1', 'Anguilla (general)', 'AI.00', 'NULL', '1023');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1023', '112', '2900', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AI.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2901', '1078', '1', 'Albania (general)', 'AL.00', 'NULL', '1024');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1024', '112', '2901', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AL.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2902', '1078', '1', 'Berat', 'AL.40', 'NULL', '1025');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1025', '112', '2902', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AL.40» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2903', '1078', '1', 'Dibër', 'AL.41', 'NULL', '1026');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1026', '112', '2903', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AL.41» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2904', '1078', '1', 'Durrës', 'AL.42', 'NULL', '1027');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1027', '112', '2904', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AL.42» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2905', '1078', '1', 'Elbasan', 'AL.43', 'NULL', '1028');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1028', '112', '2905', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AL.43» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2906', '1078', '1', 'Fier', 'AL.44', 'NULL', '1029');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1029', '112', '2906', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AL.44» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2907', '1078', '1', 'Gjirokastër', 'AL.45', 'NULL', '1030');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1030', '112', '2907', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AL.45» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2908', '1078', '1', 'Korçë', 'AL.46', 'NULL', '1031');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1031', '112', '2908', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AL.46» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2909', '1078', '1', 'Kukës', 'AL.47', 'NULL', '1032');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1032', '112', '2909', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AL.47» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2910', '1078', '1', 'Lezhë', 'AL.48', 'NULL', '1033');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1033', '112', '2910', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AL.48» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2911', '1078', '1', 'Shkodër', 'AL.49', 'NULL', '1034');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1034', '112', '2911', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AL.49» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2912', '1078', '1', 'Tiranë', 'AL.50', 'NULL', '1035');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1035', '112', '2912', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AL.50» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2913', '1078', '1', 'Vlorë', 'AL.51', 'NULL', '1036');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1036', '112', '2913', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AL.51» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2914', '1078', '1', 'Armenia (general)', 'AM.00', 'NULL', '1037');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1037', '112', '2914', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AM.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2915', '1078', '1', 'Aragatsotn', 'AM.01', 'NULL', '1038');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1038', '112', '2915', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AM.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2916', '1078', '1', 'Ararat', 'AM.02', 'NULL', '1039');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1039', '112', '2916', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AM.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2917', '1078', '1', 'Armavir', 'AM.03', 'NULL', '1040');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1040', '112', '2917', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AM.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2918', '1078', '1', 'Gegharkʼunikʼ', 'AM.04', 'NULL', '1041');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1041', '112', '2918', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AM.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2919', '1078', '1', 'Kotaykʼ', 'AM.05', 'NULL', '1042');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1042', '112', '2919', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AM.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2920', '1078', '1', 'Lorri', 'AM.06', 'NULL', '1043');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1043', '112', '2920', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AM.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2921', '1078', '1', 'Shirak', 'AM.07', 'NULL', '1044');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1044', '112', '2921', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AM.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2922', '1078', '1', 'Syunikʼ', 'AM.08', 'NULL', '1045');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1045', '112', '2922', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AM.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2923', '1078', '1', 'Tavush', 'AM.09', 'NULL', '1046');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1046', '112', '2923', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AM.09» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2924', '1078', '1', 'Vayotsʼ Dzor', 'AM.10', 'NULL', '1047');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1047', '112', '2924', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AM.10» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2925', '1078', '1', 'Yerevan', 'AM.11', 'NULL', '1048');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1048', '112', '2925', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AM.11» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2926', '1078', '1', 'Netherlands Antilles (general)', 'AN.00', 'NULL', '1049');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1049', '112', '2926', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AN.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2927', '1078', '1', 'Angola (general)', 'AO.00', 'NULL', '1050');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1050', '112', '2927', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AO.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2928', '1078', '1', 'Benguela', 'AO.01', 'NULL', '1051');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1051', '112', '2928', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AO.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2929', '1078', '1', 'Bié', 'AO.02', 'NULL', '1052');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1052', '112', '2929', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AO.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2930', '1078', '1', 'Cabinda', 'AO.03', 'NULL', '1053');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1053', '112', '2930', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AO.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2931', '1078', '1', 'Cuando Cubango', 'AO.04', 'NULL', '1054');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1054', '112', '2931', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AO.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2932', '1078', '1', 'Cuanza Norte', 'AO.05', 'NULL', '1055');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1055', '112', '2932', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AO.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2933', '1078', '1', 'Cuanza Sul', 'AO.06', 'NULL', '1056');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1056', '112', '2933', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AO.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2934', '1078', '1', 'Cunene', 'AO.07', 'NULL', '1057');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1057', '112', '2934', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AO.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2935', '1078', '1', 'Huambo', 'AO.08', 'NULL', '1058');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1058', '112', '2935', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AO.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2936', '1078', '1', 'Huíla', 'AO.09', 'NULL', '1059');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1059', '112', '2936', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AO.09» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2937', '1078', '1', 'Luanda', 'AO.10', 'NULL', '1060');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1060', '112', '2937', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AO.10» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2938', '1078', '1', 'Malanje', 'AO.12', 'NULL', '1061');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1061', '112', '2938', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AO.12» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2939', '1078', '1', 'Namibe', 'AO.13', 'NULL', '1062');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1062', '112', '2939', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AO.13» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2940', '1078', '1', 'Moxico', 'AO.14', 'NULL', '1063');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1063', '112', '2940', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AO.14» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2941', '1078', '1', 'Uíge', 'AO.15', 'NULL', '1064');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1064', '112', '2941', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AO.15» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2942', '1078', '1', 'Zaire', 'AO.16', 'NULL', '1065');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1065', '112', '2942', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AO.16» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2943', '1078', '1', 'Lunda Norte', 'AO.17', 'NULL', '1066');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1066', '112', '2943', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AO.17» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2944', '1078', '1', 'Lunda Sul', 'AO.18', 'NULL', '1067');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1067', '112', '2944', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AO.18» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2945', '1078', '1', 'Bengo', 'AO.19', 'NULL', '1068');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1068', '112', '2945', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AO.19» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2946', '1078', '1', 'Antarctica (general)', 'AQ.00', 'NULL', '1069');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1069', '112', '2946', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AQ.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2947', '1078', '1', 'Argentina (general)', 'AR.00', 'NULL', '1070');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1070', '112', '2947', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2948', '1078', '1', 'Buenos Aires', 'AR.01', 'NULL', '1071');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1071', '112', '2948', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2949', '1078', '1', 'Catamarca', 'AR.02', 'NULL', '1072');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1072', '112', '2949', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2950', '1078', '1', 'Chaco', 'AR.03', 'NULL', '1073');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1073', '112', '2950', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2951', '1078', '1', 'Chubut', 'AR.04', 'NULL', '1074');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1074', '112', '2951', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2952', '1078', '1', 'Córdoba', 'AR.05', 'NULL', '1075');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1075', '112', '2952', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2953', '1078', '1', 'Corrientes', 'AR.06', 'NULL', '1076');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1076', '112', '2953', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2954', '1078', '1', 'Distrito Federal', 'AR.07', 'NULL', '1077');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1077', '112', '2954', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2955', '1078', '1', 'Entre Ríos', 'AR.08', 'NULL', '1078');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1078', '112', '2955', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2956', '1078', '1', 'Formosa', 'AR.09', 'NULL', '1079');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1079', '112', '2956', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.09» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2957', '1078', '1', 'Jujuy', 'AR.10', 'NULL', '1080');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1080', '112', '2957', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.10» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2958', '1078', '1', 'La Pampa', 'AR.11', 'NULL', '1081');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1081', '112', '2958', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.11» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2959', '1078', '1', 'La Rioja', 'AR.12', 'NULL', '1082');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1082', '112', '2959', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.12» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2960', '1078', '1', 'Mendoza', 'AR.13', 'NULL', '1083');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1083', '112', '2960', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.13» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2961', '1078', '1', 'Misiones', 'AR.14', 'NULL', '1084');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1084', '112', '2961', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.14» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2962', '1078', '1', 'Neuquén', 'AR.15', 'NULL', '1085');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1085', '112', '2962', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.15» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2963', '1078', '1', 'Río Negro', 'AR.16', 'NULL', '1086');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1086', '112', '2963', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.16» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2964', '1078', '1', 'Salta', 'AR.17', 'NULL', '1087');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1087', '112', '2964', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.17» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2965', '1078', '1', 'San Juan', 'AR.18', 'NULL', '1088');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1088', '112', '2965', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.18» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2966', '1078', '1', 'San Luis', 'AR.19', 'NULL', '1089');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1089', '112', '2966', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.19» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2967', '1078', '1', 'Santa Cruz', 'AR.20', 'NULL', '1090');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1090', '112', '2967', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.20» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2968', '1078', '1', 'Santa Fe', 'AR.21', 'NULL', '1091');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1091', '112', '2968', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.21» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2969', '1078', '1', 'Santiago del Estero', 'AR.22', 'NULL', '1092');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1092', '112', '2969', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.22» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2970', '1078', '1', 'Tierra del Fuego, Antártida e Islas del Atlántico Sur', 'AR.23', 'NULL', '1093');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1093', '112', '2970', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.23» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2971', '1078', '1', 'Tucumán', 'AR.24', 'NULL', '1094');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1094', '112', '2971', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AR.24» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2972', '1078', '1', 'Austria (general)', 'AT.00', 'NULL', '1095');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1095', '112', '2972', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AT.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2973', '1078', '1', 'Burgenland', 'AT.01', 'NULL', '1096');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1096', '112', '2973', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AT.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2974', '1078', '1', 'Carinthia', 'AT.02', 'NULL', '1097');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1097', '112', '2974', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AT.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2975', '1078', '1', 'Lower Austria', 'AT.03', 'NULL', '1098');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1098', '112', '2975', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AT.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2976', '1078', '1', 'Upper Austria', 'AT.04', 'NULL', '1099');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1099', '112', '2976', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AT.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2977', '1078', '1', 'Salzburg', 'AT.05', 'NULL', '1100');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1100', '112', '2977', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AT.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2978', '1078', '1', 'Styria', 'AT.06', 'NULL', '1101');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1101', '112', '2978', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AT.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2979', '1078', '1', 'Tyrol', 'AT.07', 'NULL', '1102');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1102', '112', '2979', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AT.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2980', '1078', '1', 'Vorarlberg', 'AT.08', 'NULL', '1103');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1103', '112', '2980', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AT.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2981', '1078', '1', 'Vienna', 'AT.09', 'NULL', '1104');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1104', '112', '2981', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AT.09» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2982', '1078', '1', 'Heard Island and McDonald Islands (general)', 'AU.00', 'NULL', '1105');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1105', '112', '2982', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AU.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2983', '1078', '1', 'Australian Capital Territory', 'AU.01', 'NULL', '1106');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1106', '112', '2983', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AU.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2984', '1078', '1', 'New South Wales', 'AU.02', 'NULL', '1107');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1107', '112', '2984', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AU.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2985', '1078', '1', 'Northern Territory', 'AU.03', 'NULL', '1108');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1108', '112', '2985', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AU.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2986', '1078', '1', 'Queensland', 'AU.04', 'NULL', '1109');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1109', '112', '2986', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AU.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2987', '1078', '1', 'South Australia', 'AU.05', 'NULL', '1110');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1110', '112', '2987', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AU.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2988', '1078', '1', 'Tasmania', 'AU.06', 'NULL', '1111');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1111', '112', '2988', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AU.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2989', '1078', '1', 'Victoria', 'AU.07', 'NULL', '1112');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1112', '112', '2989', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AU.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2990', '1078', '1', 'Western Australia', 'AU.08', 'NULL', '1113');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1113', '112', '2990', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AU.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2991', '1078', '1', 'Aruba (general)', 'AW.00', 'NULL', '1114');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1114', '112', '2991', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AW.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2992', '1078', '1', 'Azerbaijan (general)', 'AZ.00', 'NULL', '1115');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1115', '112', '2992', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2993', '1078', '1', 'Abşeron', 'AZ.01', 'NULL', '1116');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1116', '112', '2993', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2994', '1078', '1', 'Ağcabǝdi', 'AZ.02', 'NULL', '1117');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1117', '112', '2994', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2995', '1078', '1', 'Ağdam', 'AZ.03', 'NULL', '1118');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1118', '112', '2995', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2996', '1078', '1', 'Ağdaş', 'AZ.04', 'NULL', '1119');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1119', '112', '2996', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2997', '1078', '1', 'Ağstafa', 'AZ.05', 'NULL', '1120');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1120', '112', '2997', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2998', '1078', '1', 'Ağsu', 'AZ.06', 'NULL', '1121');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1121', '112', '2998', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('2999', '1078', '1', 'Əli Bayramli', 'AZ.07', 'NULL', '1122');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1122', '112', '2999', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3000', '1078', '1', 'Astara', 'AZ.08', 'NULL', '1123');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1123', '112', '3000', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3001', '1078', '1', 'Baki', 'AZ.09', 'NULL', '1124');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1124', '112', '3001', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.09» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3002', '1078', '1', 'Balakǝn', 'AZ.10', 'NULL', '1125');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1125', '112', '3002', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.10» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3003', '1078', '1', 'Bǝrdǝ', 'AZ.11', 'NULL', '1126');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1126', '112', '3003', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.11» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3004', '1078', '1', 'Beylǝqan', 'AZ.12', 'NULL', '1127');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1127', '112', '3004', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.12» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3005', '1078', '1', 'Bilǝsuvar', 'AZ.13', 'NULL', '1128');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1128', '112', '3005', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.13» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3006', '1078', '1', 'Cǝbrayıl', 'AZ.14', 'NULL', '1129');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1129', '112', '3006', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.14» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3007', '1078', '1', 'Cǝlilabad', 'AZ.15', 'NULL', '1130');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1130', '112', '3007', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.15» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3008', '1078', '1', 'Daşkǝsǝn', 'AZ.16', 'NULL', '1131');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1131', '112', '3008', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.16» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3009', '1078', '1', 'Dǝvǝçi', 'AZ.17', 'NULL', '1132');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1132', '112', '3009', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.17» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3010', '1078', '1', 'Füzuli', 'AZ.18', 'NULL', '1133');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1133', '112', '3010', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.18» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3011', '1078', '1', 'Gǝdǝbǝy', 'AZ.19', 'NULL', '1134');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1134', '112', '3011', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.19» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3012', '1078', '1', 'Gǝncǝ', 'AZ.20', 'NULL', '1135');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1135', '112', '3012', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.20» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3013', '1078', '1', 'Goranboy', 'AZ.21', 'NULL', '1136');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1136', '112', '3013', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.21» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3014', '1078', '1', 'Göyçay', 'AZ.22', 'NULL', '1137');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1137', '112', '3014', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.22» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3015', '1078', '1', 'Hacıqabul', 'AZ.23', 'NULL', '1138');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1138', '112', '3015', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.23» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3016', '1078', '1', 'İmişli', 'AZ.24', 'NULL', '1139');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1139', '112', '3016', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.24» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3017', '1078', '1', 'İsmayıllı', 'AZ.25', 'NULL', '1140');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1140', '112', '3017', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.25» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3018', '1078', '1', 'Kǝlbǝcǝr', 'AZ.26', 'NULL', '1141');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1141', '112', '3018', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.26» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3019', '1078', '1', 'Kürdǝmir', 'AZ.27', 'NULL', '1142');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1142', '112', '3019', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.27» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3020', '1078', '1', 'Laçın', 'AZ.28', 'NULL', '1143');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1143', '112', '3020', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.28» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3021', '1078', '1', 'Lǝnkǝran', 'AZ.29', 'NULL', '1144');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1144', '112', '3021', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.29» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3022', '1078', '1', 'Lǝnkǝran Şǝhǝri', 'AZ.30', 'NULL', '1145');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1145', '112', '3022', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.30» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3023', '1078', '1', 'Lerik', 'AZ.31', 'NULL', '1146');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1146', '112', '3023', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.31» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3024', '1078', '1', 'Masallı', 'AZ.32', 'NULL', '1147');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1147', '112', '3024', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.32» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3025', '1078', '1', 'Mingǝcevir', 'AZ.33', 'NULL', '1148');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1148', '112', '3025', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.33» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3026', '1078', '1', 'Naftalan', 'AZ.34', 'NULL', '1149');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1149', '112', '3026', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.34» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3027', '1078', '1', 'Nakhichevan', 'AZ.35', 'NULL', '1150');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1150', '112', '3027', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.35» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3028', '1078', '1', 'Neftçala', 'AZ.36', 'NULL', '1151');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1151', '112', '3028', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.36» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3029', '1078', '1', 'Oğuz', 'AZ.37', 'NULL', '1152');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1152', '112', '3029', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.37» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3030', '1078', '1', 'Qǝbǝlǝ', 'AZ.38', 'NULL', '1153');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1153', '112', '3030', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.38» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3031', '1078', '1', 'Qǝx', 'AZ.39', 'NULL', '1154');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1154', '112', '3031', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.39» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3032', '1078', '1', 'Qazax', 'AZ.40', 'NULL', '1155');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1155', '112', '3032', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.40» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3033', '1078', '1', 'Qobustan', 'AZ.41', 'NULL', '1156');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1156', '112', '3033', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.41» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3034', '1078', '1', 'Quba', 'AZ.42', 'NULL', '1157');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1157', '112', '3034', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.42» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3035', '1078', '1', 'Qubadlı', 'AZ.43', 'NULL', '1158');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1158', '112', '3035', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.43» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3036', '1078', '1', 'Qusar', 'AZ.44', 'NULL', '1159');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1159', '112', '3036', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.44» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3037', '1078', '1', 'Saatlı', 'AZ.45', 'NULL', '1160');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1160', '112', '3037', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.45» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3038', '1078', '1', 'Sabirabad', 'AZ.46', 'NULL', '1161');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1161', '112', '3038', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.46» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3039', '1078', '1', 'Şǝki', 'AZ.47', 'NULL', '1162');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1162', '112', '3039', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.47» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3040', '1078', '1', 'Şǝki', 'AZ.48', 'NULL', '1163');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1163', '112', '3040', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.48» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3041', '1078', '1', 'Salyan', 'AZ.49', 'NULL', '1164');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1164', '112', '3041', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.49» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3042', '1078', '1', 'Şamaxı', 'AZ.50', 'NULL', '1165');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1165', '112', '3042', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.50» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3043', '1078', '1', 'Şǝmkir', 'AZ.51', 'NULL', '1166');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1166', '112', '3043', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.51» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3044', '1078', '1', 'Samux', 'AZ.52', 'NULL', '1167');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1167', '112', '3044', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.52» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3045', '1078', '1', 'Siyǝzǝn', 'AZ.53', 'NULL', '1168');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1168', '112', '3045', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.53» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3046', '1078', '1', 'Sumqayit', 'AZ.54', 'NULL', '1169');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1169', '112', '3046', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.54» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3047', '1078', '1', 'Şuşa', 'AZ.55', 'NULL', '1170');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1170', '112', '3047', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.55» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3048', '1078', '1', 'Şuşa Şəhəri', 'AZ.56', 'NULL', '1171');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1171', '112', '3048', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.56» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3049', '1078', '1', 'Tǝrtǝr', 'AZ.57', 'NULL', '1172');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1172', '112', '3049', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.57» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3050', '1078', '1', 'Tovuz', 'AZ.58', 'NULL', '1173');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1173', '112', '3050', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.58» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3051', '1078', '1', 'Ucar', 'AZ.59', 'NULL', '1174');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1174', '112', '3051', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.59» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3052', '1078', '1', 'Xaçmaz', 'AZ.60', 'NULL', '1175');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1175', '112', '3052', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.60» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3053', '1078', '1', 'Xankǝndi', 'AZ.61', 'NULL', '1176');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1176', '112', '3053', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.61» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3054', '1078', '1', 'Xanlar', 'AZ.62', 'NULL', '1177');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1177', '112', '3054', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.62» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3055', '1078', '1', 'Xızı', 'AZ.63', 'NULL', '1178');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1178', '112', '3055', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.63» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3056', '1078', '1', 'Xocalı', 'AZ.64', 'NULL', '1179');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1179', '112', '3056', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.64» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3057', '1078', '1', 'Xocavǝnd', 'AZ.65', 'NULL', '1180');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1180', '112', '3057', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.65» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3058', '1078', '1', 'Yardımlı', 'AZ.66', 'NULL', '1181');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1181', '112', '3058', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.66» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3059', '1078', '1', 'Yevlax', 'AZ.67', 'NULL', '1182');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1182', '112', '3059', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.67» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3060', '1078', '1', 'Yevlax', 'AZ.68', 'NULL', '1183');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1183', '112', '3060', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.68» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3061', '1078', '1', 'Zǝngilan', 'AZ.69', 'NULL', '1184');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1184', '112', '3061', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.69» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3062', '1078', '1', 'Zaqatala', 'AZ.70', 'NULL', '1185');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1185', '112', '3062', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.70» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3063', '1078', '1', 'Zǝrdab', 'AZ.71', 'NULL', '1186');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1186', '112', '3063', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «AZ.71» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3064', '1078', '1', 'Bosnia and Herzegovina (general)', 'BA.00', 'NULL', '1187');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1187', '112', '3064', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BA.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3065', '1078', '1', 'Federation of Bosnia and Herzegovina', 'BA.01', 'NULL', '1188');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1188', '112', '3065', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BA.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3066', '1078', '1', 'Republika Srpska', 'BA.02', 'NULL', '1189');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1189', '112', '3066', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BA.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3067', '1078', '1', 'Brčko Distrikt', 'BA.BD', 'NULL', '1190');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1190', '112', '3067', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BA.BD» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3068', '1078', '1', 'Barbados (general)', 'BB.00', 'NULL', '1191');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1191', '112', '3068', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BB.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3069', '1078', '1', 'Christ Church', 'BB.01', 'NULL', '1192');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1192', '112', '3069', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BB.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3070', '1078', '1', 'Saint Andrew', 'BB.02', 'NULL', '1193');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1193', '112', '3070', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BB.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3071', '1078', '1', 'Saint George', 'BB.03', 'NULL', '1194');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1194', '112', '3071', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BB.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3072', '1078', '1', 'Saint James', 'BB.04', 'NULL', '1195');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1195', '112', '3072', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BB.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3073', '1078', '1', 'Saint John', 'BB.05', 'NULL', '1196');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1196', '112', '3073', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BB.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3074', '1078', '1', 'Saint Joseph', 'BB.06', 'NULL', '1197');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1197', '112', '3074', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BB.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3075', '1078', '1', 'Saint Lucy', 'BB.07', 'NULL', '1198');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1198', '112', '3075', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BB.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3076', '1078', '1', 'Saint Michael', 'BB.08', 'NULL', '1199');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1199', '112', '3076', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BB.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3077', '1078', '1', 'Saint Peter', 'BB.09', 'NULL', '1200');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1200', '112', '3077', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BB.09» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3078', '1078', '1', 'Saint Philip', 'BB.10', 'NULL', '1201');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1201', '112', '3078', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BB.10» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3079', '1078', '1', 'Saint Thomas', 'BB.11', 'NULL', '1202');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1202', '112', '3079', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BB.11» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3080', '1078', '1', 'Bangladesh (general)', 'BD.00', 'NULL', '1203');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1203', '112', '3080', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BD.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3081', '1078', '1', 'BG80', 'BD.80', 'NULL', '1204');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1204', '112', '3081', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BD.80» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3082', '1078', '1', 'Dhaka', 'BD.81', 'NULL', '1205');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1205', '112', '3082', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BD.81» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3083', '1078', '1', 'Khulna', 'BD.82', 'NULL', '1206');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1206', '112', '3083', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BD.82» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3084', '1078', '1', 'Rājshāhi', 'BD.83', 'NULL', '1207');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1207', '112', '3084', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BD.83» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3085', '1078', '1', 'Chittagong', 'BD.84', 'NULL', '1208');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1208', '112', '3085', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BD.84» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3086', '1078', '1', 'Barisāl', 'BD.85', 'NULL', '1209');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1209', '112', '3086', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BD.85» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3087', '1078', '1', 'Sylhet', 'BD.86', 'NULL', '1210');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1210', '112', '3087', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BD.86» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3088', '1078', '1', 'Belgium (general)', 'BE.00', 'NULL', '1211');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1211', '112', '3088', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BE.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3089', '1078', '1', 'Région de Bruxelles-Capitale', 'BE.BRU', 'NULL', '1212');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1212', '112', '3089', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BE.BRU» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3090', '1078', '1', 'Flanders', 'BE.VLG', 'NULL', '1213');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1213', '112', '3090', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BE.VLG» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3091', '1078', '1', 'Wallonia', 'BE.WAL', 'NULL', '1214');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1214', '112', '3091', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BE.WAL» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3092', '1078', '1', 'Burkina Faso (general)', 'BF.00', 'NULL', '1215');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1215', '112', '3092', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3093', '1078', '1', 'Boucle du Mouhoun', 'BF.01', 'NULL', '1216');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1216', '112', '3093', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3094', '1078', '1', 'Cascades', 'BF.02', 'NULL', '1217');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1217', '112', '3094', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3095', '1078', '1', 'Centre', 'BF.03', 'NULL', '1218');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1218', '112', '3095', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3096', '1078', '1', 'Centre-Est', 'BF.04', 'NULL', '1219');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1219', '112', '3096', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3097', '1078', '1', 'Centre-Nord', 'BF.05', 'NULL', '1220');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1220', '112', '3097', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3098', '1078', '1', 'Centre-Ouest', 'BF.06', 'NULL', '1221');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1221', '112', '3098', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3099', '1078', '1', 'Centre-Sud', 'BF.07', 'NULL', '1222');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1222', '112', '3099', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3100', '1078', '1', 'Est', 'BF.08', 'NULL', '1223');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1223', '112', '3100', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3101', '1078', '1', 'Hauts-Bassins', 'BF.09', 'NULL', '1224');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1224', '112', '3101', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.09» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3102', '1078', '1', 'Nord', 'BF.10', 'NULL', '1225');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1225', '112', '3102', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.10» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3103', '1078', '1', 'Plateau-Central', 'BF.11', 'NULL', '1226');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1226', '112', '3103', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.11» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3104', '1078', '1', 'Sahel', 'BF.12', 'NULL', '1227');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1227', '112', '3104', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.12» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3105', '1078', '1', 'Sud-Ouest', 'BF.13', 'NULL', '1228');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1228', '112', '3105', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.13» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3106', '1078', '1', 'Bam', 'BF.15', 'NULL', '1229');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1229', '112', '3106', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.15» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3107', '1078', '1', 'Boulkiemdé', 'BF.19', 'NULL', '1230');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1230', '112', '3107', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.19» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3108', '1078', '1', 'Ganzourgou', 'BF.20', 'NULL', '1231');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1231', '112', '3108', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.20» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3109', '1078', '1', 'Gnagna', 'BF.21', 'NULL', '1232');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1232', '112', '3109', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.21» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3110', '1078', '1', 'Kouritenga', 'BF.28', 'NULL', '1233');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1233', '112', '3110', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.28» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3111', '1078', '1', 'Oudalan', 'BF.33', 'NULL', '1234');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1234', '112', '3111', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.33» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3112', '1078', '1', 'Passore', 'BF.34', 'NULL', '1235');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1235', '112', '3112', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.34» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3113', '1078', '1', 'Sanguié', 'BF.36', 'NULL', '1236');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1236', '112', '3113', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.36» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3114', '1078', '1', '(UV37)', 'BF.37', 'NULL', '1237');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1237', '112', '3114', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.37» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3115', '1078', '1', '(UV38)', 'BF.38', 'NULL', '1238');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1238', '112', '3115', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.38» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3116', '1078', '1', '(UV39)', 'BF.39', 'NULL', '1239');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1239', '112', '3116', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.39» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3117', '1078', '1', 'Soum', 'BF.40', 'NULL', '1240');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1240', '112', '3117', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.40» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3118', '1078', '1', '(UV41)', 'BF.41', 'NULL', '1241');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1241', '112', '3118', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.41» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3119', '1078', '1', 'Tapoa', 'BF.42', 'NULL', '1242');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1242', '112', '3119', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.42» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3120', '1078', '1', '(UV43)', 'BF.43', 'NULL', '1243');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1243', '112', '3120', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.43» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3121', '1078', '1', 'Zoundwéogo', 'BF.44', 'NULL', '1244');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1244', '112', '3121', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.44» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3122', '1078', '1', 'Banwa', 'BF.46', 'NULL', '1245');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1245', '112', '3122', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.46» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3123', '1078', '1', 'Bazèga', 'BF.47', 'NULL', '1246');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1246', '112', '3123', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.47» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3124', '1078', '1', 'Bougouriba', 'BF.48', 'NULL', '1247');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1247', '112', '3124', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.48» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3125', '1078', '1', 'Boulgou', 'BF.49', 'NULL', '1248');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1248', '112', '3125', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.49» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3126', '1078', '1', 'Gourma', 'BF.50', 'NULL', '1249');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1249', '112', '3126', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.50» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3127', '1078', '1', 'Houet', 'BF.51', 'NULL', '1250');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1250', '112', '3127', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.51» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3128', '1078', '1', 'Ioba', 'BF.52', 'NULL', '1251');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1251', '112', '3128', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.52» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3129', '1078', '1', 'Kadiogo', 'BF.53', 'NULL', '1252');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1252', '112', '3129', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.53» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3130', '1078', '1', 'Kènèdougou', 'BF.54', 'NULL', '1253');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1253', '112', '3130', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.54» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3131', '1078', '1', 'Comoé', 'BF.55', 'NULL', '1254');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1254', '112', '3131', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.55» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3132', '1078', '1', 'Komondjari', 'BF.56', 'NULL', '1255');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1255', '112', '3132', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.56» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3133', '1078', '1', 'Kompienga', 'BF.57', 'NULL', '1256');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1256', '112', '3133', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.57» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3134', '1078', '1', 'Kossi', 'BF.58', 'NULL', '1257');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1257', '112', '3134', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.58» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3135', '1078', '1', 'Koulpélogo', 'BF.59', 'NULL', '1258');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1258', '112', '3135', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.59» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3136', '1078', '1', 'Kourwéogo', 'BF.60', 'NULL', '1259');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1259', '112', '3136', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.60» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3137', '1078', '1', 'Léraba', 'BF.61', 'NULL', '1260');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1260', '112', '3137', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.61» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3138', '1078', '1', 'Loroum', 'BF.62', 'NULL', '1261');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1261', '112', '3138', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.62» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3139', '1078', '1', 'Mouhoun', 'BF.63', 'NULL', '1262');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1262', '112', '3139', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.63» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3140', '1078', '1', 'Namentenga', 'BF.64', 'NULL', '1263');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1263', '112', '3140', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.64» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3141', '1078', '1', 'Nahouri', 'BF.65', 'NULL', '1264');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1264', '112', '3141', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.65» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3142', '1078', '1', 'Nayala', 'BF.66', 'NULL', '1265');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1265', '112', '3142', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.66» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3143', '1078', '1', 'Noumbiel', 'BF.67', 'NULL', '1266');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1266', '112', '3143', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.67» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3144', '1078', '1', 'Oubritenga', 'BF.68', 'NULL', '1267');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1267', '112', '3144', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.68» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3145', '1078', '1', 'Poni', 'BF.69', 'NULL', '1268');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1268', '112', '3145', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.69» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3146', '1078', '1', 'Sanmatenga', 'BF.70', 'NULL', '1269');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1269', '112', '3146', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.70» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3147', '1078', '1', 'Séno', 'BF.71', 'NULL', '1270');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1270', '112', '3147', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.71» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3148', '1078', '1', 'Sissili', 'BF.72', 'NULL', '1271');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1271', '112', '3148', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.72» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3149', '1078', '1', 'Sourou', 'BF.73', 'NULL', '1272');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1272', '112', '3149', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.73» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3150', '1078', '1', 'Tuy', 'BF.74', 'NULL', '1273');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1273', '112', '3150', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.74» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3151', '1078', '1', 'Yagha', 'BF.75', 'NULL', '1274');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1274', '112', '3151', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.75» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3152', '1078', '1', 'Yatenga', 'BF.76', 'NULL', '1275');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1275', '112', '3152', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.76» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3153', '1078', '1', 'Ziro', 'BF.77', 'NULL', '1276');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1276', '112', '3153', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.77» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3154', '1078', '1', 'Zondoma', 'BF.78', 'NULL', '1277');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1277', '112', '3154', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BF.78» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3155', '1078', '1', 'Bulgaria (general)', 'BG.00', 'NULL', '1278');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1278', '112', '3155', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3156', '1078', '1', 'Burgas', 'BG.29', 'NULL', '1279');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1279', '112', '3156', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.29» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3157', '1078', '1', 'Grad', 'BG.30', 'NULL', '1280');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1280', '112', '3157', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.30» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3158', '1078', '1', 'Khaskovo', 'BG.31', 'NULL', '1281');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1281', '112', '3158', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.31» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3159', '1078', '1', 'Lovech', 'BG.32', 'NULL', '1282');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1282', '112', '3159', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.32» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3160', '1078', '1', 'Mikhaylovgrad', 'BG.33', 'NULL', '1283');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1283', '112', '3160', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.33» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3161', '1078', '1', 'Plovdiv', 'BG.34', 'NULL', '1284');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1284', '112', '3161', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.34» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3162', '1078', '1', 'Razgrad', 'BG.35', 'NULL', '1285');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1285', '112', '3162', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.35» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3163', '1078', '1', 'Sofiya', 'BG.36', 'NULL', '1286');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1286', '112', '3163', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.36» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3164', '1078', '1', 'Varna', 'BG.37', 'NULL', '1287');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1287', '112', '3164', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.37» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3165', '1078', '1', 'Blagoevgrad', 'BG.38', 'NULL', '1288');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1288', '112', '3165', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.38» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3166', '1078', '1', 'Burgas', 'BG.39', 'NULL', '1289');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1289', '112', '3166', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.39» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3167', '1078', '1', 'Dobrich', 'BG.40', 'NULL', '1290');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1290', '112', '3167', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.40» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3168', '1078', '1', 'Gabrovo', 'BG.41', 'NULL', '1291');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1291', '112', '3168', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.41» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3169', '1078', '1', 'Oblast Sofiya-Grad', 'BG.42', 'NULL', '1292');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1292', '112', '3169', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.42» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3170', '1078', '1', 'Khaskovo', 'BG.43', 'NULL', '1293');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1293', '112', '3170', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.43» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3171', '1078', '1', 'Kŭrdzhali', 'BG.44', 'NULL', '1294');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1294', '112', '3171', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.44» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3172', '1078', '1', 'Kyustendil', 'BG.45', 'NULL', '1295');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1295', '112', '3172', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.45» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3173', '1078', '1', 'Lovech', 'BG.46', 'NULL', '1296');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1296', '112', '3173', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.46» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3174', '1078', '1', 'Montana', 'BG.47', 'NULL', '1297');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1297', '112', '3174', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.47» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3175', '1078', '1', 'Pazardzhit', 'BG.48', 'NULL', '1298');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1298', '112', '3175', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.48» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3176', '1078', '1', 'Pernik', 'BG.49', 'NULL', '1299');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1299', '112', '3176', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.49» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3177', '1078', '1', 'Pleven', 'BG.50', 'NULL', '1300');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1300', '112', '3177', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.50» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3178', '1078', '1', 'Plovdiv', 'BG.51', 'NULL', '1301');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1301', '112', '3178', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.51» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3179', '1078', '1', 'Razgrad', 'BG.52', 'NULL', '1302');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1302', '112', '3179', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.52» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3180', '1078', '1', 'Ruse', 'BG.53', 'NULL', '1303');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1303', '112', '3180', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.53» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3181', '1078', '1', 'Shumen', 'BG.54', 'NULL', '1304');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1304', '112', '3181', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.54» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3182', '1078', '1', 'Silistra', 'BG.55', 'NULL', '1305');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1305', '112', '3182', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.55» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3183', '1078', '1', 'Sliven', 'BG.56', 'NULL', '1306');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1306', '112', '3183', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.56» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3184', '1078', '1', 'Smolyan', 'BG.57', 'NULL', '1307');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1307', '112', '3184', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.57» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3185', '1078', '1', 'Sofiya', 'BG.58', 'NULL', '1308');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1308', '112', '3185', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.58» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3186', '1078', '1', 'Stara Zagora', 'BG.59', 'NULL', '1309');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1309', '112', '3186', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.59» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3187', '1078', '1', 'Tŭrgovishte', 'BG.60', 'NULL', '1310');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1310', '112', '3187', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.60» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3188', '1078', '1', 'Varna', 'BG.61', 'NULL', '1311');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1311', '112', '3188', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.61» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3189', '1078', '1', 'Veliko Tŭrnovo', 'BG.62', 'NULL', '1312');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1312', '112', '3189', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.62» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3190', '1078', '1', 'Vidin', 'BG.63', 'NULL', '1313');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1313', '112', '3190', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.63» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3191', '1078', '1', 'Vratsa', 'BG.64', 'NULL', '1314');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1314', '112', '3191', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.64» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3192', '1078', '1', 'Yambol', 'BG.65', 'NULL', '1315');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1315', '112', '3192', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BG.65» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3193', '1078', '1', 'Bahrain (general)', 'BH.00', 'NULL', '1316');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1316', '112', '3193', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BH.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3194', '1078', '1', 'Hedd', 'BH.01', 'NULL', '1317');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1317', '112', '3194', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BH.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3195', '1078', '1', 'Manama', 'BH.02', 'NULL', '1318');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1318', '112', '3195', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BH.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3196', '1078', '1', 'Muharraq', 'BH.03', 'NULL', '1319');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1319', '112', '3196', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BH.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3197', '1078', '1', 'Jidd Haffs', 'BH.05', 'NULL', '1320');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1320', '112', '3197', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BH.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3198', '1078', '1', 'Sitra', 'BH.06', 'NULL', '1321');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1321', '112', '3198', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BH.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3199', '1078', '1', '(BA07)', 'BH.07', 'NULL', '1322');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1322', '112', '3199', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BH.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3200', '1078', '1', 'Western Region', 'BH.08', 'NULL', '1323');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1323', '112', '3200', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BH.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3201', '1078', '1', 'Hawar Islands', 'BH.09', 'NULL', '1324');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1324', '112', '3201', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BH.09» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3202', '1078', '1', 'Northern Region', 'BH.10', 'NULL', '1325');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1325', '112', '3202', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BH.10» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3203', '1078', '1', 'Central Region', 'BH.11', 'NULL', '1326');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1326', '112', '3203', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BH.11» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3204', '1078', '1', 'Isa Town', 'BH.12', 'NULL', '1327');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1327', '112', '3204', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BH.12» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3205', '1078', '1', 'Ar Rifa’ and Southern Region', 'BH.13', 'NULL', '1328');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1328', '112', '3205', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BH.13» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3206', '1078', '1', 'Hamad town', 'BH.14', 'NULL', '1329');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1329', '112', '3206', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BH.14» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3207', '1078', '1', 'Burundi (general)', 'BI.00', 'NULL', '1330');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1330', '112', '3207', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BI.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3208', '1078', '1', 'Bujumbura', 'BI.02', 'NULL', '1331');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1331', '112', '3208', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BI.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3209', '1078', '1', '(BY05)', 'BI.05', 'NULL', '1332');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1332', '112', '3209', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BI.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3210', '1078', '1', 'Bubanza', 'BI.09', 'NULL', '1333');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1333', '112', '3210', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BI.09» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3211', '1078', '1', 'Bururi', 'BI.10', 'NULL', '1334');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1334', '112', '3211', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BI.10» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3212', '1078', '1', 'Cankuzo', 'BI.11', 'NULL', '1335');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1335', '112', '3212', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BI.11» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3213', '1078', '1', 'Cibitoke', 'BI.12', 'NULL', '1336');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1336', '112', '3213', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BI.12» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3214', '1078', '1', 'Gitega', 'BI.13', 'NULL', '1337');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1337', '112', '3214', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BI.13» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3215', '1078', '1', 'Karuzi', 'BI.14', 'NULL', '1338');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1338', '112', '3215', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BI.14» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3216', '1078', '1', 'Kayanza', 'BI.15', 'NULL', '1339');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1339', '112', '3216', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BI.15» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3217', '1078', '1', 'Kirundo', 'BI.16', 'NULL', '1340');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1340', '112', '3217', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BI.16» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3218', '1078', '1', 'Makamba', 'BI.17', 'NULL', '1341');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1341', '112', '3218', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BI.17» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3219', '1078', '1', 'Muyinga', 'BI.18', 'NULL', '1342');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1342', '112', '3219', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BI.18» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3220', '1078', '1', 'Ngozi', 'BI.19', 'NULL', '1343');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1343', '112', '3220', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BI.19» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3221', '1078', '1', 'Rutana', 'BI.20', 'NULL', '1344');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1344', '112', '3221', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BI.20» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3222', '1078', '1', 'Ruyigi', 'BI.21', 'NULL', '1345');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1345', '112', '3222', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BI.21» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3223', '1078', '1', 'Muramvya', 'BI.22', 'NULL', '1346');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1346', '112', '3223', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BI.22» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3224', '1078', '1', 'Mwaro', 'BI.23', 'NULL', '1347');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1347', '112', '3224', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BI.23» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3225', '1078', '1', 'Benin (general)', 'BJ.00', 'NULL', '1348');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1348', '112', '3225', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BJ.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3226', '1078', '1', 'Atakora', 'BJ.01', 'NULL', '1349');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1349', '112', '3226', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BJ.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3227', '1078', '1', 'Atlantique', 'BJ.02', 'NULL', '1350');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1350', '112', '3227', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BJ.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3228', '1078', '1', 'Borgou', 'BJ.03', 'NULL', '1351');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1351', '112', '3228', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BJ.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3229', '1078', '1', 'Mono', 'BJ.04', 'NULL', '1352');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1352', '112', '3229', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BJ.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3230', '1078', '1', 'Oueme', 'BJ.05', 'NULL', '1353');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1353', '112', '3230', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BJ.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3231', '1078', '1', 'Zou', 'BJ.06', 'NULL', '1354');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1354', '112', '3231', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BJ.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3232', '1078', '1', 'Alibori', 'BJ.07', 'NULL', '1355');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1355', '112', '3232', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BJ.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3233', '1078', '1', 'Atakora', 'BJ.08', 'NULL', '1356');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1356', '112', '3233', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BJ.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3234', '1078', '1', 'Atlantique', 'BJ.09', 'NULL', '1357');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1357', '112', '3234', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BJ.09» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3235', '1078', '1', 'Borgou', 'BJ.10', 'NULL', '1358');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1358', '112', '3235', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BJ.10» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3236', '1078', '1', 'Collines', 'BJ.11', 'NULL', '1359');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1359', '112', '3236', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BJ.11» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3237', '1078', '1', 'Kouffo', 'BJ.12', 'NULL', '1360');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1360', '112', '3237', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BJ.12» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3238', '1078', '1', 'Donga', 'BJ.13', 'NULL', '1361');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1361', '112', '3238', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BJ.13» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3239', '1078', '1', 'Littoral', 'BJ.14', 'NULL', '1362');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1362', '112', '3239', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BJ.14» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3240', '1078', '1', 'Mono', 'BJ.15', 'NULL', '1363');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1363', '112', '3240', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BJ.15» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3241', '1078', '1', 'Quémé', 'BJ.16', 'NULL', '1364');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1364', '112', '3241', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BJ.16» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3242', '1078', '1', 'Plateau', 'BJ.17', 'NULL', '1365');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1365', '112', '3242', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BJ.17» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3243', '1078', '1', 'Zou', 'BJ.18', 'NULL', '1366');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1366', '112', '3243', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BJ.18» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3244', '1078', '1', 'Bermuda (general)', 'BM.00', 'NULL', '1367');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1367', '112', '3244', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BM.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3245', '1078', '1', 'Devonshire', 'BM.01', 'NULL', '1368');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1368', '112', '3245', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BM.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3246', '1078', '1', 'Hamilton Parish', 'BM.02', 'NULL', '1369');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1369', '112', '3246', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BM.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3247', '1078', '1', 'Hamilton city', 'BM.03', 'NULL', '1370');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1370', '112', '3247', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BM.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3248', '1078', '1', 'Paget', 'BM.04', 'NULL', '1371');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1371', '112', '3248', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BM.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3249', '1078', '1', 'Pembroke', 'BM.05', 'NULL', '1372');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1372', '112', '3249', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BM.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3250', '1078', '1', 'Saint George', 'BM.06', 'NULL', '1373');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1373', '112', '3250', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BM.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3251', '1078', '1', 'Saint Georgeʼs', 'BM.07', 'NULL', '1374');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1374', '112', '3251', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BM.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3252', '1078', '1', 'Sandys', 'BM.08', 'NULL', '1375');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1375', '112', '3252', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BM.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3253', '1078', '1', 'Smithʼs', 'BM.09', 'NULL', '1376');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1376', '112', '3253', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BM.09» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3254', '1078', '1', 'Southampton', 'BM.10', 'NULL', '1377');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1377', '112', '3254', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BM.10» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3255', '1078', '1', 'Warwick', 'BM.11', 'NULL', '1378');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1378', '112', '3255', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BM.11» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3256', '1078', '1', 'Brunei (general)', 'BN.00', 'NULL', '1379');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1379', '112', '3256', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BN.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3257', '1078', '1', 'Belait', 'BN.01', 'NULL', '1380');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1380', '112', '3257', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BN.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3258', '1078', '1', 'Brunei and Muara', 'BN.02', 'NULL', '1381');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1381', '112', '3258', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BN.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3259', '1078', '1', 'Temburong', 'BN.03', 'NULL', '1382');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1382', '112', '3259', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BN.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3260', '1078', '1', 'Tutong', 'BN.04', 'NULL', '1383');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1383', '112', '3260', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BN.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3261', '1078', '1', 'Bolivia (general)', 'BO.00', 'NULL', '1384');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1384', '112', '3261', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BO.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3262', '1078', '1', 'Chuquisaca', 'BO.01', 'NULL', '1385');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1385', '112', '3262', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BO.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3263', '1078', '1', 'Cochabamba', 'BO.02', 'NULL', '1386');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1386', '112', '3263', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BO.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3264', '1078', '1', 'El Beni', 'BO.03', 'NULL', '1387');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1387', '112', '3264', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BO.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3265', '1078', '1', 'La Paz', 'BO.04', 'NULL', '1388');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1388', '112', '3265', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BO.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3266', '1078', '1', 'Oruro', 'BO.05', 'NULL', '1389');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1389', '112', '3266', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BO.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3267', '1078', '1', 'Pando', 'BO.06', 'NULL', '1390');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1390', '112', '3267', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BO.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3268', '1078', '1', 'Potosí', 'BO.07', 'NULL', '1391');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1391', '112', '3268', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BO.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3269', '1078', '1', 'Santa Cruz', 'BO.08', 'NULL', '1392');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1392', '112', '3269', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BO.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3270', '1078', '1', 'Tarija', 'BO.09', 'NULL', '1393');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1393', '112', '3270', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BO.09» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3271', '1078', '1', 'Brazil (general)', 'BR.00', 'NULL', '1394');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1394', '112', '3271', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3272', '1078', '1', 'Acre', 'BR.01', 'NULL', '1395');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1395', '112', '3272', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3273', '1078', '1', 'Alagoas', 'BR.02', 'NULL', '1396');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1396', '112', '3273', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3274', '1078', '1', 'Amapá', 'BR.03', 'NULL', '1397');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1397', '112', '3274', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3275', '1078', '1', 'Estado do Amazonas', 'BR.04', 'NULL', '1398');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1398', '112', '3275', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3276', '1078', '1', 'Bahia', 'BR.05', 'NULL', '1399');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1399', '112', '3276', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3277', '1078', '1', 'Ceará', 'BR.06', 'NULL', '1400');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1400', '112', '3277', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3278', '1078', '1', 'Distrito Federal', 'BR.07', 'NULL', '1401');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1401', '112', '3278', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3279', '1078', '1', 'Espírito Santo', 'BR.08', 'NULL', '1402');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1402', '112', '3279', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3280', '1078', '1', 'Fernando de Noronha', 'BR.09', 'NULL', '1403');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1403', '112', '3280', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.09» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3281', '1078', '1', 'Goias', 'BR.10', 'NULL', '1404');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1404', '112', '3281', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.10» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3282', '1078', '1', 'Mato Grosso do Sul', 'BR.11', 'NULL', '1405');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1405', '112', '3282', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.11» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3283', '1078', '1', 'Maranhão', 'BR.13', 'NULL', '1406');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1406', '112', '3283', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.13» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3284', '1078', '1', 'Mato Grosso', 'BR.14', 'NULL', '1407');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1407', '112', '3284', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.14» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3285', '1078', '1', 'Minas Gerais', 'BR.15', 'NULL', '1408');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1408', '112', '3285', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.15» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3286', '1078', '1', 'Pará', 'BR.16', 'NULL', '1409');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1409', '112', '3286', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.16» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3287', '1078', '1', 'Paraíba', 'BR.17', 'NULL', '1410');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1410', '112', '3287', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.17» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3288', '1078', '1', 'Paraná', 'BR.18', 'NULL', '1411');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1411', '112', '3288', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.18» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3289', '1078', '1', 'Pernambuco', 'BR.19', 'NULL', '1412');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1412', '112', '3289', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.19» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3290', '1078', '1', 'Piauí', 'BR.20', 'NULL', '1413');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1413', '112', '3290', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.20» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3291', '1078', '1', 'Rio de Janeiro', 'BR.21', 'NULL', '1414');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1414', '112', '3291', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.21» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3292', '1078', '1', 'Rio Grande do Norte', 'BR.22', 'NULL', '1415');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1415', '112', '3292', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.22» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3293', '1078', '1', 'Rio Grande do Sul', 'BR.23', 'NULL', '1416');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1416', '112', '3293', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.23» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3294', '1078', '1', 'Rondônia', 'BR.24', 'NULL', '1417');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1417', '112', '3294', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.24» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3295', '1078', '1', 'Roraima', 'BR.25', 'NULL', '1418');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1418', '112', '3295', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.25» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3296', '1078', '1', 'Santa Catarina', 'BR.26', 'NULL', '1419');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1419', '112', '3296', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.26» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3297', '1078', '1', 'São Paulo', 'BR.27', 'NULL', '1420');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1420', '112', '3297', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.27» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3298', '1078', '1', 'Sergipe', 'BR.28', 'NULL', '1421');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1421', '112', '3298', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.28» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3299', '1078', '1', 'Estado de Goiás', 'BR.29', 'NULL', '1422');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1422', '112', '3299', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.29» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3300', '1078', '1', 'Pernambuco', 'BR.30', 'NULL', '1423');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1423', '112', '3300', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.30» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3301', '1078', '1', 'Tocantins', 'BR.31', 'NULL', '1424');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1424', '112', '3301', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BR.31» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3302', '1078', '1', 'Bahamas, The (general)', 'BS.00', 'NULL', '1425');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1425', '112', '3302', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3303', '1078', '1', 'Bimini', 'BS.05', 'NULL', '1426');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1426', '112', '3303', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3304', '1078', '1', 'Cat Island', 'BS.06', 'NULL', '1427');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1427', '112', '3304', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3305', '1078', '1', 'Exuma', 'BS.10', 'NULL', '1428');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1428', '112', '3305', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.10» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3306', '1078', '1', 'Inagua', 'BS.13', 'NULL', '1429');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1429', '112', '3306', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.13» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3307', '1078', '1', 'Long Island', 'BS.15', 'NULL', '1430');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1430', '112', '3307', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.15» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3308', '1078', '1', 'Mayaguana', 'BS.16', 'NULL', '1431');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1431', '112', '3308', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.16» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3309', '1078', '1', 'Ragged Island', 'BS.18', 'NULL', '1432');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1432', '112', '3309', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.18» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3310', '1078', '1', 'Harbour Island', 'BS.22', 'NULL', '1433');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1433', '112', '3310', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.22» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3311', '1078', '1', 'New Providence', 'BS.23', 'NULL', '1434');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1434', '112', '3311', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.23» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3312', '1078', '1', 'Acklins and Crooked Islands', 'BS.24', 'NULL', '1435');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1435', '112', '3312', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.24» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3313', '1078', '1', 'Freeport', 'BS.25', 'NULL', '1436');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1436', '112', '3313', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.25» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3314', '1078', '1', 'Fresh Creek', 'BS.26', 'NULL', '1437');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1437', '112', '3314', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.26» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3315', '1078', '1', 'Governorʼs Harbour', 'BS.27', 'NULL', '1438');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1438', '112', '3315', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.27» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3316', '1078', '1', 'Green Turtle Cay', 'BS.28', 'NULL', '1439');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1439', '112', '3316', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.28» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3317', '1078', '1', 'High Rock', 'BS.29', 'NULL', '1440');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1440', '112', '3317', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.29» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3318', '1078', '1', 'Kemps Bay', 'BS.30', 'NULL', '1441');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1441', '112', '3318', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.30» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3319', '1078', '1', 'Marsh Harbour', 'BS.31', 'NULL', '1442');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1442', '112', '3319', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.31» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3320', '1078', '1', 'Nichollstown and Berry Islands', 'BS.32', 'NULL', '1443');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1443', '112', '3320', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.32» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3321', '1078', '1', 'Rock Sound', 'BS.33', 'NULL', '1444');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1444', '112', '3321', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.33» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3322', '1078', '1', 'Sandy Point', 'BS.34', 'NULL', '1445');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1445', '112', '3322', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.34» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3323', '1078', '1', 'San Salvador and Rum Cay', 'BS.35', 'NULL', '1446');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1446', '112', '3323', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BS.35» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3324', '1078', '1', 'Bhutan (general)', 'BT.00', 'NULL', '1447');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1447', '112', '3324', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BT.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3325', '1078', '1', 'Bumthang', 'BT.05', 'NULL', '1448');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1448', '112', '3325', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BT.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3326', '1078', '1', 'Chhukha', 'BT.06', 'NULL', '1449');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1449', '112', '3326', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BT.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3327', '1078', '1', 'Chirang', 'BT.07', 'NULL', '1450');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1450', '112', '3327', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BT.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3328', '1078', '1', 'Daga', 'BT.08', 'NULL', '1451');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1451', '112', '3328', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BT.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3329', '1078', '1', 'Geylegphug', 'BT.09', 'NULL', '1452');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1452', '112', '3329', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BT.09» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3330', '1078', '1', 'Ha', 'BT.10', 'NULL', '1453');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1453', '112', '3330', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BT.10» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3331', '1078', '1', 'Lhuntshi', 'BT.11', 'NULL', '1454');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1454', '112', '3331', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BT.11» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3332', '1078', '1', 'Mongar', 'BT.12', 'NULL', '1455');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1455', '112', '3332', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BT.12» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3333', '1078', '1', 'Paro District', 'BT.13', 'NULL', '1456');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1456', '112', '3333', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BT.13» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3334', '1078', '1', 'Pemagatsel', 'BT.14', 'NULL', '1457');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1457', '112', '3334', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BT.14» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3335', '1078', '1', 'Samchi', 'BT.16', 'NULL', '1458');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1458', '112', '3335', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BT.16» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3336', '1078', '1', 'Samdrup Jongkhar District', 'BT.17', 'NULL', '1459');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1459', '112', '3336', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BT.17» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3337', '1078', '1', 'Shemgang', 'BT.18', 'NULL', '1460');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1460', '112', '3337', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BT.18» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3338', '1078', '1', 'Tashigang', 'BT.19', 'NULL', '1461');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1461', '112', '3338', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BT.19» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3339', '1078', '1', 'Thimphu', 'BT.20', 'NULL', '1462');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1462', '112', '3339', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BT.20» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3340', '1078', '1', 'Tongsa', 'BT.21', 'NULL', '1463');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1463', '112', '3340', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BT.21» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3341', '1078', '1', 'Wangdi Phodrang', 'BT.22', 'NULL', '1464');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1464', '112', '3341', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BT.22» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3342', '1078', '1', 'Botswana (general)', 'BW.00', 'NULL', '1465');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1465', '112', '3342', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BW.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3343', '1078', '1', 'Central', 'BW.01', 'NULL', '1466');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1466', '112', '3343', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BW.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3344', '1078', '1', 'Chobe', 'BW.02', 'NULL', '1467');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1467', '112', '3344', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BW.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3345', '1078', '1', 'Ghanzi', 'BW.03', 'NULL', '1468');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1468', '112', '3345', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BW.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3346', '1078', '1', 'Kgalagadi', 'BW.04', 'NULL', '1469');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1469', '112', '3346', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BW.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3347', '1078', '1', 'Kgatleng', 'BW.05', 'NULL', '1470');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1470', '112', '3347', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BW.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3348', '1078', '1', 'Kweneng', 'BW.06', 'NULL', '1471');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1471', '112', '3348', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BW.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3349', '1078', '1', 'Ngamiland', 'BW.07', 'NULL', '1472');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1472', '112', '3349', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BW.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3350', '1078', '1', 'North East', 'BW.08', 'NULL', '1473');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1473', '112', '3350', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BW.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3351', '1078', '1', 'South East', 'BW.09', 'NULL', '1474');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1474', '112', '3351', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BW.09» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3352', '1078', '1', 'Southern', 'BW.10', 'NULL', '1475');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1475', '112', '3352', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BW.10» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3353', '1078', '1', 'North West', 'BW.11', 'NULL', '1476');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1476', '112', '3353', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BW.11» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3354', '1078', '1', 'Belarus (general)', 'BY.00', 'NULL', '1477');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1477', '112', '3354', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BY.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3355', '1078', '1', 'Brestskaya Voblastsʼ', 'BY.01', 'NULL', '1478');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1478', '112', '3355', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BY.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3356', '1078', '1', 'Homyelʼskaya Voblastsʼ', 'BY.02', 'NULL', '1479');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1479', '112', '3356', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BY.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3357', '1078', '1', 'Hrodzyenskaya Voblastsʼ', 'BY.03', 'NULL', '1480');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1480', '112', '3357', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BY.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3358', '1078', '1', 'Mahilyowskaya Voblastsʼ', 'BY.04', 'NULL', '1481');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1481', '112', '3358', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BY.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3359', '1078', '1', 'Horad Minsk', 'BY.05', 'NULL', '1482');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1482', '112', '3359', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BY.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3360', '1078', '1', 'Minskaya Voblastsʼ', 'BY.06', 'NULL', '1483');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1483', '112', '3360', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BY.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3361', '1078', '1', 'Vitsyebskaya Voblastsʼ', 'BY.07', 'NULL', '1484');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1484', '112', '3361', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BY.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3362', '1078', '1', 'Belize (general)', 'BZ.00', 'NULL', '1485');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1485', '112', '3362', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BZ.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3363', '1078', '1', 'Belize', 'BZ.01', 'NULL', '1486');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1486', '112', '3363', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BZ.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3364', '1078', '1', 'Cayo', 'BZ.02', 'NULL', '1487');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1487', '112', '3364', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BZ.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3365', '1078', '1', 'Corozal', 'BZ.03', 'NULL', '1488');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1488', '112', '3365', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BZ.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3366', '1078', '1', 'Orange Walk', 'BZ.04', 'NULL', '1489');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1489', '112', '3366', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BZ.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3367', '1078', '1', 'Stann Creek', 'BZ.05', 'NULL', '1490');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1490', '112', '3367', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BZ.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3368', '1078', '1', 'Toledo', 'BZ.06', 'NULL', '1491');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1491', '112', '3368', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «BZ.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3369', '1078', '1', 'Canada (general)', 'CA.00', 'NULL', '1492');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1492', '112', '3369', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CA.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3370', '1078', '1', 'Alberta', 'CA.01', 'NULL', '1493');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1493', '112', '3370', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CA.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3371', '1078', '1', 'British Columbia', 'CA.02', 'NULL', '1494');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1494', '112', '3371', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CA.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3372', '1078', '1', 'Manitoba', 'CA.03', 'NULL', '1495');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1495', '112', '3372', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CA.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3373', '1078', '1', 'New Brunswick', 'CA.04', 'NULL', '1496');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1496', '112', '3373', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CA.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3374', '1078', '1', 'Newfoundland and Labrador', 'CA.05', 'NULL', '1497');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1497', '112', '3374', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CA.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3375', '1078', '1', 'Nova Scotia', 'CA.07', 'NULL', '1498');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1498', '112', '3375', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CA.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3376', '1078', '1', 'Ontario', 'CA.08', 'NULL', '1499');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1499', '112', '3376', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CA.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3377', '1078', '1', 'Prince Edward Island', 'CA.09', 'NULL', '1500');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1500', '112', '3377', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CA.09» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3378', '1078', '1', 'Quebec', 'CA.10', 'NULL', '1501');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1501', '112', '3378', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CA.10» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3379', '1078', '1', 'Saskatchewan', 'CA.11', 'NULL', '1502');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1502', '112', '3379', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CA.11» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3380', '1078', '1', 'Yukon', 'CA.12', 'NULL', '1503');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1503', '112', '3380', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CA.12» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3381', '1078', '1', 'Northwest Territories', 'CA.13', 'NULL', '1504');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1504', '112', '3381', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CA.13» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3382', '1078', '1', 'Nunavut', 'CA.14', 'NULL', '1505');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1505', '112', '3382', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CA.14» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3383', '1078', '1', 'Cocos (Keeling) Islands (general)', 'CC.00', 'NULL', '1506');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1506', '112', '3383', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CC.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3384', '1078', '1', 'Congo, Democratic Republic of The (general)', 'CD.00', 'NULL', '1507');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1507', '112', '3384', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CD.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3385', '1078', '1', 'Bandundu', 'CD.01', 'NULL', '1508');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1508', '112', '3385', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CD.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3386', '1078', '1', 'Équateur', 'CD.02', 'NULL', '1509');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1509', '112', '3386', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CD.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3387', '1078', '1', 'Kasaï-Occidental', 'CD.03', 'NULL', '1510');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1510', '112', '3387', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CD.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3388', '1078', '1', 'Kasaï-Oriental', 'CD.04', 'NULL', '1511');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1511', '112', '3388', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CD.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3389', '1078', '1', 'Katanga', 'CD.05', 'NULL', '1512');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1512', '112', '3389', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CD.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3390', '1078', '1', 'Kinshasa', 'CD.06', 'NULL', '1513');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1513', '112', '3390', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CD.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3391', '1078', '1', 'Kivu Région du', 'CD.07', 'NULL', '1514');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1514', '112', '3391', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CD.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3392', '1078', '1', 'Bas-Congo', 'CD.08', 'NULL', '1515');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1515', '112', '3392', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CD.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3393', '1078', '1', 'Orientale', 'CD.09', 'NULL', '1516');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1516', '112', '3393', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CD.09» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3394', '1078', '1', 'Maniema', 'CD.10', 'NULL', '1517');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1517', '112', '3394', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CD.10» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3395', '1078', '1', 'Nord-Kivu', 'CD.11', 'NULL', '1518');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1518', '112', '3395', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CD.11» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3396', '1078', '1', 'Sud-Kivu', 'CD.12', 'NULL', '1519');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1519', '112', '3396', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CD.12» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3397', '1078', '1', 'Central African Republic (general)', 'CF.00', 'NULL', '1520');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1520', '112', '3397', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CF.00» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3398', '1078', '1', 'Bamingui-Bangoran', 'CF.01', 'NULL', '1521');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1521', '112', '3398', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CF.01» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3399', '1078', '1', 'Basse-Kotto', 'CF.02', 'NULL', '1522');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1522', '112', '3399', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CF.02» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3400', '1078', '1', 'Haute-Kotto', 'CF.03', 'NULL', '1523');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1523', '112', '3400', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CF.03» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3401', '1078', '1', 'Mambéré-Kadéï', 'CF.04', 'NULL', '1524');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1524', '112', '3401', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CF.04» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3402', '1078', '1', 'Haut-Mbomou', 'CF.05', 'NULL', '1525');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1525', '112', '3402', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CF.05» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3403', '1078', '1', 'Kémo', 'CF.06', 'NULL', '1526');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1526', '112', '3403', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CF.06» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3404', '1078', '1', 'Lobaye', 'CF.07', 'NULL', '1527');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1527', '112', '3404', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CF.07» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3405', '1078', '1', 'Mbomou', 'CF.08', 'NULL', '1528');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1528', '112', '3405', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CF.08» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3406', '1078', '1', 'Nana-Mambéré', 'CF.09', 'NULL', '1529');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1529', '112', '3406', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CF.09» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3407', '1078', '1', 'Ouaka', 'CF.11', 'NULL', '1530');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1530', '112', '3407', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CF.11» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3408', '1078', '1', 'Ouham', 'CF.12', 'NULL', '1531');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1531', '112', '3408', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CF.12» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3409', '1078', '1', 'Ouham-Pendé', 'CF.13', 'NULL', '1532');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1532', '112', '3409', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CF.13» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3410', '1078', '1', 'Vakaga', 'CF.14', 'NULL', '1533');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1533', '112', '3410', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CF.14» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3411', '1078', '1', 'Nana-Grébizi', 'CF.15', 'NULL', '1534');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1534', '112', '3411', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CF.15» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3412', '1078', '1', 'Sangha-Mbaéré', 'CF.16', 'NULL', '1535');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) VALUES 
	('1535', '112', '3412', NULL , '2009-07-29 00:00:00' , 'Initialisation de la valeur «CF.16» pour la liste «75».', '1', '1', '162.38.234.1');
INSERT INTO `tb_coel`.`coel_meta_liste_valeur` (`cmlv_id_valeur` ,`cmlv_ce_parent` ,`cmlv_ce_projet` ,`cmlv_nom` ,`cmlv_abreviation` ,`cmlv_description` ,`cmlv_ce_meta`) VALUES 
	('3413', '1078', '1', 'Ombella-Mpoko', 'CF.17', 'NULL', '1536');
INSERT INTO `tb_coel`.`coel_meta_historique_ligne` (`cmhl_id_historique_ligne` ,`cmhl_ce_table` ,`cmhl_cle_ligne` ,`cmhl_enregistrement` ,`cmhl_date_modification` ,`cmhl_notes` ,`cmhl_ce_modifier_par` ,`cmhl_ce_etat` ,`cmhl_ip`) 