<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" version="1.0" encoding="UTF-8" indent="yes"/>
	
	<xsl:template match="/macroelement">&lt;?
	  
		<xsl:apply-templates select="//balise2" mode="require_once"/>
		
	
		
		class <xsl:value-of select="@nom"/> extends macroElement {
		
			
			function getSQL()
			{
				$contexte = array();
				<xsl:apply-templates select="requetes/requete"/>
				return;
			}
		
			<!--function buildRoot()
			{
				<xsl:apply_templates select="mapping" mode="root"/>
			}

			-->
		
		}
		
		
?&gt;
	</xsl:template>
	
	<xsl:template match="mapping" mode="root">
		<xsl:apply-templates select="*[@root]" mode="level1root"/>
	</xsl:template>
	
	<xsl:template match="requete">
	  			if (<xsl:apply-templates select="parametres/parametre" mode="isnull"/>) 
	  			{	
	  				<xsl:apply-templates select="parametres/parametre" mode="contexte"/>
	  				if(<xsl:apply-templates select="parametres/parametre" mode="renseigne"/>)
	  				{	return "<xsl:value-of select="sql"/>";  }
	  			}
	</xsl:template>
	
	<xsl:template match="parametre[position()=last()]" mode="isnull">array_key_exists('<xsl:value-of select="@nom"/>',$this->contexteRef) </xsl:template>
	
	<xsl:template match="parametre" mode="isnull">array_key_exists('<xsl:value-of select="@nom"/>',$this->contexteRef) and </xsl:template>
	
	<xsl:template match="parametre" mode="contexte">
					$contexte['<xsl:value-of select="@nom"/>']= $this->contexteRef['<xsl:value-of select="@nom"/>'];
	</xsl:template>

	<xsl:template match="parametre[position()=last()]" mode="renseigne">!empty($contexte['<xsl:value-of select="@nom"/>']) </xsl:template>

	<xsl:template match="parametre" mode="renseigne">!empty($contexte['<xsl:value-of select="@nom"/>']) and </xsl:template>

	
	<xsl:template match="*" mode="level1root">
	   	$element= new domElement('<xsl:value-of select="name()"/>');
			$this->baseDOM->appendChild($element);
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="text()"/>
	</xsl:template>
	
   <xsl:template match="mapping" mode="fetch">
   	<xsl:apply-templates select="*" mode="level1"/>
	</xsl:template>
	
	<xsl:template match="*" mode="level1">
	   	$element= new domElement('<xsl:value-of select="name()"/>');
			$this->baseDOM->appendChild($element);
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="text()"/>
		<xsl:apply-templates select="*" mode="level2"/>
	</xsl:template>
	
	<xsl:template match="*" mode="level2">
			$this->baseDOM = $element;
	   	$element= new domElement('<xsl:value-of select="name()"/>');
			$this->baseDOM->appendChild($element);
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="text()"/>
		<xsl:apply-templates select="*" mode="level3"/>
	</xsl:template>
	
	<xsl:template match="*" mode="level3">
			$this->baseDOM = $element;
	   	$element= new domElement('<xsl:value-of select="name()"/>');
			$this->baseDOM->appendChild($element);
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="text()"/>
		<xsl:apply-templates select="*" mode="level4"/>
	</xsl:template>
	
	<xsl:template match="*" mode="level4">
			$this->baseDOM = $element;
	   	$element= new domElement('<xsl:value-of select="name()"/>');
			$this->baseDOM->appendChild($element);
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="text()"/>
	
	</xsl:template>
	
	<xsl:template match="@*">
			$element->setAttribute('<xsl:value-of select="name()"/>',<xsl:value-of select="."/>);
	</xsl:template>
	
	<xsl:template match="text()">
		/*text(<xsl:value-of select="."/>)*/
	</xsl:template>
	
	
</xsl:stylesheet>
